/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import java.util.Arrays;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.Jsck;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.jsck.Storage;
import org.jsimpledb.util.ByteReader;

abstract class Index
extends Storage {
    protected Index(JsckInfo info, int storageId) {
        super(info, storageId);
    }

    public final void validateIndexEntry(JsckInfo info, ByteReader reader) {
        int entryStorageId = (Integer)this.validateEncodedValue(reader, FieldTypeRegistry.UNSIGNED_INT);
        assert (entryStorageId == this.storageId);
        this.validateIndexEntryContent(info, reader);
    }

    protected abstract void validateIndexEntryContent(JsckInfo var1, ByteReader var2);

    protected void validateSimpleObjectField(JsckInfo info, ObjId id, int storageId, FieldType<?> type, byte[] expectedValue) {
        byte[] actualValue;
        if (info.getConfig().isRepair() && !Arrays.equals(expectedValue, (actualValue = info.getKVStore().get(this.buildFieldKey(id, storageId).getBytes())) != null ? actualValue : type.getDefaultValue())) {
            throw new IllegalArgumentException("field value != " + Jsck.ds(expectedValue));
        }
    }

    @Override
    protected void validateObjectExists(JsckInfo info, ByteReader reader, ObjId id) {
        try {
            super.validateObjectExists(info, reader, id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid index entry: " + e.getMessage());
        }
    }

    @Override
    protected <T> byte[] validateEncodedBytes(ByteReader reader, FieldType<T> type) {
        try {
            return super.validateEncodedBytes(reader, type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid index entry: " + e.getMessage());
        }
    }

    @Override
    protected void validateEOF(ByteReader reader) {
        try {
            super.validateEOF(reader);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid index entry: " + e.getMessage());
        }
    }
}

