/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.core.InvalidSchemaException;
import org.jsimpledb.core.Layout;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.jsck.Index;
import org.jsimpledb.jsck.InvalidKey;
import org.jsimpledb.jsck.InvalidValue;
import org.jsimpledb.jsck.Issue;
import org.jsimpledb.jsck.JsckConfig;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.jsck.MaxIssuesReachedException;
import org.jsimpledb.jsck.ObjectType;
import org.jsimpledb.jsck.Storage;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.ParseContext;
import org.jsimpledb.util.UnsignedIntEncoder;

public class Jsck {
    private static final int HEX_STRING_LIMIT = 100;
    private final JsckConfig config;

    public Jsck(JsckConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"null config");
        this.config = config;
    }

    public long check(KVStore kv, Consumer<? super Issue> consumer) {
        JsckInfo info;
        try {
            info = new JsckInfo(this.config, kv, consumer);
        }
        catch (MaxIssuesReachedException e) {
            return 0L;
        }
        try {
            this.doCheck(info);
        }
        catch (MaxIssuesReachedException maxIssuesReachedException) {
            // empty catch block
        }
        return info.getNumberOfIssuesHandled();
    }

    /*
     * WARNING - void declaration
     */
    private void doCheck(JsckInfo info) {
        int[] indexStorageIds;
        Object pair;
        PeekingIterator i;
        int[] objectTypeStorageIds;
        void var11_19;
        byte[] formatVersionKey = Layout.getFormatVersionKey();
        byte[] schemaKeyPrefix = Layout.getSchemaKeyPrefix();
        byte[] objectVersionIndexKeyPrefix = Layout.getObjectVersionIndexKeyPrefix();
        byte[] userMetaDataKeyPrefix = Layout.getUserMetaDataKeyPrefix();
        assert (schemaKeyPrefix[0] == 0);
        assert (objectVersionIndexKeyPrefix[0] == 0);
        assert (userMetaDataKeyPrefix[0] == 0);
        assert (ByteUtil.compare((byte[])schemaKeyPrefix, (byte[])formatVersionKey) > 0);
        assert (ByteUtil.compare((byte[])objectVersionIndexKeyPrefix, (byte[])schemaKeyPrefix) > 0);
        assert (ByteUtil.compare((byte[])userMetaDataKeyPrefix, (byte[])objectVersionIndexKeyPrefix) > 0);
        info.info("checking format version");
        int forceFormatVersion = this.config.getForceFormatVersion();
        if (forceFormatVersion < 0 || forceFormatVersion > 2) {
            forceFormatVersion = 0;
        }
        KVStore kv = info.getKVStore();
        byte[] val = kv.get(formatVersionKey);
        try {
            if (val == null) {
                throw new IllegalArgumentException(kv.getAtLeast(ByteUtil.EMPTY, null) == null ? "database is empty" : "missing JSimpleDB signature/format version key " + Jsck.ds(formatVersionKey));
            }
            ByteReader reader = new ByteReader(val);
            try {
                info.setFormatVersion(UnsignedIntEncoder.read((ByteReader)reader));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid JSimpleDB signature/format version value " + Jsck.ds(val) + ": can't decode version number");
            }
            if (reader.remain() > 0) {
                throw new IllegalArgumentException("invalid JSimpleDB signature/format version value " + Jsck.ds(val) + ": trailing garbage " + Jsck.ds(reader, reader.getOffset()) + " follows format version number " + info.getFormatVersion());
            }
            switch (info.getFormatVersion()) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid JSimpleDB signature/format version key value " + Jsck.ds(val) + ": unrecognized format version number " + info.getFormatVersion());
                }
            }
        }
        catch (IllegalArgumentException e) {
            if (forceFormatVersion == 0) {
                throw e;
            }
            info.setFormatVersion(forceFormatVersion);
            byte[] newValue = UnsignedIntEncoder.encode((int)info.getFormatVersion());
            info.handle(new InvalidValue(formatVersionKey, val, newValue).setDetail(e.getMessage()));
        }
        this.checkEmpty(info, new KeyRange(ByteUtil.EMPTY, Layout.getFormatVersionKey()), "key range prior to format version");
        this.checkEmpty(info, new KeyRange(ByteUtil.getNextKey((byte[])Layout.getFormatVersionKey()), schemaKeyPrefix), "key range between format version and recorded schemas");
        info.info("checking recorded schema versions");
        Map<Integer, Object> forceSchemaVersions = this.config.getForceSchemaVersions();
        if (forceSchemaVersions == null) {
            forceSchemaVersions = Collections.emptyMap();
        }
        Throwable throwable = null;
        try (CloseableIterator i2 = kv.getRange(Layout.getSchemaKeyRange());){
            while (i2.hasNext()) {
                SchemaModel schema;
                int version;
                block132: {
                    SchemaModel forcedSchema;
                    KVPair pair2 = (KVPair)i2.next();
                    version = 0;
                    schema = null;
                    try {
                        ByteReader reader = new ByteReader(pair2.getKey());
                        reader.skip(schemaKeyPrefix.length);
                        version = UnsignedIntEncoder.read((ByteReader)reader);
                        if (reader.remain() > 0) {
                            throw new IllegalArgumentException("invalid schema entry key " + Jsck.ds(pair2.getKey()) + ": trailing garbage " + Jsck.ds(reader, reader.getOffset()) + " follows format version number " + info.getFormatVersion());
                        }
                        if (version == 0) {
                            throw new IllegalArgumentException("invalid schema entry key " + Jsck.ds(val) + ": version number is zero");
                        }
                        try {
                            schema = Layout.decodeSchema((byte[])pair2.getValue(), (int)info.getFormatVersion());
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("invalid encoded schema: " + e.getMessage(), e);
                        }
                        catch (InvalidSchemaException e) {
                            throw new IllegalArgumentException("invalid schema model: " + e.getMessage(), e);
                        }
                        if (!forceSchemaVersions.containsKey(version) || schema.equals((Object)(forcedSchema = (SchemaModel)forceSchemaVersions.get(version)))) break block132;
                        if (forcedSchema != null) {
                            byte[] newValue = Layout.encodeSchema((SchemaModel)forcedSchema, (int)info.getFormatVersion());
                            info.handle(new InvalidValue(pair2, newValue).setDetail("forcibly override schema version " + version + " with provided version having these differences: " + forcedSchema.differencesFrom(schema)));
                            schema = forcedSchema;
                            break block132;
                        }
                        info.handle(new InvalidValue(pair2).setDetail("forcibly delete schema version " + version));
                    }
                    catch (IllegalArgumentException e) {
                        if (version == 0) {
                            info.handle(new InvalidKey(pair2).setDetail(e.getMessage()));
                            continue;
                        }
                        if (!forceSchemaVersions.containsKey(version)) {
                            throw new IllegalArgumentException("schema version " + version + " is invalid (forced schema override required): " + e.getMessage(), e);
                        }
                        forcedSchema = (SchemaModel)forceSchemaVersions.get(version);
                        if (forcedSchema != null) {
                            info.handle(new InvalidValue(pair2, Layout.encodeSchema((SchemaModel)forcedSchema, (int)info.getFormatVersion())).setDetail("forcibly override invalid schema version " + version + " which is invalid anyway: " + e.getMessage()));
                            schema = forcedSchema;
                            break block132;
                        }
                        info.handle(new InvalidValue(pair2).setDetail("forcibly delete schema version " + version + " which is invalid anyway: " + e.getMessage()));
                    }
                    continue;
                }
                assert (schema != null);
                info.info("validating schema version " + version);
                try {
                    Database.validateSchema((FieldTypeRegistry)this.config.getFieldTypeRegistry(), (SchemaModel)schema);
                }
                catch (InvalidSchemaException e) {
                    throw new IllegalArgumentException((schema == forceSchemaVersions.get(version) ? "forced " : "") + "schema version " + version + " is invalid (forced schema override required): " + e.getMessage(), e);
                }
                info.getSchemas().put(version, schema);
            }
        }
        catch (Throwable pair2) {
            Throwable throwable2 = pair2;
            throw pair2;
        }
        for (Map.Entry entry : forceSchemaVersions.entrySet()) {
            int version = (Integer)entry.getKey();
            SchemaModel schema = (SchemaModel)entry.getValue();
            if (info.getSchemas().containsKey(version)) continue;
            try {
                Database.validateSchema((FieldTypeRegistry)this.config.getFieldTypeRegistry(), (SchemaModel)schema);
            }
            catch (InvalidSchemaException e) {
                throw new IllegalArgumentException("forced schema version " + version + " is invalid: " + e.getMessage(), e);
            }
            ByteWriter writer = new ByteWriter(schemaKeyPrefix.length + 5);
            writer.write(schemaKeyPrefix);
            UnsignedIntEncoder.write((ByteWriter)writer, (int)version);
            byte[] newKey = writer.getBytes();
            byte[] newValue = Layout.encodeSchema((SchemaModel)schema, (int)info.getFormatVersion());
            info.handle(new InvalidValue(newKey, null, newValue).setDetail("forcibly override schema version " + version + " with provided version"));
        }
        info.info("validating schema compatibility among all versions " + info.getSchemas().keySet());
        try {
            Database.validateSchemas((FieldTypeRegistry)this.config.getFieldTypeRegistry(), info.getSchemas().values());
        }
        catch (InvalidSchemaException e) {
            throw new IllegalArgumentException("database schemas are mutually inconsistent (forced schema override(s) required): " + e.getMessage(), e);
        }
        info.inventoryStorages();
        this.checkEmpty(info, new KeyRange(ByteUtil.getKeyAfterPrefix((byte[])schemaKeyPrefix), objectVersionIndexKeyPrefix), "key range between recorded schemas and object version index");
        this.checkEmpty(info, new KeyRange(ByteUtil.getKeyAfterPrefix((byte[])objectVersionIndexKeyPrefix), Layout.getUserMetaDataKeyPrefix()), "key range between object version index and user meta-data");
        int[] allStorageIds = info.getStorages().values().stream().map(Map::keySet).flatMapToInt(keys -> keys.stream().mapToInt(Integer::intValue)).sorted().distinct().toArray();
        byte[] byArray = ByteUtil.getKeyAfterPrefix((byte[])Layout.getUserMetaDataKeyPrefix());
        String prevDescription = "user meta-data";
        for (int storageId : allStorageIds) {
            byte[] stopKey = UnsignedIntEncoder.encode((int)storageId);
            String nextDescription = "storage ID " + storageId;
            this.checkEmpty(info, new KeyRange((byte[])var11_19, stopKey), "key range between " + prevDescription + " and " + nextDescription);
            byte[] byArray2 = this.getKeyRange(storageId).getMax();
            prevDescription = nextDescription;
        }
        this.checkEmpty(info, new KeyRange((byte[])var11_19, new byte[]{-1}), "key range after " + prevDescription);
        for (int storageId : objectTypeStorageIds = info.getStorages().values().stream().map(Map::values).flatMap(Collection::stream).filter(ObjectType.class::isInstance).mapToInt(Storage::getStorageId).sorted().distinct().toArray()) {
            String rangeDescription = "the key range of object type storage ID " + storageId;
            info.info("checking " + rangeDescription);
            try (CloseableIterator ci = kv.getRange(this.getKeyRange(storageId));){
                i = Iterators.peekingIterator((Iterator)ci);
                while (i.hasNext()) {
                    int version;
                    SchemaObjectType objectType;
                    ObjId id;
                    byte[] idKey;
                    block134: {
                        pair = (KVPair)i.next();
                        idKey = pair.getKey();
                        if (idKey.length < 8) {
                            info.handle(new InvalidKey((KVPair)pair).setDetail("invalid key " + Jsck.ds(idKey) + " in " + rangeDescription + ": key is truncated (length " + idKey.length + " < " + 8 + ")"));
                            continue;
                        }
                        ByteReader idKeyReader = new ByteReader(idKey);
                        id = new ObjId(idKeyReader);
                        if (info.isDetailEnabled()) {
                            info.detail("checking object meta-data for " + id);
                        }
                        objectType = null;
                        version = 0;
                        if (idKeyReader.remain() > 0) {
                            String detail = "invalid key " + Jsck.ds(idKey) + " in " + rangeDescription + ": no such object " + id + " exists";
                            int fieldStorageId = -1;
                            try {
                                fieldStorageId = UnsignedIntEncoder.read((ByteReader)idKeyReader);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            if (fieldStorageId > 0 && idKeyReader.remain() == 0) {
                                detail = detail + " (possibly orphaned content for field #" + fieldStorageId + ")";
                            }
                            info.handle(new InvalidKey((KVPair)pair).setDetail(detail));
                        } else {
                            ByteReader metaData = new ByteReader(pair.getValue());
                            try {
                                int metaDataVersion = UnsignedIntEncoder.read((ByteReader)metaData);
                                switch (metaDataVersion) {
                                    case 1: {
                                        break;
                                    }
                                    case 0: {
                                        throw new IllegalArgumentException("invalid zero object meta-data format version");
                                    }
                                    default: {
                                        throw new IllegalArgumentException("unknown object meta-data format version " + metaDataVersion);
                                    }
                                }
                            }
                            catch (IllegalArgumentException e) {
                                info.handle(new InvalidValue((KVPair)pair).setDetail("invalid meta-data " + Jsck.ds(metaData) + " for object " + id + ": can't decode object meta-data format version: " + e.getMessage()));
                                break block134;
                            }
                            try {
                                version = UnsignedIntEncoder.read((ByteReader)metaData);
                                if (version == 0) {
                                    throw new IllegalArgumentException("invalid zero version number");
                                }
                            }
                            catch (IllegalArgumentException e) {
                                info.handle(new InvalidValue((KVPair)pair).setDetail("invalid meta-data " + Jsck.ds(metaData) + " for object " + id + ": can't decode object schema version: " + e.getMessage()));
                                break block134;
                            }
                            SchemaModel schema = info.getSchemas().get(version);
                            if (schema == null) {
                                info.handle(new InvalidValue((KVPair)pair).setDetail("invalid meta-data " + Jsck.ds(metaData) + " for object " + id + ": invalid schema version " + version + ": no such schema version exists"));
                            } else {
                                objectType = (SchemaObjectType)schema.getSchemaObjectTypes().get(id.getStorageId());
                                if (objectType == null) {
                                    info.handle(new InvalidValue((KVPair)pair).setDetail("invalid object ID " + id + " with storage ID " + id.getStorageId() + ": no such object type exists in schema version " + version));
                                } else {
                                    int mark = metaData.mark();
                                    try {
                                        if (metaData.remain() == 0) {
                                            throw new IllegalArgumentException("missing delete notified byte");
                                        }
                                        int deleteNotified = metaData.readByte();
                                        if (deleteNotified != 0) {
                                            throw new IllegalArgumentException(String.format("invalid notified byte 0x%02x != 0x00", deleteNotified));
                                        }
                                        if (metaData.remain() > 0) {
                                            throw new IllegalArgumentException("meta-data contains extra garbage");
                                        }
                                    }
                                    catch (IllegalArgumentException e) {
                                        ByteWriter fixup = new ByteWriter(mark + 1);
                                        fixup.write(metaData.getBytes(0, mark));
                                        fixup.writeByte(0);
                                        info.handle(new InvalidValue((KVPair)pair, fixup.getBytes()).setDetail("invalid meta-data " + Jsck.ds(metaData) + " for object " + id + ": " + e.getMessage()));
                                    }
                                }
                            }
                        }
                    }
                    if (objectType == null) {
                        Jsck.deleteRange(info, idKey, (PeekingIterator<KVPair>)i, "object " + id);
                        continue;
                    }
                    ObjectType objType = (ObjectType)info.getStorages().get(version).get(id.getStorageId());
                    assert (objType != null);
                    assert (version > 0);
                    if (info.isDetailEnabled()) {
                        info.detail("checking object content for " + id);
                    }
                    objType.validateObjectData(info, id, version, (PeekingIterator<KVPair>)i);
                }
            }
        }
        for (int storageId : indexStorageIds = info.getStorages().values().stream().map(Map::values).flatMap(Collection::stream).filter(Index.class::isInstance).mapToInt(Storage::getStorageId).sorted().distinct().toArray()) {
            Index index = info.getIndexes().get(storageId);
            String rangeDescription = "the key range of " + index;
            info.info("checking " + rangeDescription);
            i = kv.getRange(index.getKeyRange());
            pair = null;
            try {
                while (i.hasNext()) {
                    KVPair pair3 = (KVPair)i.next();
                    ByteReader reader = new ByteReader(pair3.getKey());
                    try {
                        index.validateIndexEntry(info, reader);
                    }
                    catch (IllegalArgumentException e) {
                        info.handle(new InvalidKey(pair3).setDetail(index, e.getMessage()));
                        continue;
                    }
                    if (pair3.getValue().length <= 0) continue;
                    info.handle(new InvalidValue(pair3, ByteUtil.EMPTY).setDetail(index, "value should be empty"));
                }
            }
            catch (Throwable throwable3) {
                pair = throwable3;
                throw throwable3;
            }
            finally {
                if (i != null) {
                    if (pair != null) {
                        try {
                            i.close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)pair).addSuppressed(throwable4);
                        }
                    } else {
                        i.close();
                    }
                }
            }
        }
        info.info("checking object version index; recorded schema versions are " + info.getSchemas().keySet());
        HashSet<Integer> unusedSchemaVersions = new HashSet<Integer>(info.getSchemas().keySet());
        try (CloseableIterator i3 = kv.getRange(KeyRange.forPrefix((byte[])objectVersionIndexKeyPrefix));){
            while (i3.hasNext()) {
                ObjId id;
                int version;
                KVPair pair4 = (KVPair)i3.next();
                ByteReader reader = new ByteReader(pair4.getKey());
                reader.skip(objectVersionIndexKeyPrefix.length);
                try {
                    version = UnsignedIntEncoder.read((ByteReader)reader);
                }
                catch (IllegalArgumentException e) {
                    info.handle(new InvalidKey(pair4).setDetail("invalid object version index entry " + Jsck.ds(reader.getBytes()) + ": can't interpret version number: " + e.getMessage()));
                    continue;
                }
                try {
                    id = new ObjId(reader);
                    if (reader.remain() > 0) {
                        throw new IllegalArgumentException("index entry contains extra garbage");
                    }
                }
                catch (IllegalArgumentException e) {
                    info.handle(new InvalidKey(pair4).setDetail("invalid object version index entry " + Jsck.ds(reader.getBytes()) + " for version " + version + ": can't interpret object ID: " + e.getMessage()));
                    continue;
                }
                if (kv.get(id.getBytes()) == null) {
                    info.handle(new InvalidKey(pair4).setDetail("invalid object version index entry " + Jsck.ds(reader.getBytes()) + " for version " + version + ": object " + id + " does not exist"));
                    continue;
                }
                if (unusedSchemaVersions.remove(version) && this.config.isGarbageCollectSchemas()) {
                    info.info("marking schema version " + version + " in use");
                }
                if (pair4.getValue().length <= 0) continue;
                info.handle(new InvalidValue(pair4, ByteUtil.EMPTY).setDetail("invalid object version index entry " + Jsck.ds(reader.getBytes()) + " for version " + version + ": value is " + Jsck.ds(pair4.getValue()) + " but should be empty"));
            }
        }
        if (this.config.isGarbageCollectSchemas()) {
            info.info("garbage collecting unused schema versions: " + unusedSchemaVersions);
            for (int version : unusedSchemaVersions) {
                byte[] key = Layout.getSchemaKey((int)version);
                byte[] value = kv.get(key);
                if (value == null) continue;
                info.handle(new InvalidKey("unused schema version", key, null).setDetail("schema version " + version));
            }
        }
    }

    static void deleteRange(JsckInfo info, byte[] prefix, PeekingIterator<KVPair> i, String description) {
        while (i.hasNext() && ByteUtil.isPrefixOf((byte[])prefix, (byte[])((KVPair)i.peek()).getKey())) {
            KVPair pair2 = (KVPair)i.next();
            assert (ByteUtil.compare((byte[])pair2.getKey(), (byte[])prefix) >= 0);
            info.handle(new InvalidKey(pair2).setDetail("invalid key " + Jsck.ds(pair2.getKey()) + " in the key range of non-existent/invalid " + description));
        }
    }

    static String ds(byte[] data) {
        return "[" + ParseContext.truncate((String)ByteUtil.toString((byte[])data), (int)100) + "]";
    }

    static String ds(ByteReader reader) {
        return Jsck.ds(reader.getBytes());
    }

    static String ds(ByteReader reader, int off) {
        return Jsck.ds(reader.getBytes(off));
    }

    private long checkEmpty(JsckInfo info, KeyRange range, String description) {
        info.info("checking that " + description + " is empty");
        long count = 0L;
        try (CloseableIterator i = info.getKVStore().getRange(range);){
            while (i.hasNext()) {
                KVPair pair = (KVPair)i.next();
                info.handle(new InvalidKey(pair.getKey(), pair.getValue()).setDetail(description));
            }
        }
        return count;
    }

    private KeyRange getKeyRange(int storageId) {
        return KeyRange.forPrefix((byte[])UnsignedIntEncoder.encode((int)storageId));
    }
}

