/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.jsimpledb.core.FieldTypeRegistry;
import org.jsimpledb.jsck.JsckLogger;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.schema.SchemaModel;
import org.slf4j.LoggerFactory;

public class JsckConfig {
    private JsckLogger logger = JsckLogger.wrap(LoggerFactory.getLogger(this.getClass()));
    private KeyRanges keysToInspect;
    private FieldTypeRegistry fieldTypeRegistry = new FieldTypeRegistry();
    private boolean garbageCollectSchemas;
    private Map<Integer, SchemaModel> forceSchemaVersions;
    private int forceFormatVersion;
    private long maxIssues = Long.MAX_VALUE;
    private boolean repair;

    public KeyRanges getKeysToInspect() {
        return this.keysToInspect;
    }

    public void setKeysToInspect(KeyRanges keysToInspect) {
        this.keysToInspect = keysToInspect;
    }

    public FieldTypeRegistry getFieldTypeRegistry() {
        return this.fieldTypeRegistry;
    }

    public void setFieldTypeRegistry(FieldTypeRegistry fieldTypeRegistry) {
        Preconditions.checkArgument((fieldTypeRegistry != null ? 1 : 0) != 0, (Object)"null fieldTypeRegistry");
        this.fieldTypeRegistry = fieldTypeRegistry;
    }

    public boolean isGarbageCollectSchemas() {
        return this.garbageCollectSchemas;
    }

    public void setGarbageCollectSchemas(boolean garbageCollectSchemas) {
        this.garbageCollectSchemas = garbageCollectSchemas;
    }

    public JsckLogger getJsckLogger() {
        return this.logger;
    }

    public void setJsckLogger(JsckLogger logger) {
        this.logger = logger;
    }

    public boolean isRepair() {
        return this.repair;
    }

    public void setRepair(boolean repair) {
        this.repair = repair;
    }

    public Map<Integer, SchemaModel> getForceSchemaVersions() {
        return this.forceSchemaVersions;
    }

    public void setForceSchemaVersions(Map<Integer, SchemaModel> forceSchemaVersions) {
        this.forceSchemaVersions = forceSchemaVersions;
    }

    public int getForceFormatVersion() {
        return this.forceFormatVersion;
    }

    public void setForceFormatVersion(int forceFormatVersion) {
        Preconditions.checkArgument((forceFormatVersion >= 0 ? 1 : 0) != 0, (Object)"forceFormatVersion < 0");
        Preconditions.checkArgument((forceFormatVersion <= 2 ? 1 : 0) != 0, (Object)"unrecognized forceFormatVersion > 2");
        this.forceFormatVersion = forceFormatVersion;
    }

    public long getMaxIssues() {
        return this.maxIssues;
    }

    public void setMaxIssues(long maxIssues) {
        Preconditions.checkArgument((maxIssues >= 0L ? 1 : 0) != 0, (Object)"maxIssues < 0");
        this.maxIssues = maxIssues;
    }
}

