/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.type.EnumFieldType;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.jsck.CompositeIndex;
import org.jsimpledb.jsck.Index;
import org.jsimpledb.jsck.Issue;
import org.jsimpledb.jsck.JsckConfig;
import org.jsimpledb.jsck.JsckLogger;
import org.jsimpledb.jsck.ListElementIndex;
import org.jsimpledb.jsck.MapKeyIndex;
import org.jsimpledb.jsck.MapValueIndex;
import org.jsimpledb.jsck.MaxIssuesReachedException;
import org.jsimpledb.jsck.ObjectType;
import org.jsimpledb.jsck.SetElementIndex;
import org.jsimpledb.jsck.SimpleFieldIndex;
import org.jsimpledb.jsck.Storage;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.schema.CounterSchemaField;
import org.jsimpledb.schema.EnumSchemaField;
import org.jsimpledb.schema.ListSchemaField;
import org.jsimpledb.schema.MapSchemaField;
import org.jsimpledb.schema.ReferenceSchemaField;
import org.jsimpledb.schema.SchemaCompositeIndex;
import org.jsimpledb.schema.SchemaField;
import org.jsimpledb.schema.SchemaFieldSwitch;
import org.jsimpledb.schema.SchemaFieldSwitchAdapter;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.schema.SetSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;

class JsckInfo
implements JsckLogger {
    private final JsckConfig config;
    private final KVStore kv;
    private final AtomicLong counter = new AtomicLong();
    private final Map<Integer, SchemaModel> schemas = new HashMap<Integer, SchemaModel>();
    private final Map<Integer, Map<Integer, Storage>> storages = new HashMap<Integer, Map<Integer, Storage>>();
    private final Map<Integer, Index> indexes = new HashMap<Integer, Index>();
    private final Consumer<? super Issue> handler;
    private int formatVersion;

    JsckInfo(JsckConfig config, KVStore kv, Consumer<? super Issue> handler) {
        this.config = config;
        this.kv = kv;
        this.handler = handler;
        if (this.config.getMaxIssues() <= 0L) {
            throw new MaxIssuesReachedException();
        }
    }

    public JsckConfig getConfig() {
        return this.config;
    }

    public KVStore getKVStore() {
        return this.kv;
    }

    public Map<Integer, SchemaModel> getSchemas() {
        return this.schemas;
    }

    public Map<Integer, Map<Integer, Storage>> getStorages() {
        return this.storages;
    }

    public Map<Integer, Index> getIndexes() {
        return this.indexes;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    public void handle(Issue issue) {
        if (this.config.isRepair()) {
            issue.apply(this.kv);
        }
        if (this.handler != null) {
            this.handler.accept(issue);
        }
        if (this.counter.incrementAndGet() >= this.config.getMaxIssues()) {
            throw new MaxIssuesReachedException();
        }
    }

    public long getNumberOfIssuesHandled() {
        return this.counter.get();
    }

    @Override
    public boolean isDetailEnabled() {
        JsckLogger logger = this.config.getJsckLogger();
        return logger != null && logger.isDetailEnabled();
    }

    @Override
    public void info(String message) {
        JsckLogger logger = this.config.getJsckLogger();
        if (logger != null) {
            logger.info(message);
        }
    }

    @Override
    public void detail(String message) {
        JsckLogger logger = this.config.getJsckLogger();
        if (logger != null && logger.isDetailEnabled()) {
            logger.detail(message);
        }
    }

    void inventoryStorages() {
        for (Map.Entry<Integer, SchemaModel> entry : this.schemas.entrySet()) {
            this.inventoryStorages((int)entry.getKey(), entry.getValue());
        }
    }

    private void inventoryStorages(int schemaVersion, SchemaModel schema) {
        for (SchemaObjectType objectType : schema.getSchemaObjectTypes().values()) {
            this.inventoryStorages(schemaVersion, objectType);
        }
    }

    private void inventoryStorages(final int schemaVersion, SchemaObjectType objectType) {
        this.addStorage(schemaVersion, new ObjectType(this, objectType));
        for (SchemaField field : objectType.getSchemaFields().values()) {
            field.visit((SchemaFieldSwitch)new SchemaFieldSwitchAdapter<Void>(){

                public Void caseSimpleSchemaField(SimpleSchemaField field) {
                    if (field.isIndexed()) {
                        JsckInfo.this.addStorage(schemaVersion, new SimpleFieldIndex(JsckInfo.this, schemaVersion, field));
                    }
                    return null;
                }

                public Void caseSetSchemaField(SetSchemaField field) {
                    if (field.getElementField().isIndexed()) {
                        JsckInfo.this.addStorage(schemaVersion, new SetElementIndex(JsckInfo.this, schemaVersion, field));
                    }
                    return null;
                }

                public Void caseListSchemaField(ListSchemaField field) {
                    if (field.getElementField().isIndexed()) {
                        JsckInfo.this.addStorage(schemaVersion, new ListElementIndex(JsckInfo.this, schemaVersion, field));
                    }
                    return null;
                }

                public Void caseMapSchemaField(MapSchemaField field) {
                    if (field.getKeyField().isIndexed()) {
                        JsckInfo.this.addStorage(schemaVersion, new MapKeyIndex(JsckInfo.this, schemaVersion, field));
                    }
                    if (field.getValueField().isIndexed()) {
                        JsckInfo.this.addStorage(schemaVersion, new MapValueIndex(JsckInfo.this, schemaVersion, field));
                    }
                    return null;
                }

                public Void caseCounterSchemaField(CounterSchemaField field) {
                    return null;
                }
            });
        }
        for (SchemaCompositeIndex index : objectType.getSchemaCompositeIndexes().values()) {
            this.addStorage(schemaVersion, new CompositeIndex(this, schemaVersion, objectType, index));
        }
    }

    FieldType<?> findFieldType(final int schemaVersion, SimpleSchemaField schemaField) {
        return (FieldType)schemaField.visit((SchemaFieldSwitch)new SchemaFieldSwitchAdapter<FieldType<?>>(){

            public FieldType<?> caseEnumSchemaField(EnumSchemaField field) {
                return new EnumFieldType(field.getIdentifiers());
            }

            public FieldType<?> caseReferenceSchemaField(ReferenceSchemaField field) {
                return new ReferenceFieldType((Set)field.getObjectTypes());
            }

            public FieldType<?> caseSimpleSchemaField(SimpleSchemaField field) {
                FieldType fieldType = JsckInfo.this.config.getFieldTypeRegistry().getFieldType(field.getType(), field.getEncodingSignature());
                if (fieldType == null) {
                    throw new IllegalArgumentException("no FieldType named `" + field.getType() + "'" + (field.getEncodingSignature() != 0L ? " with signature " + field.getEncodingSignature() : "") + " (used by " + field + " in schema version " + schemaVersion + ") was found in the configured FieldTypeRepository");
                }
                assert (fieldType.getEncodingSignature() == field.getEncodingSignature());
                return fieldType;
            }
        });
    }

    private void addStorage(int schemaVersion, Storage storage) {
        storage.setSchemaVersion(schemaVersion);
        int storageId = storage.getStorageId();
        for (Map<Integer, Storage> map : this.storages.values()) {
            Storage other = map.get(storageId);
            assert (other == null || !(storage instanceof ObjectType) || !(other instanceof ObjectType));
            if (other == null || storage.isCompatible(other)) continue;
            throw new IllegalArgumentException("schemas conflict for storage ID " + storageId + ":\n  in schema version " + other.getSchemaVersion() + ": " + other + ":\n  in schema version " + storage.getSchemaVersion() + ": " + storage);
        }
        this.storages.computeIfAbsent(schemaVersion, v -> new HashMap()).put(storageId, storage);
        if (storage instanceof Index) {
            this.indexes.put(storageId, (Index)storage);
        }
    }
}

