/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public interface JsckLogger {
    public void info(String var1);

    public void detail(String var1);

    public boolean isDetailEnabled();

    public static JsckLogger wrap(Logger logger) {
        Preconditions.checkArgument((logger != null ? 1 : 0) != 0);
        return JsckLogger.wrap(logger, (Level)(logger.isInfoEnabled() ? Level.INFO : null), (Level)(logger.isTraceEnabled() ? Level.TRACE : null));
    }

    public static JsckLogger wrap(final Logger logger, final Level infoLevel, final Level detailLevel) {
        Preconditions.checkArgument((logger != null ? 1 : 0) != 0);
        return new JsckLogger(){

            @Override
            public boolean isDetailEnabled() {
                return this.isEnabled(detailLevel);
            }

            @Override
            public void info(String message) {
                this.log(infoLevel, message);
            }

            @Override
            public void detail(String message) {
                this.log(detailLevel, message);
            }

            private void log(Level level, String message) {
                if (!this.isEnabled(level)) {
                    return;
                }
                switch (level) {
                    case TRACE: {
                        logger.trace(message);
                        break;
                    }
                    case DEBUG: {
                        logger.debug(message);
                        break;
                    }
                    case INFO: {
                        logger.info(message);
                        break;
                    }
                    case WARN: {
                        logger.warn(message);
                        break;
                    }
                    case ERROR: {
                        logger.error(message);
                        break;
                    }
                }
            }

            private boolean isEnabled(Level level) {
                if (level == null) {
                    return false;
                }
                switch (level) {
                    case TRACE: {
                        return logger.isTraceEnabled();
                    }
                    case DEBUG: {
                        return logger.isDebugEnabled();
                    }
                    case INFO: {
                        return logger.isInfoEnabled();
                    }
                    case WARN: {
                        return logger.isWarnEnabled();
                    }
                    case ERROR: {
                        return logger.isErrorEnabled();
                    }
                }
                return false;
            }
        };
    }
}

