/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.jsck;

import com.google.common.collect.PeekingIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.core.Layout;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.type.EnumFieldType;
import org.jsimpledb.core.type.ReferenceFieldType;
import org.jsimpledb.jsck.InvalidKey;
import org.jsimpledb.jsck.InvalidValue;
import org.jsimpledb.jsck.Jsck;
import org.jsimpledb.jsck.JsckInfo;
import org.jsimpledb.jsck.MissingKey;
import org.jsimpledb.jsck.Storage;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.schema.CollectionSchemaField;
import org.jsimpledb.schema.ComplexSchemaField;
import org.jsimpledb.schema.CounterSchemaField;
import org.jsimpledb.schema.EnumSchemaField;
import org.jsimpledb.schema.ListSchemaField;
import org.jsimpledb.schema.MapSchemaField;
import org.jsimpledb.schema.ReferenceSchemaField;
import org.jsimpledb.schema.SchemaCompositeIndex;
import org.jsimpledb.schema.SchemaField;
import org.jsimpledb.schema.SchemaFieldSwitch;
import org.jsimpledb.schema.SchemaFieldSwitchAdapter;
import org.jsimpledb.schema.SchemaObjectType;
import org.jsimpledb.schema.SetSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.jsimpledb.util.UnsignedIntEncoder;

class ObjectType
extends Storage {
    private final SchemaObjectType objType;
    private final HashMap<Integer, FieldType<?>> simpleFieldTypes = new HashMap();
    private final HashSet<SimpleSchemaField> indexedSimpleFields = new HashSet();

    ObjectType(final JsckInfo info, SchemaObjectType objType) {
        super(info, objType.getStorageId());
        this.objType = objType;
        for (SchemaField field : objType.getSchemaFields().values()) {
            field.visit((SchemaFieldSwitch)new SchemaFieldSwitchAdapter<Void>(){

                protected Void caseCollectionSchemaField(CollectionSchemaField field) {
                    field.getElementField().visit((SchemaFieldSwitch)this);
                    return null;
                }

                public Void caseMapSchemaField(MapSchemaField field) {
                    field.getKeyField().visit((SchemaFieldSwitch)this);
                    field.getValueField().visit((SchemaFieldSwitch)this);
                    return null;
                }

                public Void caseSimpleSchemaField(SimpleSchemaField field) {
                    FieldType fieldType = info.getConfig().getFieldTypeRegistry().getFieldType(field.getType());
                    ObjectType.this.simpleFieldTypes.put(field.getStorageId(), fieldType);
                    return null;
                }

                public Void caseEnumSchemaField(EnumSchemaField field) {
                    ObjectType.this.simpleFieldTypes.put(field.getStorageId(), new EnumFieldType(field.getIdentifiers()));
                    return null;
                }

                public Void caseReferenceSchemaField(ReferenceSchemaField field) {
                    ObjectType.this.simpleFieldTypes.put(field.getStorageId(), new ReferenceFieldType((Set)field.getObjectTypes()));
                    return null;
                }

                public Void caseCounterSchemaField(CounterSchemaField field) {
                    return null;
                }
            });
        }
        for (SchemaField field : objType.getSchemaFields().values()) {
            field.visit((SchemaFieldSwitch)new SchemaFieldSwitchAdapter<Void>(){

                public Void caseSimpleSchemaField(SimpleSchemaField field) {
                    if (field.isIndexed()) {
                        ObjectType.this.indexedSimpleFields.add(field);
                    }
                    return null;
                }

                protected Void caseDefault(SchemaField field) {
                    return null;
                }
            });
        }
    }

    public void validateObjectData(final JsckInfo info, final ObjId id, int version, final PeekingIterator<KVPair> i) {
        KVPair pair;
        byte[] key;
        byte[] objectPrefix = id.getBytes();
        final HashSet<SimpleSchemaField> indexedSimpleFieldsWithDefaultValues = new HashSet<SimpleSchemaField>(this.indexedSimpleFields);
        final HashMap<Integer, byte[]> simpleFieldValues = new HashMap<Integer, byte[]>();
        while (i.hasNext() && ByteUtil.isPrefixOf((byte[])objectPrefix, (byte[])(key = (pair = (KVPair)i.peek()).getKey()))) {
            int storageId;
            assert (key.length > 8);
            ByteReader keyReader = new ByteReader(key, 8);
            try {
                storageId = UnsignedIntEncoder.read((ByteReader)keyReader);
            }
            catch (IllegalArgumentException e) {
                info.handle(new InvalidKey(pair).setDetail(id, "invalid field storage ID"));
                continue;
            }
            if (storageId <= 0) {
                info.handle(new InvalidKey(pair).setDetail(id, "invalid field storage ID " + storageId));
                continue;
            }
            SchemaField field = (SchemaField)this.objType.getSchemaFields().get(storageId);
            if (field == null) {
                info.handle(new InvalidKey(pair).setDetail(id, "invalid field storage ID " + storageId + ": no such field exists in " + this.objType));
                continue;
            }
            final byte[] fieldPrefix = keyReader.getBytes(0, keyReader.getOffset());
            if (info.isDetailEnabled()) {
                info.detail("checking object " + id + " " + field);
            }
            field.visit((SchemaFieldSwitch)new SchemaFieldSwitchAdapter<Void>(){

                public Void caseSimpleSchemaField(SimpleSchemaField field) {
                    byte[] value = ObjectType.this.checkSimpleField(info, id, field, fieldPrefix, (PeekingIterator<KVPair>)i);
                    simpleFieldValues.put(field.getStorageId(), value);
                    if (value != null) {
                        indexedSimpleFieldsWithDefaultValues.remove(field);
                    }
                    return null;
                }

                public Void caseSetSchemaField(SetSchemaField field) {
                    ObjectType.this.checkSetField(info, id, field, fieldPrefix, (PeekingIterator<KVPair>)i);
                    return null;
                }

                public Void caseListSchemaField(ListSchemaField field) {
                    ObjectType.this.checkListField(info, id, field, fieldPrefix, (PeekingIterator<KVPair>)i);
                    return null;
                }

                public Void caseMapSchemaField(MapSchemaField field) {
                    ObjectType.this.checkMapField(info, id, field, fieldPrefix, (PeekingIterator<KVPair>)i);
                    return null;
                }

                public Void caseCounterSchemaField(CounterSchemaField field) {
                    ObjectType.this.checkCounterField(info, id, field, fieldPrefix, (PeekingIterator<KVPair>)i);
                    return null;
                }
            });
        }
        assert (!i.hasNext() || !ByteUtil.isPrefixOf((byte[])objectPrefix, (byte[])((KVPair)i.peek()).getKey()));
        for (SimpleSchemaField field : indexedSimpleFieldsWithDefaultValues) {
            FieldType<?> fieldType = this.simpleFieldTypes.get(field.getStorageId());
            byte[] defaultValue = fieldType.getDefaultValue();
            this.verifySimpleIndexEntry(info, id, field, defaultValue);
        }
        for (SchemaCompositeIndex index : this.objType.getSchemaCompositeIndexes().values()) {
            this.verifyCompositeIndexEntry(info, id, index, simpleFieldValues);
        }
        this.verifyVersionIndexEntry(info, id, version);
    }

    private byte[] checkSimpleField(JsckInfo info, ObjId id, SimpleSchemaField field, byte[] prefix, PeekingIterator<KVPair> i) {
        FieldType<?> fieldType = this.simpleFieldTypes.get(field.getStorageId());
        assert (fieldType != null);
        KVPair pair = (KVPair)i.next();
        assert (pair != null);
        assert (ByteUtil.isPrefixOf((byte[])prefix, (byte[])pair.getKey()));
        if (pair.getKey().length > prefix.length) {
            info.handle(new InvalidKey(pair).setDetail(id, (SchemaField)field, "trailing garbage " + Jsck.ds(new ByteReader(pair.getKey(), prefix.length))));
            return null;
        }
        byte[] value = pair.getValue();
        ByteReader reader = new ByteReader(pair.getValue());
        if (!this.validateSimpleFieldValue(info, id, field, pair, reader)) {
            value = null;
        }
        if (value != null && ByteUtil.compare((byte[])value, (byte[])fieldType.getDefaultValue()) == 0) {
            info.handle(new InvalidValue(pair).setDetail("default value; should not be present"));
            value = null;
        }
        if (field.isIndexed()) {
            this.verifySimpleIndexEntry(info, id, field, value != null ? value : fieldType.getDefaultValue());
        }
        return value;
    }

    private void checkSetField(JsckInfo info, ObjId id, SetSchemaField field, byte[] prefix, PeekingIterator<KVPair> i) {
        SimpleSchemaField elementField = field.getElementField();
        while (i.hasNext() && ByteUtil.isPrefixOf((byte[])prefix, (byte[])((KVPair)i.peek()).getKey())) {
            ByteReader reader;
            KVPair pair = (KVPair)i.next();
            if (!this.validateSimpleFieldValue(info, id, elementField, pair, reader = new ByteReader(pair.getKey(), prefix.length))) continue;
            if (pair.getValue().length != 0) {
                info.handle(new InvalidValue(pair, ByteUtil.EMPTY).setDetail(id, (SchemaField)elementField, "should be empty"));
            }
            if (!elementField.isIndexed()) continue;
            this.verifySimpleIndexEntry(info, id, elementField, (ComplexSchemaField)field, reader.getBytes(prefix.length), ByteUtil.EMPTY);
        }
    }

    private void checkMapField(JsckInfo info, ObjId id, MapSchemaField field, byte[] prefix, PeekingIterator<KVPair> i) {
        SimpleSchemaField keyField = field.getKeyField();
        SimpleSchemaField valField = field.getValueField();
        while (i.hasNext() && ByteUtil.isPrefixOf((byte[])prefix, (byte[])((KVPair)i.peek()).getKey())) {
            ByteReader valReader;
            ByteReader keyReader;
            KVPair pair = (KVPair)i.next();
            if (!this.validateSimpleFieldValue(info, id, keyField, pair, keyReader = new ByteReader(pair.getKey(), prefix.length)) || !this.validateSimpleFieldValue(info, id, valField, pair, valReader = new ByteReader(pair.getValue()))) continue;
            if (keyField.isIndexed()) {
                this.verifySimpleIndexEntry(info, id, keyField, (ComplexSchemaField)field, keyReader.getBytes(prefix.length), ByteUtil.EMPTY);
            }
            if (!valField.isIndexed()) continue;
            this.verifySimpleIndexEntry(info, id, valField, (ComplexSchemaField)field, pair.getValue(), keyReader.getBytes(prefix.length));
        }
    }

    private void checkListField(JsckInfo info, ObjId id, ListSchemaField field, byte[] prefix, PeekingIterator<KVPair> i) {
        SimpleSchemaField elementField = field.getElementField();
        int expectedIndex = 0;
        while (i.hasNext() && ByteUtil.isPrefixOf((byte[])prefix, (byte[])((KVPair)i.peek()).getKey())) {
            int actualIndex;
            KVPair pair = (KVPair)i.next();
            ByteReader keyReader = new ByteReader(pair.getKey(), prefix.length);
            try {
                try {
                    actualIndex = UnsignedIntEncoder.read((ByteReader)keyReader);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("invalid list index: " + e.getMessage(), e);
                }
                if (keyReader.remain() > 0) {
                    throw new IllegalArgumentException("trailing garbage " + Jsck.ds(keyReader, keyReader.getOffset()) + " after encoded index " + actualIndex);
                }
            }
            catch (IllegalArgumentException e) {
                info.handle(new InvalidValue(pair).setDetail(id, (SchemaField)elementField, e.getMessage()));
                continue;
            }
            ByteReader valReader = new ByteReader(pair.getValue());
            if (!this.validateSimpleFieldValue(info, id, elementField, pair, valReader)) continue;
            byte[] encodedIndex = keyReader.getBytes(prefix.length);
            if (actualIndex != expectedIndex) {
                info.handle(new InvalidValue(pair).setDetail(id, (SchemaField)elementField, "wrong index " + actualIndex + " != " + expectedIndex));
                ByteWriter keyWriter = new ByteWriter(prefix.length + UnsignedIntEncoder.encodeLength((int)actualIndex));
                keyWriter.write(prefix);
                UnsignedIntEncoder.write((ByteWriter)keyWriter, (int)expectedIndex);
                encodedIndex = keyWriter.getBytes(prefix.length);
                info.handle(new MissingKey("incorrect list index", keyWriter.getBytes(), pair.getValue()).setDetail(id, (SchemaField)elementField, "renumbered list index " + actualIndex + " -> " + expectedIndex));
            }
            ++expectedIndex;
            if (!elementField.isIndexed()) continue;
            this.verifySimpleIndexEntry(info, id, elementField, (ComplexSchemaField)field, pair.getValue(), encodedIndex);
        }
    }

    private void checkCounterField(JsckInfo info, ObjId id, CounterSchemaField field, byte[] prefix, PeekingIterator<KVPair> i) {
        KVPair pair = (KVPair)i.next();
        assert (pair != null);
        assert (ByteUtil.isPrefixOf((byte[])prefix, (byte[])pair.getKey()));
        if (pair.getKey().length > prefix.length) {
            info.handle(new InvalidKey(pair).setDetail(id, (SchemaField)field, "trailing garbage " + Jsck.ds(new ByteReader(pair.getKey(), prefix.length))));
            return;
        }
        try {
            info.getKVStore().decodeCounter(pair.getValue());
        }
        catch (IllegalArgumentException e) {
            info.handle(new InvalidValue(pair).setDetail(id, (SchemaField)field, " (resetting to zero): " + e.getMessage()));
        }
    }

    private boolean validateSimpleFieldValue(JsckInfo info, ObjId id, SimpleSchemaField field, KVPair pair, ByteReader reader) {
        FieldType<?> fieldType = this.simpleFieldTypes.get(field.getStorageId());
        assert (fieldType != null);
        try {
            ReferenceSchemaField referenceField;
            Object value = fieldType.read(reader);
            if (reader.remain() > 0) {
                throw new IllegalArgumentException("trailing garbage " + Jsck.ds(reader, reader.getOffset()));
            }
            if (value != null && field instanceof ReferenceSchemaField && !(referenceField = (ReferenceSchemaField)field).isAllowDeleted()) {
                assert (fieldType instanceof ReferenceFieldType);
                ObjId target = (ObjId)value;
                if (info.getKVStore().get(target.getBytes()) == null) {
                    throw new IllegalArgumentException("invalid reference to deleted object " + target);
                }
            }
        }
        catch (IllegalArgumentException e) {
            info.handle(new InvalidValue(pair).setDetail(id, (SchemaField)field, e.getMessage()));
            return false;
        }
        return true;
    }

    private void verifySimpleIndexEntry(JsckInfo info, ObjId id, SimpleSchemaField field, byte[] value) {
        this.verifySimpleIndexEntry(info, id, field.getStorageId(), "" + field + " index", value, ByteUtil.EMPTY);
    }

    private void verifySimpleIndexEntry(JsckInfo info, ObjId id, SimpleSchemaField subField, ComplexSchemaField field, byte[] value, byte[] suffix) {
        this.verifySimpleIndexEntry(info, id, subField.getStorageId(), "sub-" + subField + " of " + field + " index", value, suffix);
    }

    private void verifySimpleIndexEntry(JsckInfo info, ObjId id, int storageId, String description, byte[] value, byte[] suffix) {
        int length = UnsignedIntEncoder.encodeLength((int)storageId) + value.length + 8 + suffix.length;
        ByteWriter writer = new ByteWriter(length);
        UnsignedIntEncoder.write((ByteWriter)writer, (int)storageId);
        writer.write(value);
        id.writeTo(writer);
        writer.write(suffix);
        this.verifyIndexEntry(info, id, writer.getBytes(), description);
    }

    private void verifyCompositeIndexEntry(JsckInfo info, ObjId id, SchemaCompositeIndex index, HashMap<Integer, byte[]> simpleFieldValues) {
        ByteWriter writer = new ByteWriter();
        UnsignedIntEncoder.write((ByteWriter)writer, (int)index.getStorageId());
        Iterator iterator = index.getIndexedFields().iterator();
        while (iterator.hasNext()) {
            int storageId = (Integer)iterator.next();
            byte[] value = simpleFieldValues.get(storageId);
            if (value == null) {
                value = this.simpleFieldTypes.get(storageId).getDefaultValue();
            }
            writer.write(value);
        }
        id.writeTo(writer);
        this.verifyIndexEntry(info, id, writer.getBytes(), "" + index);
    }

    private void verifyVersionIndexEntry(JsckInfo info, ObjId id, int version) {
        ByteWriter writer = new ByteWriter();
        writer.write(Layout.getObjectVersionIndexKeyPrefix());
        UnsignedIntEncoder.write((ByteWriter)writer, (int)version);
        id.writeTo(writer);
        this.verifyIndexEntry(info, id, writer.getBytes(), "object version index");
    }

    private void verifyIndexEntry(JsckInfo info, ObjId id, byte[] key, String description) {
        byte[] value;
        if (info.isDetailEnabled()) {
            info.detail("checking object " + id + " " + description + " entry");
        }
        if ((value = info.getKVStore().get(key)) == null) {
            info.handle(new MissingKey("missing index entry for " + description, key, ByteUtil.EMPTY));
        } else if (value.length != 0) {
            info.handle(new InvalidValue("invalid non-empty value for " + description, key, value, ByteUtil.EMPTY));
        }
    }

    @Override
    public String toString() {
        return this.objType.toString();
    }
}

