/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.instance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.spanner.admin.instance.v1.InstanceConfigNameType;

public class InstanceConfigName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instanceConfigs/{instance_config}");
    private final String project;
    private final String instanceConfig;

    public String getProject() {
        return this.project;
    }

    public String getInstanceConfig() {
        return this.instanceConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private InstanceConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instanceConfig = (String)Preconditions.checkNotNull((Object)builder.getInstanceConfig());
    }

    public static InstanceConfigName create(String project, String instanceConfig) {
        return InstanceConfigName.newBuilder().setProject(project).setInstanceConfig(instanceConfig).build();
    }

    public static InstanceConfigName parse(String formattedString) {
        ImmutableMap matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "InstanceConfigName.parse: formattedString not in valid format");
        return InstanceConfigName.create((String)matchMap.get((Object)"project"), (String)matchMap.get((Object)"instance_config"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return InstanceConfigNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance_config", this.instanceConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceConfigName) {
            InstanceConfigName that = (InstanceConfigName)o;
            return this.project.equals(that.project) && this.instanceConfig.equals(that.instanceConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.instanceConfig.hashCode();
    }

    public static class Builder {
        private String project;
        private String instanceConfig;

        public String getProject() {
            return this.project;
        }

        public String getInstanceConfig() {
            return this.instanceConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstanceConfig(String instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(InstanceConfigName instanceConfigName) {
            this.project = instanceConfigName.project;
            this.instanceConfig = instanceConfigName.instanceConfig;
        }

        public InstanceConfigName build() {
            return new InstanceConfigName(this);
        }
    }
}

