/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenTransactionInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    private WebApplicationContext webApplicationContext;
    private String transactionManagerBeanName = "transactionManager";
    private PlatformTransactionManager transactionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFilterBean() throws ServletException {
        WebApplicationContext wac;
        super.initFilterBean();
        this.log.debug("finding containing WebApplicationContext");
        try {
            wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        }
        catch (IllegalStateException illegalStateException) {
            throw new ServletException("could not locate containing WebApplicationContext");
        }
        OpenTransactionInViewFilter openTransactionInViewFilter = this;
        synchronized (openTransactionInViewFilter) {
            this.webApplicationContext = wac;
        }
    }

    public void setIsolation(String isolation) {
        this.transactionDefinition.setIsolationLevelName(isolation);
    }

    public void setPropagation(String propagation) {
        this.transactionDefinition.setPropagationBehaviorName(propagation);
    }

    public void setReadOnly(boolean readOnly) {
        this.transactionDefinition.setReadOnly(readOnly);
    }

    public synchronized void setTransactionManagerBeanName(String transactionManagerBeanName) {
        this.transactionManagerBeanName = transactionManagerBeanName;
    }

    protected synchronized PlatformTransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = (PlatformTransactionManager)this.webApplicationContext.getBean(this.transactionManagerBeanName, PlatformTransactionManager.class);
        }
        return this.transactionManager;
    }

    protected void doFilterInternal(final HttpServletRequest request, final HttpServletResponse response, final FilterChain filterChain) throws ServletException, IOException {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.getTransactionManager(), (TransactionDefinition)this.transactionDefinition);
        try {
            transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction(TransactionStatus status) {
                    try {
                        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ServletException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            });
        }
        catch (RuntimeException e) {
            Throwable nested = e.getCause();
            if (nested instanceof IOException) {
                throw (IOException)nested;
            }
            if (nested instanceof ServletException) {
                throw (ServletException)nested;
            }
            throw e;
        }
    }
}

