/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.protobuf.PathTemplate;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;

public final class InstanceId {
    private static final PathTemplate NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}/instances/{instance}");
    private final String project;
    private final String instance;

    InstanceId(String project, String instance) {
        this.project = project;
        this.instance = instance;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getProject() {
        return this.project;
    }

    public String getName() {
        return String.format("projects/%s/instances/%s", this.project, this.instance);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.project, this.instance});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceId that = (InstanceId)o;
        return that.project.equals(this.project) && that.instance.equals(this.instance);
    }

    public String toString() {
        return this.getName();
    }

    static InstanceId of(String name) {
        ImmutableMap parts = NAME_TEMPLATE.match(name);
        Preconditions.checkArgument((parts != null ? 1 : 0) != 0, (String)"Name should conform to pattern %s: %s", (Object[])new Object[]{NAME_TEMPLATE, name});
        return InstanceId.of((String)parts.get((Object)"project"), (String)parts.get((Object)"instance"));
    }

    public static InstanceId of(String project, String instance) {
        return new InstanceId(project, instance);
    }
}

