/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.protobuf.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class Key {
    private static final Joiner joiner = Joiner.on((char)',').useForNull("<null>");
    private static final Value NULL_PROTO = Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
    private final List<Object> parts;

    private Key(List<Object> parts) {
        this.parts = Collections.unmodifiableList(parts);
    }

    public static Key of(Object ... values) {
        Preconditions.checkNotNull((Object)values, (Object)"'values' cannot be null.  For a literal key containing a single null value, call Key.of((Object) null).");
        Builder b = new Builder(false);
        for (Object value : values) {
            b.appendObject(value);
        }
        return b.build();
    }

    public static Builder newBuilder() {
        return new Builder(true);
    }

    public int size() {
        return this.parts.size();
    }

    public Iterable<Object> getParts() {
        return this.parts;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    void toString(StringBuilder b) {
        b.append('[');
        joiner.appendTo(b, this.parts);
        b.append(']');
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key that = (Key)o;
        return this.parts.equals(that.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    ListValue toProto() {
        ListValue.Builder builder = ListValue.newBuilder();
        for (Object part : this.parts) {
            if (part == null) {
                builder.addValues(NULL_PROTO);
                continue;
            }
            if (part instanceof Boolean) {
                builder.addValuesBuilder().setBoolValue(((Boolean)part).booleanValue());
                continue;
            }
            if (part instanceof Long) {
                builder.addValuesBuilder().setStringValue(part.toString());
                continue;
            }
            if (part instanceof Double) {
                builder.addValuesBuilder().setNumberValue(((Double)part).doubleValue());
                continue;
            }
            if (part instanceof String) {
                builder.addValuesBuilder().setStringValue((String)part);
                continue;
            }
            if (part instanceof ByteArray) {
                builder.addValuesBuilder().setStringValue(((ByteArray)part).toBase64());
                continue;
            }
            if (part instanceof Timestamp) {
                builder.addValuesBuilder().setStringValue(((Timestamp)part).toString());
                continue;
            }
            throw new AssertionError((Object)("Illegal key part: " + part.getClass()));
        }
        return builder.build();
    }

    public static class Builder {
        private final boolean canEscape;
        private final ArrayList<Object> buffer = new ArrayList();

        private Builder(boolean canEscape) {
            this.canEscape = canEscape;
        }

        private Builder(Key key) {
            this.canEscape = true;
            this.buffer.addAll(key.parts);
        }

        public Builder append(@Nullable Boolean value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(long value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(@Nullable Long value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(double value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(@Nullable Double value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(@Nullable String value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(@Nullable ByteArray value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(@Nullable Timestamp value) {
            this.buffer.add(value);
            return this;
        }

        public Builder append(@Nullable Date value) {
            this.buffer.add(value);
            return this;
        }

        public Builder appendObject(@Nullable Object value) {
            if (value == null) {
                this.append((Boolean)null);
            } else if (value instanceof Boolean) {
                this.append((Boolean)value);
            } else if (value instanceof Integer) {
                this.append(((Integer)value).intValue());
            } else if (value instanceof Long) {
                this.append((Long)value);
            } else if (value instanceof Float) {
                this.append(((Float)value).floatValue());
            } else if (value instanceof Double) {
                this.append((Double)value);
            } else if (value instanceof String) {
                this.append((String)value);
            } else if (value instanceof ByteArray) {
                this.append((ByteArray)value);
            } else if (value instanceof Timestamp) {
                this.append((Timestamp)value);
            } else if (value instanceof Date) {
                this.append((Date)value);
            } else {
                throw new IllegalArgumentException("Unsupported type [" + value.getClass().getCanonicalName() + "] for argument: " + value);
            }
            return this;
        }

        public Key build() {
            if (this.canEscape) {
                return new Key(new ArrayList<Object>(this.buffer));
            }
            return new Key(this.buffer);
        }
    }
}

