/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.base.Preconditions;

public class SessionPoolOptions {
    private final int minSessions;
    private final int maxSessions;
    private final int maxIdleSessions;
    private final float writeSessionsFraction;
    private final ActionOnExhaustion actionOnExhaustion;
    private final int keepAliveIntervalMinutes;

    private SessionPoolOptions(Builder builder) {
        this.minSessions = builder.minSessions;
        this.maxSessions = builder.maxSessions;
        this.maxIdleSessions = builder.maxIdleSessions;
        this.writeSessionsFraction = builder.writeSessionsFraction;
        this.actionOnExhaustion = builder.actionOnExhaustion;
        this.keepAliveIntervalMinutes = builder.keepAliveIntervalMinutes;
    }

    public int getMinSessions() {
        return this.minSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public int getMaxIdleSessions() {
        return this.maxIdleSessions;
    }

    public float getWriteSessionsFraction() {
        return this.writeSessionsFraction;
    }

    public int getKeepAliveIntervalMinutes() {
        return this.keepAliveIntervalMinutes;
    }

    public boolean isFailIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.FAIL;
    }

    public boolean isBlockIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.BLOCK;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int minSessions;
        private int maxSessions = Integer.MAX_VALUE;
        private int maxIdleSessions;
        private float writeSessionsFraction = 0.2f;
        private ActionOnExhaustion actionOnExhaustion = ActionOnExhaustion.BLOCK;
        private int keepAliveIntervalMinutes = 30;

        public Builder setMinSessions(int minSessions) {
            Preconditions.checkArgument((this.maxSessions >= minSessions ? 1 : 0) != 0, (Object)"Min sessions must be <= max sessions");
            this.minSessions = minSessions;
            return this;
        }

        public Builder setMaxSessions(int maxSessions) {
            Preconditions.checkArgument((maxSessions >= this.minSessions ? 1 : 0) != 0, (Object)"Max sessions must be >= minsessions");
            this.maxSessions = maxSessions;
            return this;
        }

        public Builder setMaxIdleSessions(int maxIdleSessions) {
            this.maxIdleSessions = maxIdleSessions;
            return this;
        }

        public Builder setKeepAliveIntervalMinutes(int intervalMinutes) {
            Preconditions.checkArgument((intervalMinutes < 60 ? 1 : 0) != 0, (Object)"Keep alive interval should be less than60 minutes");
            this.keepAliveIntervalMinutes = intervalMinutes;
            return this;
        }

        public Builder setFailIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.FAIL;
            return this;
        }

        public Builder setBlockIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.BLOCK;
            return this;
        }

        public Builder setWriteSessionsFraction(float writeSessionsFraction) {
            Preconditions.checkArgument((writeSessionsFraction >= 0.0f && writeSessionsFraction <= 1.0f ? 1 : 0) != 0, (Object)"Fraction of write sessions must be between 0 and 1 (inclusive)");
            this.writeSessionsFraction = writeSessionsFraction;
            return this;
        }

        public SessionPoolOptions build() {
            return new SessionPoolOptions(this);
        }
    }

    private static enum ActionOnExhaustion {
        BLOCK,
        FAIL;

    }
}

