/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Statement {
    private final ImmutableMap<String, Value> parameters;
    private final String sql;

    private Statement(String sql, ImmutableMap<String, Value> parameters) {
        this.sql = sql;
        this.parameters = parameters;
    }

    public static Statement of(String sql) {
        return Statement.newBuilder(sql).build();
    }

    public static Builder newBuilder(String sql) {
        return new Builder(sql);
    }

    public boolean hasBinding(String parameter) {
        return this.parameters.containsKey((Object)parameter);
    }

    public ResultSet executeQuery(ReadContext context, Options.QueryOption ... options) {
        return context.executeQuery(this, options);
    }

    public ResultSet analyzeQuery(ReadContext context, ReadContext.QueryAnalyzeMode queryMode) {
        return context.analyzeQuery(this, queryMode);
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, Value> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement that = (Statement)o;
        return Objects.equals(this.sql, that.sql) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.sql, this.parameters);
    }

    StringBuilder toString(StringBuilder b) {
        b.append(this.sql);
        if (!this.parameters.isEmpty()) {
            b.append(" {");
            int n = 0;
            for (Map.Entry parameter : this.parameters.entrySet()) {
                if (n++ > 0) {
                    b.append(", ");
                }
                b.append((String)parameter.getKey()).append(": ");
                ((Value)parameter.getValue()).toString(b);
            }
            b.append("}");
        }
        return b;
    }

    public static final class Builder {
        final Map<String, Value> parameters = new HashMap<String, Value>();
        private final StringBuilder sqlBuffer;
        private String currentBinding;
        private final ValueBinder<Builder> binder = new Binder();

        private Builder(String sql) {
            this.sqlBuffer = new StringBuilder(sql);
        }

        public Builder append(String sqlFragment) {
            this.sqlBuffer.append((String)Preconditions.checkNotNull((Object)sqlFragment));
            return this;
        }

        public ValueBinder<Builder> bind(String parameter) {
            Preconditions.checkState((this.currentBinding == null ? 1 : 0) != 0, (String)"Cannot bind new parameter. Previous binding of parameter '%s' is incomplete.", (Object[])new Object[]{this.currentBinding});
            this.currentBinding = parameter;
            return this.binder;
        }

        public Statement build() {
            Preconditions.checkState((this.currentBinding == null ? 1 : 0) != 0, (String)"Binding for parameter '%s' is incomplete.", (Object[])new Object[]{this.currentBinding});
            return new Statement(this.sqlBuffer.toString(), ImmutableMap.copyOf(this.parameters));
        }

        private class Binder
        extends ValueBinder<Builder> {
            private Binder() {
            }

            @Override
            Builder handle(Value value) {
                Preconditions.checkState((Builder.this.currentBinding != null ? 1 : 0) != 0, (Object)"No binding in progress");
                Builder.this.parameters.put(Builder.this.currentBinding, value);
                Builder.this.currentBinding = null;
                return Builder.this;
            }
        }
    }
}

