/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import java.util.HashSet;
import javax.annotation.concurrent.GuardedBy;
import org.jsimpledb.kv.raft.FollowerRole;
import org.jsimpledb.kv.raft.LeaderRole;
import org.jsimpledb.kv.raft.NewLogEntry;
import org.jsimpledb.kv.raft.NonLeaderRole;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Service;
import org.jsimpledb.kv.raft.msg.AppendRequest;
import org.jsimpledb.kv.raft.msg.CommitResponse;
import org.jsimpledb.kv.raft.msg.GrantVote;
import org.jsimpledb.kv.raft.msg.InstallSnapshot;
import org.jsimpledb.kv.raft.msg.RequestVote;

public class CandidateRole
extends NonLeaderRole {
    @GuardedBy(value="raft")
    private final HashSet<String> votes = new HashSet();
    private final Service checkElectionResultService = new Service(this, "check election result"){

        @Override
        public void run() {
            CandidateRole.this.checkElectionResult();
        }
    };

    CandidateRole(RaftKVDatabase raft) {
        super(raft, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVotesRequired() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.raft.currentConfig.size() / 2 + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVotesReceived() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.votes.size() + (this.raft.isClusterMember() ? 1 : 0);
        }
    }

    @Override
    void setup() {
        assert (Thread.holdsLock(this.raft));
        super.setup();
        if (!this.raft.advanceTerm(this.raft.currentTerm + 1L)) {
            return;
        }
        HashSet<String> voters = new HashSet<String>(this.raft.currentConfig.keySet());
        voters.remove(this.raft.identity);
        if (this.log.isDebugEnabled()) {
            this.debug("entering candidate role in term " + this.raft.currentTerm + "; requesting votes from " + voters);
        }
        for (String voter : voters) {
            this.raft.sendMessage(new RequestVote(this.raft.clusterId, this.raft.identity, voter, this.raft.currentTerm, this.raft.getLastLogTerm(), this.raft.getLastLogIndex()));
        }
        this.raft.requestService(this.checkElectionResultService);
    }

    @Override
    void outputQueueEmpty(String address) {
        assert (Thread.holdsLock(this.raft));
    }

    @Override
    void handleElectionTimeout() {
        assert (Thread.holdsLock(this.raft));
        this.raft.changeRole(new CandidateRole(this.raft));
    }

    private void checkElectionResult() {
        assert (Thread.holdsLock(this.raft));
        int allVotes = this.raft.currentConfig.size();
        int numVotes = this.getVotesReceived();
        int votesRequired = this.getVotesRequired();
        if (this.log.isDebugEnabled()) {
            this.debug("current election tally: " + numVotes + "/" + allVotes + " with " + votesRequired + " required to win");
        }
        if (numVotes >= votesRequired) {
            if (this.log.isDebugEnabled()) {
                this.debug("won the election for term " + this.raft.currentTerm + "; becoming leader");
            }
            this.raft.changeRole(new LeaderRole(this.raft));
        }
    }

    @Override
    void checkReadyTransactionNeedingCommitInfo(RaftKVTransaction tx) {
        super.checkReadyTransactionNeedingCommitInfo(tx);
    }

    @Override
    void caseAppendRequest(AppendRequest msg, NewLogEntry newLogEntry) {
        assert (Thread.holdsLock(this.raft));
        if (this.log.isDebugEnabled()) {
            this.debug("rec'd " + msg + " in " + this + "; reverting to follower");
        }
        this.raft.changeRole(new FollowerRole(this.raft, msg.getSenderId(), this.raft.returnAddress));
        this.raft.receiveMessage(this.raft.returnAddress, msg, -1, newLogEntry);
    }

    @Override
    void caseCommitResponse(CommitResponse msg) {
        assert (Thread.holdsLock(this.raft));
        this.failUnexpectedMessage(msg);
    }

    @Override
    void caseInstallSnapshot(InstallSnapshot msg) {
        assert (Thread.holdsLock(this.raft));
        this.failUnexpectedMessage(msg);
    }

    @Override
    void caseRequestVote(RequestVote msg) {
        assert (Thread.holdsLock(this.raft));
        if (this.log.isDebugEnabled()) {
            this.debug("ignoring " + msg + " rec'd while in " + this);
        }
    }

    @Override
    void caseGrantVote(GrantVote msg) {
        assert (Thread.holdsLock(this.raft));
        this.votes.add(msg.getSenderId());
        if (this.log.isDebugEnabled()) {
            this.debug("rec'd election vote from \"" + msg.getSenderId() + "\" in term " + this.raft.currentTerm);
        }
        this.raft.requestService(this.checkElectionResultService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.toStringPrefix() + ",votes=" + this.votes + "]";
        }
    }

    @Override
    boolean checkState() {
        assert (Thread.holdsLock(this.raft));
        assert (this.electionTimer.isRunning());
        assert (this.raft.isClusterMember());
        return true;
    }
}

