/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.dellroad.stuff.io.ByteBufferOutputStream;
import org.dellroad.stuff.util.LongMap;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.mvcc.Reads;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.raft.CandidateRole;
import org.jsimpledb.kv.raft.CheckWaitingTransactionService;
import org.jsimpledb.kv.raft.Consistency;
import org.jsimpledb.kv.raft.FileWriter;
import org.jsimpledb.kv.raft.LeaderRole;
import org.jsimpledb.kv.raft.LogEntry;
import org.jsimpledb.kv.raft.NewLogEntry;
import org.jsimpledb.kv.raft.NonLeaderRole;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Role;
import org.jsimpledb.kv.raft.SnapshotReceive;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.TxState;
import org.jsimpledb.kv.raft.Util;
import org.jsimpledb.kv.raft.msg.AppendRequest;
import org.jsimpledb.kv.raft.msg.AppendResponse;
import org.jsimpledb.kv.raft.msg.CommitRequest;
import org.jsimpledb.kv.raft.msg.CommitResponse;
import org.jsimpledb.kv.raft.msg.GrantVote;
import org.jsimpledb.kv.raft.msg.InstallSnapshot;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.PingRequest;
import org.jsimpledb.kv.raft.msg.PingResponse;
import org.jsimpledb.kv.raft.msg.RequestVote;

public class FollowerRole
extends NonLeaderRole {
    @GuardedBy(value="raft")
    private String leader;
    @GuardedBy(value="raft")
    private String leaderAddress;
    @GuardedBy(value="raft")
    private String votedFor;
    @GuardedBy(value="raft")
    private SnapshotReceive snapshotReceive;
    @GuardedBy(value="raft")
    private final HashSet<RaftKVTransaction> commitRequests = new HashSet();
    @GuardedBy(value="raft")
    private final LongMap<PendingWrite> pendingWrites = new LongMap();
    @GuardedBy(value="raft")
    private Timestamp lastLeaderMessageTime;
    @GuardedBy(value="raft")
    private Timestamp leaderLeaseTimeout;
    @GuardedBy(value="raft")
    private HashMap<String, Timestamp> probeTimestamps;

    FollowerRole(RaftKVDatabase raft) {
        this(raft, null, null, null);
    }

    FollowerRole(RaftKVDatabase raft, String leader, String leaderAddress) {
        this(raft, leader, leaderAddress, leader);
    }

    FollowerRole(RaftKVDatabase raft, String leader, String leaderAddress, String votedFor) {
        super(raft, raft.isClusterMember());
        this.leader = leader;
        this.leaderAddress = leaderAddress;
        this.votedFor = votedFor;
        assert (this.leaderAddress != null || this.leader == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLeaderIdentity() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.leader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLeaderAddress() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.leaderAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVotedFor() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.votedFor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstallingSnapshot() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.snapshotReceive != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodesProbed() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.probeTimestamps != null ? this.calculateProbedNodes() : -1;
        }
    }

    private int calculateProbedNodes() {
        assert (Thread.holdsLock(this.raft));
        assert (this.probeTimestamps != null);
        int numProbed = this.raft.isClusterMember() ? 1 : 0;
        Timestamp now = new Timestamp();
        Iterator<Timestamp> i = this.probeTimestamps.values().iterator();
        while (i.hasNext()) {
            Timestamp timestamp = i.next();
            if (now.offsetFrom(timestamp) >= this.raft.maxElectionTimeout) {
                i.remove();
                continue;
            }
            ++numProbed;
        }
        return numProbed;
    }

    @Override
    void setup() {
        assert (Thread.holdsLock(this.raft));
        super.setup();
        if (this.log.isDebugEnabled()) {
            this.debug("entering follower role in term " + this.raft.currentTerm + (this.leader != null ? "; with leader \"" + this.leader + "\" at " + this.leaderAddress : "") + (this.votedFor != null ? "; having voted for \"" + this.votedFor + "\"" : ""));
        }
    }

    @Override
    void shutdown() {
        assert (Thread.holdsLock(this.raft));
        if (this.snapshotReceive != null) {
            if (this.log.isDebugEnabled()) {
                this.debug("aborting snapshot install due to leaving follower role");
            }
            this.raft.discardFlipFloppedStateMachine();
            this.snapshotReceive = null;
        }
        for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
            if (!this.commitRequests.contains(tx) || !tx.addsLogEntry()) continue;
            assert (!tx.isRebasable());
            assert (tx.getState().equals((Object)TxState.COMMIT_READY));
            this.raft.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, "leader was deposed before commit response received")));
        }
        this.commitRequests.clear();
        this.pendingWrites.values().forEach(PendingWrite::cleanup);
        this.pendingWrites.clear();
        super.shutdown();
    }

    @Override
    void outputQueueEmpty(String address) {
        assert (Thread.holdsLock(this.raft));
        if (address.equals(this.leaderAddress)) {
            this.raft.requestService(this.checkReadyTransactionsService);
        }
    }

    @Override
    void handleElectionTimeout() {
        assert (Thread.holdsLock(this.raft));
        this.leader = null;
        this.leaderAddress = null;
        if (!this.raft.followerProbingEnabled) {
            if (this.log.isDebugEnabled()) {
                this.debug("follower election timeout: probing is disabled, so converting immediately to candidate");
            }
            this.raft.changeRole(new CandidateRole(this.raft));
            return;
        }
        if (this.probeTimestamps == null) {
            if (this.log.isDebugEnabled()) {
                this.debug("follower election timeout: attempting to probe a majority before becoming candidate");
            }
            this.probeTimestamps = new HashMap(this.raft.currentConfig.size() - 1);
        }
        Timestamp now = new Timestamp();
        for (String peer : this.raft.currentConfig.keySet()) {
            if (peer.equals(this.raft.identity)) continue;
            this.raft.sendMessage(new PingRequest(this.raft.clusterId, this.raft.identity, peer, this.raft.currentTerm, now));
        }
        this.restartElectionTimer();
        this.checkProbeResult();
    }

    private void updateElectionTimer() {
        assert (Thread.holdsLock(this.raft));
        boolean isClusterMember = this.raft.isClusterMember();
        boolean electionTimerRunning = this.electionTimer.isRunning();
        if (isClusterMember && !electionTimerRunning) {
            if (this.log.isTraceEnabled()) {
                this.trace("starting up election timer because I'm now part of the current config");
            }
            this.restartElectionTimer();
        } else if (!isClusterMember && electionTimerRunning) {
            if (this.log.isTraceEnabled()) {
                this.trace("stopping election timer because I'm no longer part of the current config");
            }
            this.electionTimer.cancel();
        }
    }

    @Override
    void handleLinearizableReadOnlyChange(RaftKVTransaction tx) {
        super.handleLinearizableReadOnlyChange(tx);
        assert (!this.commitRequests.contains(tx));
        this.checkSendCommitRequest(tx, false);
    }

    @Override
    void checkReadyTransactionNeedingCommitInfo(RaftKVTransaction tx) {
        super.checkReadyTransactionNeedingCommitInfo(tx);
        this.checkSendCommitRequest(tx, true);
    }

    private void checkSendCommitRequest(RaftKVTransaction tx, boolean allowConfigure) {
        boolean addsLogEntry = tx.addsLogEntry();
        assert (Thread.holdsLock(this.raft));
        assert (tx.getState().equals((Object)TxState.EXECUTING) && !addsLogEntry || tx.getState().equals((Object)TxState.COMMIT_READY));
        if (this.commitRequests.contains(tx)) {
            if (this.log.isTraceEnabled()) {
                this.trace("not sending CommitRequest for tx " + tx + " because request already sent");
            }
            return;
        }
        if (this.snapshotReceive != null) {
            if (this.log.isTraceEnabled()) {
                this.trace("not sending CommitRequest for tx " + tx + " because a snapshot install is in progress");
            }
            return;
        }
        if (allowConfigure && !this.raft.isConfigured()) {
            LogEntry logEntry;
            String[] configChange = tx.getConfigChange();
            if (!addsLogEntry) {
                this.raft.succeed(tx);
                return;
            }
            if (configChange == null || !configChange[0].equals(this.raft.identity) || configChange[1] == null) {
                throw new RetryTransactionException((KVTransaction)tx, "unconfigured system: an initial configuration change adding the local node (\"" + this.raft.identity + "\") as the first member of a new cluster is required");
            }
            if (this.raft.clusterId == 0) {
                int newClusterId;
                while ((newClusterId = this.raft.random.nextInt()) == 0) {
                }
                this.info("creating new cluster with ID " + String.format("0x%08x", newClusterId));
                if (!this.raft.joinCluster(newClusterId)) {
                    throw new KVTransactionException((KVTransaction)tx, "error persisting new cluster ID");
                }
            }
            assert (this.raft.currentTerm == 0L);
            if (!this.raft.advanceTerm(this.raft.currentTerm + 1L)) {
                throw new KVTransactionException((KVTransaction)tx, "error advancing term");
            }
            try {
                logEntry = this.raft.appendLogEntry(this.raft.currentTerm, new NewLogEntry(tx));
            }
            catch (Exception e) {
                throw new KVTransactionException((KVTransaction)tx, "error attempting to persist transaction", (Throwable)e);
            }
            if (this.log.isDebugEnabled()) {
                this.debug("added log entry " + logEntry + " for local transaction " + tx);
            }
            assert (logEntry.getTerm() == 1L);
            assert (logEntry.getIndex() == 1L);
            this.advanceReadyTransactionWithCommitInfo(tx, 1L, 1L, null);
            this.rebaseTransactions();
            this.raft.commitIndex = logEntry.getIndex();
            this.checkCommittables();
            new CheckWaitingTransactionService((Role)this, tx).run();
            this.raft.requestService(this.triggerKeyWatchesService);
            assert (this.raft.isConfigured());
            if (this.log.isDebugEnabled()) {
                this.debug("appointing myself leader in newly created cluster");
            }
            this.raft.changeRole(new LeaderRole(this.raft));
            return;
        }
        if (this.leader == null || this.raft.isTransmitting(this.leaderAddress)) {
            if (this.log.isTraceEnabled()) {
                this.trace("leaving alone tx " + tx + " because leader " + (this.leader == null ? "is not known yet" : "\"" + this.leader + "\" is not writable yet"));
            }
            return;
        }
        ByteBuffer readsData = null;
        ByteBuffer mutationData = null;
        if (addsLogEntry) {
            FileWriter fileWriter;
            assert (tx.getConsistency().isGuaranteesUpToDateReads());
            Reads reads = tx.view.getReads();
            long readsDataSize = reads.serializedLength();
            if (readsDataSize != (long)((int)readsDataSize)) {
                throw new KVTransactionException((KVTransaction)tx, "transaction read information exceeds maximum length");
            }
            readsData = Util.allocateByteBuffer((int)readsDataSize);
            try (ByteBufferOutputStream output = new ByteBufferOutputStream(readsData);){
                reads.serialize((OutputStream)output);
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception", e);
            }
            assert (!readsData.hasRemaining());
            readsData.flip();
            Writes writes = tx.view.getWrites();
            File file = new File(this.raft.logDir, String.format("%s%019d%s", "tx-", tx.txId, ".tmp"));
            try {
                fileWriter = new FileWriter(file, this.raft.disableSync);
            }
            catch (IOException e) {
                throw new KVTransactionException((KVTransaction)tx, "error saving transaction mutations to temporary file", (Throwable)e);
            }
            try {
                LogEntry.writeData(fileWriter, new LogEntry.Data(writes, tx.getConfigChange()));
                fileWriter.flush();
            }
            catch (IOException e) {
                Util.closeIfPossible(fileWriter);
                this.raft.deleteFile(fileWriter.getFile(), "pending write temp file");
                throw new KVTransactionException((KVTransaction)tx, "error saving transaction mutations to temporary file", (Throwable)e);
            }
            long writeLength = fileWriter.getLength();
            try {
                mutationData = Util.readFile(fileWriter.getFile(), writeLength);
            }
            catch (IOException e) {
                Util.closeIfPossible(fileWriter);
                this.raft.deleteFile(fileWriter.getFile(), "pending write temp file");
                throw new KVTransactionException((KVTransaction)tx, "error reading transaction mutations from temporary file", (Throwable)e);
            }
            PendingWrite pendingWrite = new PendingWrite(tx, fileWriter);
            this.pendingWrites.put(tx.txId, (Object)pendingWrite);
        }
        CommitRequest msg = new CommitRequest(this.raft.clusterId, this.raft.identity, this.leader, this.raft.currentTerm, tx.txId, tx.getBaseTerm(), tx.getBaseIndex(), readsData, mutationData);
        if (this.log.isTraceEnabled()) {
            this.trace("sending " + msg + " to \"" + this.leader + "\" for " + tx);
        }
        if (!this.raft.sendMessage(msg)) {
            throw new RetryTransactionException((KVTransaction)tx, "error sending commit request to leader");
        }
        assert (!this.commitRequests.contains(tx));
        this.commitRequests.add(tx);
        if (addsLogEntry) {
            tx.setNoLongerRebasable();
        }
    }

    @Override
    void cleanupForTransaction(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
        this.commitRequests.remove(tx);
        PendingWrite pendingWrite = (PendingWrite)this.pendingWrites.remove(tx.txId);
        if (pendingWrite != null) {
            pendingWrite.cleanup();
        }
        super.cleanupForTransaction(tx);
    }

    @Override
    boolean mayAdvanceCurrentTerm(Message msg) {
        assert (Thread.holdsLock(this.raft));
        return !(msg instanceof RequestVote) || this.lastLeaderMessageTime == null || this.lastLeaderMessageTime.offsetFromNow() <= -this.raft.minElectionTimeout;
    }

    @Override
    void caseAppendRequest(AppendRequest msg, NewLogEntry newLogEntry) {
        long newCommitIndex;
        assert (Thread.holdsLock(this.raft));
        if (this.probeTimestamps != null) {
            if (this.log.isDebugEnabled()) {
                this.debug("heard from leader before we probed a majority, reverting back to normal follower");
            }
            this.probeTimestamps = null;
        }
        if (this.raft.clusterId == 0) {
            this.raft.joinCluster(msg.getClusterId());
        }
        if (!msg.getSenderId().equals(this.leader)) {
            if (this.leader != null && !this.leader.equals(msg.getSenderId())) {
                this.error("detected a conflicting leader in " + msg + " (previous leader was \"" + this.leader + "\") - should never happen; possible inconsistent cluster configuration (mine: " + this.raft.currentConfig + ")");
            }
            this.leader = msg.getSenderId();
            this.leaderAddress = this.raft.returnAddress;
            this.leaderLeaseTimeout = null;
            if (this.log.isDebugEnabled()) {
                this.debug("updated leader to \"" + this.leader + "\" at " + this.leaderAddress);
            }
            this.raft.requestService(this.checkReadyTransactionsService);
        }
        long leaderCommitIndex = msg.getLeaderCommit();
        long leaderPrevTerm = msg.getPrevLogTerm();
        long leaderPrevIndex = msg.getPrevLogIndex();
        long logTerm = msg.getLogEntryTerm();
        long logIndex = leaderPrevIndex + 1L;
        this.lastLeaderMessageTime = new Timestamp();
        if (msg.getLeaderLeaseTimeout() != null && (this.leaderLeaseTimeout == null || msg.getLeaderLeaseTimeout().compareTo(this.leaderLeaseTimeout) > 0)) {
            if (this.log.isTraceEnabled()) {
                this.trace("advancing leader lease timeout " + this.leaderLeaseTimeout + " -> " + msg.getLeaderLeaseTimeout());
            }
            this.leaderLeaseTimeout = msg.getLeaderLeaseTimeout();
            this.raft.requestService(this.checkWaitingTransactionsService);
        }
        if (this.snapshotReceive != null) {
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd " + msg + " during in-progress " + this.snapshotReceive + "; aborting snapshot install");
            }
            this.raft.discardFlipFloppedStateMachine();
            this.snapshotReceive = null;
            this.updateElectionTimer();
        }
        if (this.electionTimer.isRunning()) {
            this.restartElectionTimer();
        }
        long lastLogIndex = this.raft.getLastLogIndex();
        if (leaderPrevIndex >= this.raft.lastAppliedIndex && (leaderPrevIndex > lastLogIndex || leaderPrevTerm != this.raft.getLogTermAtIndex(leaderPrevIndex))) {
            if (this.log.isDebugEnabled()) {
                this.debug("rejecting " + msg + " because previous log entry doesn't match");
            }
            this.raft.sendMessage(new AppendResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getLeaderTimestamp(), false, this.raft.lastAppliedIndex, this.raft.getLastLogIndex()));
            return;
        }
        boolean success = true;
        if (leaderPrevIndex >= this.raft.lastAppliedIndex && !msg.isProbe()) {
            if (logIndex <= lastLogIndex && logTerm != this.raft.getLogTermAtIndex(logIndex)) {
                int startListIndex = (int)(logIndex - this.raft.lastAppliedIndex - 1L);
                List<LogEntry> conflictList = this.raft.raftLog.subList(startListIndex, this.raft.raftLog.size());
                for (LogEntry logEntry : conflictList) {
                    if (this.log.isDebugEnabled()) {
                        this.debug("deleting log entry " + logEntry + " overrwritten by " + msg);
                    }
                    this.raft.deleteFile(logEntry.getFile(), "overwritten log file");
                }
                try {
                    this.raft.logDirChannel.force(true);
                }
                catch (IOException e) {
                    this.warn("errory fsync()'ing log directory " + this.raft.logDir, e);
                }
                conflictList.clear();
                this.raft.currentConfig = this.raft.buildCurrentConfig();
                lastLogIndex = this.raft.getLastLogIndex();
                for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
                    if (tx.getBaseIndex() < logIndex || tx.getConsistency().equals((Object)Consistency.UNCOMMITTED)) continue;
                    this.raft.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, "base log entry " + tx.getBaseIndex() + "t" + tx.getBaseTerm() + " overwritten by new leader")));
                }
            }
            if (logIndex > lastLogIndex) {
                LogEntry logEntry;
                block42: {
                    assert (logIndex == lastLogIndex + 1L);
                    logEntry = null;
                    if (newLogEntry == null) {
                        PendingWrite pendingWrite = this.pendingWrites.values().stream().filter(pw -> {
                            RaftKVTransaction tx = pw.getTx();
                            return tx.getState().equals((Object)TxState.COMMIT_WAITING) && tx.getCommitTerm() == logTerm && tx.getCommitIndex() == logIndex;
                        }).findAny().orElse(null);
                        if (pendingWrite == null) {
                            if (this.log.isDebugEnabled()) {
                                this.debug("rec'd " + msg + " but no read-write transaction matching commit " + logIndex + "t" + logTerm + " found; rejecting");
                            }
                        } else {
                            RaftKVTransaction tx = pendingWrite.getTx();
                            this.pendingWrites.remove(tx.txId);
                            try {
                                pendingWrite.getFileWriter().close();
                            }
                            catch (IOException e) {
                                this.error("error closing temporary transaction file for " + tx, e);
                                pendingWrite.cleanup();
                                break block42;
                            }
                            try {
                                logEntry = this.raft.appendLogEntry(logTerm, new NewLogEntry(tx, pendingWrite.getFileWriter().getFile()));
                            }
                            catch (Exception e) {
                                this.error("error appending new log entry for " + tx, e);
                                pendingWrite.cleanup();
                                break block42;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.debug("now waiting for commit of " + tx.getCommitIndex() + "t" + tx.getCommitTerm() + " to commit " + tx);
                            }
                        }
                    } else {
                        try {
                            logEntry = this.raft.appendLogEntry(logTerm, newLogEntry);
                        }
                        catch (Exception e) {
                            this.error("error appending new log entry", e);
                        }
                    }
                }
                if (logEntry != null && logEntry.getConfigChange() != null) {
                    this.updateElectionTimer();
                }
                boolean bl = success = logEntry != null;
                if (success) {
                    this.rebaseTransactions();
                }
                lastLogIndex = this.raft.getLastLogIndex();
            }
        }
        if ((newCommitIndex = Math.min(Math.max(leaderCommitIndex, this.raft.commitIndex), lastLogIndex)) > this.raft.commitIndex) {
            if (this.log.isDebugEnabled()) {
                this.debug("updating leader commit index from " + this.raft.commitIndex + " -> " + newCommitIndex);
            }
            this.raft.commitIndex = newCommitIndex;
            this.checkCommittables();
            this.raft.requestService(this.checkWaitingTransactionsService);
            this.raft.requestService(this.triggerKeyWatchesService);
            this.raft.requestService(this.applyCommittedLogEntriesService);
        }
        if (this.log.isTraceEnabled()) {
            this.trace("my updated follower state: term=" + this.raft.currentTerm + " commitIndex=" + this.raft.commitIndex + " leaderLeaseTimeout=" + this.leaderLeaseTimeout + " lastApplied=" + this.raft.lastAppliedIndex + "t" + this.raft.lastAppliedTerm + " log=" + this.raft.raftLog);
        }
        if (success) {
            this.raft.sendMessage(new AppendResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getLeaderTimestamp(), true, msg.isProbe() ? logIndex - 1L : logIndex, this.raft.getLastLogIndex()));
        } else {
            this.raft.sendMessage(new AppendResponse(this.raft.clusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getLeaderTimestamp(), false, this.raft.lastAppliedIndex, this.raft.getLastLogIndex()));
        }
    }

    @Override
    void caseCommitResponse(CommitResponse msg) {
        assert (Thread.holdsLock(this.raft));
        RaftKVTransaction tx = (RaftKVTransaction)this.raft.openTransactions.get(msg.getTxId());
        if (tx == null) {
            return;
        }
        assert (tx.getConsistency().equals((Object)Consistency.LINEARIZABLE));
        assert (msg.getCommitLeaderLeaseTimeout() == null || !tx.addsLogEntry());
        if (!this.commitRequests.remove(tx)) {
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd " + msg + " for " + tx + " not expecting a response; ignoring");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.trace("rec'd " + msg + " for " + tx);
        }
        if (tx.hasCommitInfo()) {
            if (this.log.isTraceEnabled()) {
                this.trace("ignoring " + msg + " for " + tx + "; already have commit " + tx.getCommitIndex() + "t" + tx.getCommitTerm());
            }
            return;
        }
        if (!msg.isSuccess()) {
            this.raft.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, msg.getErrorMessage())));
            return;
        }
        long commitIndex = msg.getCommitIndex();
        long commitTerm = msg.getCommitTerm();
        if (tx.getBaseIndex() > commitIndex) {
            if (this.log.isTraceEnabled()) {
                long actualCommitTerm = this.raft.getLogTermAtIndexIfKnown(commitIndex);
                this.trace(tx + " was rebased past its commit index " + commitIndex + "t" + commitTerm + " to " + tx.getBaseIndex() + "t" + tx.getBaseTerm() + "; actual term for index " + commitIndex + " is " + (actualCommitTerm != 0L ? "" + actualCommitTerm : "unknown"));
            }
            this.raft.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, "transaction was rebased past its commit index")));
            return;
        }
        switch (tx.getState()) {
            case EXECUTING: {
                assert (tx.isReadOnly());
                assert (!tx.hasCommitInfo());
                tx.setCommitInfo(commitTerm, commitIndex, msg.getCommitLeaderLeaseTimeout());
                this.checkCommittable(tx);
                break;
            }
            case COMMIT_READY: {
                assert (!tx.hasCommitInfo());
                this.advanceReadyTransactionWithCommitInfo(tx, commitTerm, commitIndex, msg.getCommitLeaderLeaseTimeout());
                break;
            }
            default: {
                if (this.log.isDebugEnabled()) {
                    this.debug("rec'd " + msg + " for " + tx + " in state " + (Object)((Object)tx.getState()) + "; ignoring");
                }
                return;
            }
        }
    }

    @Override
    void caseInstallSnapshot(InstallSnapshot msg) {
        assert (Thread.holdsLock(this.raft));
        if (this.electionTimer.isRunning()) {
            this.restartElectionTimer();
        }
        if (msg.getSnapshotIndex() < this.raft.commitIndex) {
            this.warn("rec'd " + msg + " with retrograde index " + msg.getSnapshotIndex() + " < my commit index " + this.raft.commitIndex + ", ignoring");
            return;
        }
        boolean startNewInstall = false;
        if (this.snapshotReceive != null) {
            if (!this.snapshotReceive.matches(msg)) {
                if (msg.getPairIndex() != 0L) {
                    if (this.log.isDebugEnabled()) {
                        this.debug("rec'd " + msg + " which doesn't match in-progress " + this.snapshotReceive + "; ignoring");
                    }
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.debug("rec'd initial " + msg + " with in-progress " + this.snapshotReceive + "; aborting previous install");
                }
                startNewInstall = true;
            }
        } else if (msg.getPairIndex() != 0L) {
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd non-initial " + msg + " with no in-progress snapshot install; ignoring");
            }
            return;
        }
        long term = msg.getSnapshotTerm();
        long index = msg.getSnapshotIndex();
        if (this.snapshotReceive == null || startNewInstall) {
            assert (msg.getPairIndex() == 0L);
            if (this.raft.discardFlipFloppedStateMachine()) {
                this.warn("detected left-over content in flip-flopped state machine; discarding");
            }
            this.updateElectionTimer();
            this.snapshotReceive = new SnapshotReceive(this.raft.kv, this.raft.getFlipFloppedStateMachinePrefix(), term, index, msg.getSnapshotConfig());
            if (this.log.isDebugEnabled()) {
                this.debug("starting new snapshot install from \"" + msg.getSenderId() + "\" of " + index + "t" + term + " with config " + msg.getSnapshotConfig());
            }
        }
        assert (this.snapshotReceive.matches(msg));
        if (this.log.isDebugEnabled()) {
            this.debug("applying " + msg + " to " + this.snapshotReceive);
        }
        try {
            this.snapshotReceive.applyNextChunk(msg.getData());
        }
        catch (Exception e) {
            this.error("error applying snapshot to key/value store; aborting snapshot install", e);
            this.snapshotReceive = null;
            this.raft.discardFlipFloppedStateMachine();
            this.updateElectionTimer();
            return;
        }
        if (msg.isLastChunk()) {
            Map<String, String> snapshotConfig = this.snapshotReceive.getSnapshotConfig();
            if (this.log.isDebugEnabled()) {
                this.debug("snapshot install from \"" + msg.getSenderId() + "\" of " + index + "t" + term + " with config " + snapshotConfig + " complete");
            }
            this.snapshotReceive = null;
            this.raft.flipFlopStateMachine(term, index, snapshotConfig);
            this.updateElectionTimer();
            for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
                if (tx.getBaseIndex() > index) {
                    this.raft.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, "rec'd snapshot install from leader and base index " + tx.getBaseIndex() + " > " + index)));
                }
                if (!tx.isRebasable() || tx.getBaseTerm() == term && tx.getBaseIndex() == index) continue;
                this.raft.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, "snapshot install of " + index + "t" + term + " invalidated base " + tx.getBaseIndex() + "t" + tx.getBaseTerm())));
            }
            this.checkCommittables();
        }
    }

    @Override
    void caseRequestVote(RequestVote msg) {
        assert (Thread.holdsLock(this.raft));
        if (this.raft.clusterId == 0) {
            this.raft.joinCluster(msg.getClusterId());
        }
        String peer = msg.getSenderId();
        if (this.votedFor != null && !this.votedFor.equals(peer)) {
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd " + msg + "; rejected because we already voted for \"" + this.votedFor + "\"");
            }
            return;
        }
        if (msg.getLastLogTerm() < this.raft.getLastLogTerm() || msg.getLastLogTerm() == this.raft.getLastLogTerm() && msg.getLastLogIndex() < this.raft.getLastLogIndex()) {
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd " + msg + "; rejected because their log " + msg.getLastLogIndex() + "t" + msg.getLastLogTerm() + " loses to ours " + this.raft.getLastLogIndex() + "t" + this.raft.getLastLogTerm());
            }
            return;
        }
        if (this.votedFor == null) {
            if (this.log.isDebugEnabled()) {
                this.debug("granting vote to \"" + peer + "\" in term " + this.raft.currentTerm);
            }
            if (!this.updateVotedFor(peer)) {
                return;
            }
        } else if (this.log.isDebugEnabled()) {
            this.debug("confirming existing vote for \"" + peer + "\" in term " + this.raft.currentTerm);
        }
        this.raft.sendMessage(new GrantVote(this.raft.clusterId, this.raft.identity, peer, this.raft.currentTerm));
    }

    @Override
    void caseGrantVote(GrantVote msg) {
        assert (Thread.holdsLock(this.raft));
        if (this.log.isDebugEnabled()) {
            this.debug("ignoring " + msg + " rec'd while in " + this);
        }
    }

    @Override
    void casePingResponse(PingResponse msg) {
        assert (Thread.holdsLock(this.raft));
        if (this.probeTimestamps == null) {
            if (this.log.isTraceEnabled()) {
                this.trace("ignoring " + msg + " rec'd while not probing in " + this);
            }
            return;
        }
        this.probeTimestamps.put(msg.getSenderId(), msg.getTimestamp());
        this.checkProbeResult();
    }

    private void checkProbeResult() {
        assert (Thread.holdsLock(this.raft));
        assert (this.probeTimestamps != null);
        int numProbed = this.calculateProbedNodes();
        int numRequired = this.raft.currentConfig.size() / 2 + 1;
        if (this.log.isTraceEnabled()) {
            this.trace("now we have probed " + numProbed + "/" + numRequired + " required nodes");
        }
        if (numProbed >= numRequired) {
            if (this.log.isDebugEnabled()) {
                this.debug("successfully probed " + numProbed + " nodes, now converting to candidate");
            }
            this.raft.changeRole(new CandidateRole(this.raft));
        }
    }

    private boolean updateVotedFor(String recipient) {
        assert (Thread.holdsLock(this.raft));
        assert (recipient != null);
        Writes writes = new Writes();
        writes.getPuts().put(RaftKVDatabase.VOTED_FOR_KEY, this.raft.encodeString(recipient));
        try {
            this.raft.kv.mutate((Mutations)writes, true);
        }
        catch (Exception e) {
            this.error("error persisting vote for \"" + recipient + "\"", e);
            return false;
        }
        this.votedFor = recipient;
        return true;
    }

    @Override
    Timestamp getLeaderLeaseTimeout() {
        return this.leaderLeaseTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            List pendingRequestIds = this.commitRequests.stream().map(tx -> tx.txId).collect(Collectors.toList());
            return this.toStringPrefix() + (this.leader != null ? ",leader=\"" + this.leader + "\"" : "") + (this.votedFor != null ? ",votedFor=\"" + this.votedFor + "\"" : "") + (!pendingRequestIds.isEmpty() ? ",commitRequests=" + pendingRequestIds : "") + (!this.pendingWrites.isEmpty() ? ",pendingWrites=" + this.pendingWrites.keySet() : "") + "]";
        }
    }

    @Override
    boolean checkState() {
        assert (Thread.holdsLock(this.raft));
        assert (this.leaderAddress != null || this.leader == null);
        assert (this.electionTimer.isRunning() == this.raft.isClusterMember());
        for (RaftKVTransaction tx : this.commitRequests) {
            switch (tx.getState()) {
                case EXECUTING: {
                    assert (tx.isReadOnly());
                    break;
                }
                case COMMIT_READY: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (!tx.hasCommitInfo());
        }
        for (Map.Entry entry : this.pendingWrites.entrySet()) {
            long txId = (Long)entry.getKey();
            PendingWrite pendingWrite = (PendingWrite)entry.getValue();
            RaftKVTransaction tx = pendingWrite.getTx();
            assert (txId == tx.txId);
            assert (tx.getState().equals((Object)TxState.COMMIT_READY) || tx.getState().equals((Object)TxState.COMMIT_WAITING));
            assert (pendingWrite.getFileWriter().getFile().exists());
        }
        return true;
    }

    @Override
    void checkTransaction(RaftKVTransaction tx) {
        super.checkTransaction(tx);
        switch (tx.getState()) {
            case EXECUTING: {
                assert (!this.pendingWrites.containsKey(tx.txId));
                break;
            }
            case COMMIT_READY: {
                break;
            }
            case COMMIT_WAITING: {
                assert (!this.commitRequests.contains(tx));
                break;
            }
            default: {
                assert (!this.pendingWrites.containsKey(tx.txId));
                assert (!this.commitRequests.contains(tx));
                break;
            }
        }
    }

    private static class PendingWrite {
        private final RaftKVTransaction tx;
        private final FileWriter fileWriter;

        PendingWrite(RaftKVTransaction tx, FileWriter fileWriter) {
            this.tx = tx;
            this.fileWriter = fileWriter;
        }

        public RaftKVTransaction getTx() {
            return this.tx;
        }

        public FileWriter getFileWriter() {
            return this.fileWriter;
        }

        public void cleanup() {
            Util.closeIfPossible(this.fileWriter);
            this.tx.raft.deleteFile(this.fileWriter.getFile(), "pending write temp file");
        }
    }
}

