/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import org.jsimpledb.kv.raft.NewLogEntry;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.Role;
import org.jsimpledb.kv.raft.Service;
import org.jsimpledb.kv.raft.Timer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.msg.AppendResponse;
import org.jsimpledb.kv.raft.msg.CommitRequest;

public abstract class NonLeaderRole
extends Role {
    final Timer electionTimer;
    private final boolean startElectionTimer;

    NonLeaderRole(RaftKVDatabase raft, boolean startElectionTimer) {
        super(raft);
        this.electionTimer = new Timer(this.raft, "election timer", new Service(this, "election timeout"){

            @Override
            public void run() {
                NonLeaderRole.this.checkElectionTimeout();
            }
        });
        this.startElectionTimer = startElectionTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getElectionTimeout() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.electionTimer.getDeadline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElection() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            Preconditions.checkState((this.raft.role == this ? 1 : 0) != 0, (Object)"role is no longer active");
            Preconditions.checkState((boolean)this.electionTimer.isRunning(), (Object)"election timer is not running");
            this.debug("triggering immediate election timeout due to invocation of startElection()");
            this.electionTimer.timeoutNow();
        }
    }

    @Override
    void setup() {
        assert (Thread.holdsLock(this.raft));
        super.setup();
        if (this.startElectionTimer) {
            this.restartElectionTimer();
        }
    }

    @Override
    void shutdown() {
        assert (Thread.holdsLock(this.raft));
        this.electionTimer.cancel();
        super.shutdown();
    }

    private void checkElectionTimeout() {
        assert (Thread.holdsLock(this.raft));
        if (this.electionTimer.pollForTimeout()) {
            if (this.log.isDebugEnabled()) {
                this.debug("election timeout while in " + this);
            }
            this.handleElectionTimeout();
        }
    }

    void restartElectionTimer() {
        assert (Thread.holdsLock(this.raft));
        int range = this.raft.maxElectionTimeout - this.raft.minElectionTimeout;
        int randomizedPart = Math.round(this.raft.random.nextFloat() * (float)range);
        this.electionTimer.timeoutAfter(this.raft.minElectionTimeout + randomizedPart);
    }

    abstract void handleElectionTimeout();

    @Override
    void caseAppendResponse(AppendResponse msg) {
        assert (Thread.holdsLock(this.raft));
        this.failUnexpectedMessage(msg);
    }

    @Override
    void caseCommitRequest(CommitRequest msg, NewLogEntry newLogEntry) {
        assert (Thread.holdsLock(this.raft));
        this.failUnexpectedMessage(msg);
    }
}

