/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.dellroad.stuff.io.ByteBufferInputStream;
import org.dellroad.stuff.java.TimedWait;
import org.dellroad.stuff.net.Network;
import org.dellroad.stuff.net.TCPNetwork;
import org.dellroad.stuff.util.LongMap;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.raft.CheckReadyTransactionService;
import org.jsimpledb.kv.raft.Consistency;
import org.jsimpledb.kv.raft.FileWriter;
import org.jsimpledb.kv.raft.FollowerRole;
import org.jsimpledb.kv.raft.LogEntry;
import org.jsimpledb.kv.raft.MostRecentView;
import org.jsimpledb.kv.raft.NewLogEntry;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Role;
import org.jsimpledb.kv.raft.Service;
import org.jsimpledb.kv.raft.Timer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.TxState;
import org.jsimpledb.kv.raft.Util;
import org.jsimpledb.kv.raft.msg.AppendRequest;
import org.jsimpledb.kv.raft.msg.AppendResponse;
import org.jsimpledb.kv.raft.msg.CommitRequest;
import org.jsimpledb.kv.raft.msg.CommitResponse;
import org.jsimpledb.kv.raft.msg.GrantVote;
import org.jsimpledb.kv.raft.msg.InstallSnapshot;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.kv.raft.msg.PingRequest;
import org.jsimpledb.kv.raft.msg.PingResponse;
import org.jsimpledb.kv.raft.msg.RequestVote;
import org.jsimpledb.kv.util.KeyWatchTracker;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.CloseableIterator;
import org.jsimpledb.util.LongEncoder;
import org.jsimpledb.util.ThrowableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftKVDatabase
implements KVDatabase {
    public static final int DEFAULT_MIN_ELECTION_TIMEOUT = 750;
    public static final int DEFAULT_MAX_ELECTION_TIMEOUT = 1000;
    public static final int DEFAULT_HEARTBEAT_TIMEOUT = 200;
    public static final int DEFAULT_MAX_TRANSACTION_DURATION = 5000;
    public static final long DEFAULT_MAX_UNAPPLIED_LOG_MEMORY = 0x6400000L;
    public static final int DEFAULT_MAX_UNAPPLIED_LOG_ENTRIES = 64;
    public static final int DEFAULT_MAX_FOLLOWER_ACK_HEARTBEATS = 5;
    public static final int DEFAULT_COMMIT_TIMEOUT = 5000;
    public static final int DEFAULT_TCP_PORT = 9660;
    public static final String OPTION_CONSISTENCY = "consistency";
    static final int MAX_SNAPSHOT_TRANSMIT_AGE = (int)TimeUnit.SECONDS.toMillis(90L);
    static final int FOLLOWER_LINGER_HEARTBEATS = 3;
    static final float MAX_CLOCK_DRIFT = 0.01f;
    static final int MAX_APPLIED_TERMS = 128;
    static final String TX_FILE_PREFIX = "tx-";
    static final String TEMP_FILE_PREFIX = "temp-";
    static final String TEMP_FILE_SUFFIX = ".tmp";
    static final Pattern TEMP_FILE_PATTERN = Pattern.compile(".*" + Pattern.quote(".tmp"));
    static final byte[] CLUSTER_ID_KEY = ByteUtil.parse((String)"0001");
    static final byte[] CURRENT_TERM_KEY = ByteUtil.parse((String)"0002");
    static final byte[] LAST_APPLIED_TERM_KEY = ByteUtil.parse((String)"0003");
    static final byte[] LAST_APPLIED_INDEX_KEY = ByteUtil.parse((String)"0004");
    static final byte[] LAST_APPLIED_CONFIG_KEY = ByteUtil.parse((String)"0005");
    static final byte[] VOTED_FOR_KEY = ByteUtil.parse((String)"0006");
    static final byte[] FLIP_FLOP_KEY = ByteUtil.parse((String)"0007");
    private static final byte[] STATE_MACHINE_PREFIXES = new byte[]{-128, -127};
    final Logger log = LoggerFactory.getLogger(this.getClass());
    Network network = new TCPNetwork(9660);
    String identity;
    int minElectionTimeout = 750;
    int maxElectionTimeout = 1000;
    int heartbeatTimeout = 200;
    int maxTransactionDuration = 5000;
    int commitTimeout = 5000;
    long maxUnappliedLogMemory = 0x6400000L;
    int maxUnappliedLogEntries = 64;
    int maxFollowerAckHeartbeats = 5;
    boolean followerProbingEnabled;
    boolean disableSync;
    boolean dumpConflicts;
    File logDir;
    Role role;
    SecureRandom random;
    boolean flipflop;
    int clusterId;
    long currentTerm;
    long currentTermStartTime;
    long commitIndex;
    long keyWatchIndex;
    long lastAppliedTerm;
    long lastAppliedIndex;
    final long[] appliedTerms = new long[128];
    final ArrayList<LogEntry> raftLog = new ArrayList();
    Map<String, String> lastAppliedConfig;
    Map<String, String> currentConfig;
    Map<String, Integer> protocolVersionMap = new HashMap<String, Integer>();
    AtomicKVStore kv;
    FileChannel logDirChannel;
    String returnAddress;
    IOThread ioThread;
    ScheduledExecutorService serviceExecutor;
    final HashSet<String> transmitting = new HashSet();
    final LongMap<RaftKVTransaction> openTransactions = new LongMap();
    final LinkedHashSet<Service> pendingService = new LinkedHashSet();
    KeyWatchTracker keyWatchTracker;
    boolean performingService;
    boolean shuttingDown;
    Throwable lastInternalError;

    public synchronized void setKVStore(AtomicKVStore kvstore) {
        Preconditions.checkState((this.role == null ? 1 : 0) != 0, (Object)"already started");
        this.kv = kvstore;
    }

    public synchronized void setLogDirectory(File directory) {
        Preconditions.checkState((this.role == null ? 1 : 0) != 0, (Object)"already started");
        this.logDir = directory;
    }

    public synchronized File getLogDirectory() {
        return this.logDir;
    }

    public synchronized void setNetwork(Network network) {
        Preconditions.checkState((this.role == null ? 1 : 0) != 0, (Object)"already started");
        this.network = network;
    }

    public synchronized void setIdentity(String identity) {
        Preconditions.checkState((this.role == null ? 1 : 0) != 0, (Object)"already started");
        this.identity = identity;
    }

    public synchronized String getIdentity() {
        return this.identity;
    }

    public synchronized void setMinElectionTimeout(int timeout) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"timeout <= 0");
        Preconditions.checkState((this.role == null ? 1 : 0) != 0, (Object)"already started");
        this.minElectionTimeout = timeout;
    }

    public synchronized int getMinElectionTimeout() {
        return this.minElectionTimeout;
    }

    public synchronized void setMaxElectionTimeout(int timeout) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"timeout <= 0");
        Preconditions.checkState((this.role == null ? 1 : 0) != 0, (Object)"already started");
        this.maxElectionTimeout = timeout;
    }

    public synchronized int getMaxElectionTimeout() {
        return this.maxElectionTimeout;
    }

    public synchronized void setHeartbeatTimeout(int timeout) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"timeout <= 0");
        Preconditions.checkState((this.role == null ? 1 : 0) != 0, (Object)"already started");
        this.heartbeatTimeout = timeout;
    }

    public synchronized int getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public synchronized void setMaxTransactionDuration(int duration) {
        Preconditions.checkArgument((duration > 0 ? 1 : 0) != 0, (Object)"duration <= 0");
        this.maxTransactionDuration = duration;
    }

    public synchronized int getMaxTransactionDuration() {
        return this.maxTransactionDuration;
    }

    public synchronized void setMaxUnappliedLogMemory(long maxUnappliedLogMemory) {
        Preconditions.checkArgument((maxUnappliedLogMemory > 0L ? 1 : 0) != 0, (Object)"maxUnappliedLogMemory <= 0");
        this.maxUnappliedLogMemory = maxUnappliedLogMemory;
    }

    public synchronized long getMaxUnappliedLogMemory() {
        return this.maxUnappliedLogMemory;
    }

    public synchronized void setMaxUnappliedLogEntries(int maxUnappliedLogEntries) {
        Preconditions.checkArgument((maxUnappliedLogEntries > 0 ? 1 : 0) != 0, (Object)"maxUnappliedLogEntries <= 0");
        this.maxUnappliedLogEntries = maxUnappliedLogEntries;
    }

    public synchronized long getMaxUnappliedLogEntries() {
        return this.maxUnappliedLogEntries;
    }

    public synchronized void setMaxFollowerAckHeartbeats(int maxFollowerAckHeartbeats) {
        Preconditions.checkArgument((maxFollowerAckHeartbeats > 0 ? 1 : 0) != 0, (Object)"maxFollowerAckHeartbeats <= 0");
        this.maxFollowerAckHeartbeats = maxFollowerAckHeartbeats;
    }

    public synchronized long getMaxFollowerAckHeartbeats() {
        return this.maxFollowerAckHeartbeats;
    }

    public synchronized void setCommitTimeout(int timeout) {
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout < 0");
        this.commitTimeout = timeout;
    }

    public synchronized int getCommitTimeout() {
        return this.commitTimeout;
    }

    public synchronized void setFollowerProbingEnabled(boolean followerProbingEnabled) {
        this.followerProbingEnabled = followerProbingEnabled;
    }

    public synchronized boolean isFollowerProbingEnabled() {
        return this.followerProbingEnabled;
    }

    public synchronized void setDisableSync(boolean disableSync) {
        this.disableSync = disableSync;
    }

    public synchronized boolean isDisableSync() {
        return this.disableSync;
    }

    public synchronized void setDumpConflicts(boolean dumpConflicts) {
        this.dumpConflicts = dumpConflicts;
    }

    public synchronized boolean isDumpConflicts() {
        return this.dumpConflicts;
    }

    public synchronized int getClusterId() {
        return this.clusterId;
    }

    public synchronized Map<String, String> getCurrentConfig() {
        return this.currentConfig != null ? new TreeMap<String, String>(this.currentConfig) : new TreeMap();
    }

    public synchronized boolean isConfigured() {
        return this.lastAppliedIndex > 0L || !this.raftLog.isEmpty();
    }

    public synchronized boolean isClusterMember() {
        return this.isClusterMember(this.identity);
    }

    public synchronized boolean isClusterMember(String node) {
        return this.currentConfig != null ? this.currentConfig.containsKey(node) : false;
    }

    public synchronized Role getCurrentRole() {
        return this.role;
    }

    public synchronized long getCurrentTerm() {
        return this.currentTerm;
    }

    public synchronized long getCurrentTermStartTime() {
        return this.currentTermStartTime;
    }

    public synchronized long getCommitIndex() {
        return this.commitIndex;
    }

    public synchronized long getLastAppliedTerm() {
        return this.lastAppliedTerm;
    }

    public synchronized long getLastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    public synchronized List<LogEntry> getUnappliedLog() {
        return this.raftLog != null ? new ArrayList<LogEntry>(this.raftLog) : null;
    }

    public synchronized long getUnappliedLogMemoryUsage() {
        long total = 0L;
        for (LogEntry logEntry : this.raftLog) {
            total += logEntry.getFileSize();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<RaftKVTransaction> getOpenTransactions() {
        ArrayList<RaftKVTransaction> list;
        RaftKVDatabase raftKVDatabase = this;
        synchronized (raftKVDatabase) {
            list = new ArrayList<RaftKVTransaction>(this.openTransactions.values());
        }
        Collections.sort(list, RaftKVTransaction.SORT_BY_ID);
        return list;
    }

    @PostConstruct
    public synchronized void start() {
        assert (this.checkState());
        if (this.role != null) {
            return;
        }
        Preconditions.checkState((!this.shuttingDown ? 1 : 0) != 0, (Object)"shutdown in progress");
        Preconditions.checkState((this.logDir != null ? 1 : 0) != 0, (Object)"no Raft log directory configured");
        Preconditions.checkState((this.kv != null ? 1 : 0) != 0, (Object)"no Raft local persistence key/value store configured");
        Preconditions.checkState((this.network != null ? 1 : 0) != 0, (Object)"no Raft network configured");
        Preconditions.checkState((this.minElectionTimeout <= this.maxElectionTimeout ? 1 : 0) != 0, (Object)"minElectionTimeout > maxElectionTimeout");
        Preconditions.checkState((this.heartbeatTimeout < this.minElectionTimeout ? 1 : 0) != 0, (Object)"heartbeatTimeout >= minElectionTimeout");
        Preconditions.checkState((this.identity != null ? 1 : 0) != 0, (Object)"no Raft identity configured");
        if (this.log.isDebugEnabled()) {
            this.debug("starting " + this.getClass().getName() + " in directory " + this.logDir);
        }
        boolean success = false;
        try {
            block22: {
                if (!this.logDir.exists()) {
                    Files.createDirectories(this.logDir.toPath(), new FileAttribute[0]);
                }
                if (!this.logDir.isDirectory()) {
                    throw new IOException("file `" + this.logDir + "' is not a directory");
                }
                this.kv.start();
                assert (this.logDirChannel == null);
                try {
                    this.logDirChannel = FileChannel.open(this.logDir.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    if (this.isWindows()) break block22;
                    throw e;
                }
            }
            assert (this.random == null);
            this.random = new SecureRandom();
            assert (this.ioThread == null);
            String ioThreadName = "Raft I/O [" + this.identity + "]";
            this.ioThread = new IOThread(this.logDir, ioThreadName);
            this.ioThread.start();
            assert (this.serviceExecutor == null);
            String serviceThreadName = "Raft Service [" + this.identity + "]";
            this.serviceExecutor = Executors.newSingleThreadScheduledExecutor(action -> {
                Thread thread = new Thread(action);
                thread.setName(serviceThreadName);
                return thread;
            });
            this.network.start(new Network.Handler(){

                public void handle(String sender, ByteBuffer buf) {
                    RaftKVDatabase.this.handle(sender, buf);
                }

                public void outputQueueEmpty(String address) {
                    RaftKVDatabase.this.outputQueueEmpty(address);
                }
            });
            this.clusterId = (int)this.decodeLong(CLUSTER_ID_KEY, 0L);
            this.currentTerm = this.decodeLong(CURRENT_TERM_KEY, 0L);
            this.currentTermStartTime = System.currentTimeMillis();
            String votedFor = this.decodeString(VOTED_FOR_KEY, null);
            this.lastAppliedTerm = this.decodeLong(LAST_APPLIED_TERM_KEY, 0L);
            this.lastAppliedIndex = this.decodeLong(LAST_APPLIED_INDEX_KEY, 0L);
            Arrays.fill(this.appliedTerms, 0L);
            this.lastAppliedConfig = this.decodeConfig(LAST_APPLIED_CONFIG_KEY);
            this.flipflop = this.decodeBoolean(FLIP_FLOP_KEY);
            this.currentConfig = this.buildCurrentConfig();
            this.protocolVersionMap.clear();
            if (this.discardFlipFloppedStateMachine() && this.log.isDebugEnabled()) {
                this.debug("detected partially applied snapshot install, discarding");
            }
            this.keyWatchIndex = this.commitIndex = this.lastAppliedIndex;
            this.loadLog();
            if (this.log.isDebugEnabled()) {
                this.debug("recovered Raft state:\n  clusterId=" + (this.clusterId != 0 ? String.format("0x%08x", this.clusterId) : "none") + "\n  currentTerm=" + this.currentTerm + "\n  lastApplied=" + this.lastAppliedIndex + "t" + this.lastAppliedTerm + "\n  lastAppliedConfig=" + this.lastAppliedConfig + "\n  currentConfig=" + this.currentConfig + "\n  votedFor=" + (votedFor != null ? "\"" + votedFor + "\"" : "nobody") + "\n  log=" + this.raftLog);
            }
            if (this.isConfigured()) {
                Preconditions.checkArgument((this.clusterId != 0 ? 1 : 0) != 0);
                Preconditions.checkArgument((this.currentTerm > 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((this.getLastLogTerm() > 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((this.getLastLogIndex() > 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((!this.currentConfig.isEmpty() ? 1 : 0) != 0);
            } else {
                Preconditions.checkArgument((this.lastAppliedTerm == 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((this.lastAppliedIndex == 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((this.getLastLogTerm() == 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((this.getLastLogIndex() == 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)this.currentConfig.isEmpty());
                Preconditions.checkArgument((boolean)this.raftLog.isEmpty());
            }
            this.changeRole(new FollowerRole(this, null, null, votedFor));
            this.info("successfully started " + this + " in directory " + this.logDir);
            success = true;
        }
        catch (IOException e) {
            throw new RuntimeException("error starting up database", e);
        }
        finally {
            if (!success) {
                this.cleanup();
            }
        }
        assert (this.checkState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        RaftKVDatabase raftKVDatabase = this;
        synchronized (raftKVDatabase) {
            assert (this.checkState());
            if (this.role == null || this.shuttingDown) {
                return;
            }
            this.info("starting shutdown of " + this);
            this.shuttingDown = true;
            block16: for (RaftKVTransaction tx : new ArrayList(this.openTransactions.values())) {
                switch (tx.getState()) {
                    case EXECUTING: 
                    case COMMIT_READY: 
                    case COMMIT_WAITING: {
                        this.fail(tx, new KVTransactionException((KVTransaction)tx, "database shutdown"));
                        continue block16;
                    }
                    case COMPLETED: {
                        continue block16;
                    }
                }
                assert (false);
            }
            try {
                if (!TimedWait.wait((Object)this, (long)5000L, () -> this.openTransactions.isEmpty())) {
                    this.warn("open transactions not cleaned up during shutdown");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.serviceExecutor.shutdownNow();
        try {
            this.serviceExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.ioThread.shutdown();
        try {
            this.ioThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        raftKVDatabase = this;
        synchronized (raftKVDatabase) {
            this.serviceExecutor = null;
            this.ioThread = null;
            this.cleanup();
        }
        this.info("completed shutdown of " + this);
    }

    public synchronized Throwable getLastInternalError() {
        return this.lastInternalError;
    }

    private void cleanup() {
        assert (Thread.holdsLock(this));
        assert (this.openTransactions.isEmpty());
        if (this.role != null) {
            this.role.shutdown();
            this.role = null;
        }
        if (this.serviceExecutor != null) {
            this.serviceExecutor.shutdownNow();
            try {
                this.serviceExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.serviceExecutor = null;
        }
        if (this.ioThread != null) {
            this.ioThread.shutdown();
            try {
                this.ioThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.ioThread = null;
        }
        this.kv.stop();
        Util.closeIfPossible(this.logDirChannel);
        this.logDirChannel = null;
        this.raftLog.clear();
        this.random = null;
        this.network.stop();
        this.currentTerm = 0L;
        this.currentTermStartTime = 0L;
        this.commitIndex = 0L;
        this.keyWatchIndex = 0L;
        this.clusterId = 0;
        this.lastAppliedTerm = 0L;
        this.lastAppliedIndex = 0L;
        Arrays.fill(this.appliedTerms, 0L);
        this.lastAppliedConfig = null;
        this.currentConfig = null;
        this.protocolVersionMap.clear();
        if (this.keyWatchTracker != null) {
            this.keyWatchTracker.close();
            this.keyWatchTracker = null;
        }
        this.transmitting.clear();
        this.pendingService.clear();
        this.shuttingDown = false;
    }

    private void loadLog() throws IOException {
        LogEntry logEntry;
        assert (Thread.holdsLock(this));
        assert (this.raftLog.isEmpty());
        this.raftLog.clear();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.logDir.toPath());){
            for (Path path : files) {
                File file = path.toFile();
                if (file.isDirectory()) continue;
                if (LogEntry.LOG_FILE_PATTERN.matcher(file.getName()).matches()) {
                    if (this.log.isDebugEnabled()) {
                        this.debug("recovering log file " + file.getName());
                    }
                    logEntry = LogEntry.fromFile(file);
                    this.raftLog.add(logEntry);
                    continue;
                }
                if (TEMP_FILE_PATTERN.matcher(file.getName()).matches()) {
                    if (this.log.isDebugEnabled()) {
                        this.debug("deleting leftover temporary file " + file.getName());
                    }
                    this.deleteFile(file, "leftover temporary file");
                    continue;
                }
                this.warn("ignoring unrecognized file " + file.getName() + " in my log directory");
            }
        }
        Collections.sort(this.raftLog, LogEntry.SORT_BY_INDEX);
        long lastTermSeen = this.lastAppliedTerm;
        long expectedIndex = this.lastAppliedIndex + 1L;
        Iterator<LogEntry> i = this.raftLog.iterator();
        while (i.hasNext()) {
            logEntry = i.next();
            String error = null;
            if (logEntry.getTerm() < lastTermSeen) {
                error = "term " + logEntry.getTerm() + " < last applied term " + lastTermSeen;
            } else if (logEntry.getIndex() < this.lastAppliedIndex) {
                error = "index " + logEntry.getIndex() + " < last applied index " + this.lastAppliedIndex;
            } else if (logEntry.getIndex() != expectedIndex) {
                error = "index " + logEntry.getIndex() + " != expected index " + expectedIndex;
            }
            if (error != null) {
                this.warn("deleting bogus log file " + logEntry.getFile().getName() + ": " + error);
                this.deleteFile(logEntry.getFile(), "bogus log file");
                i.remove();
                continue;
            }
            ++expectedIndex;
            lastTermSeen = logEntry.getTerm();
        }
        if (this.log.isDebugEnabled()) {
            this.debug("recovered " + this.raftLog.size() + " log entries: " + this.raftLog + " (" + this.getUnappliedLogMemoryUsage() + " total bytes)");
        }
        this.currentConfig = this.buildCurrentConfig();
    }

    Map<String, String> buildCurrentConfig() {
        HashMap<String, String> config = new HashMap<String, String>(this.lastAppliedConfig);
        for (LogEntry logEntry : this.raftLog) {
            logEntry.applyConfigChange(config);
        }
        return config;
    }

    synchronized ListenableFuture<Void> watchKey(RaftKVTransaction tx, byte[] key) {
        Preconditions.checkState((this.role != null ? 1 : 0) != 0, (Object)"not started");
        tx.verifyExecuting();
        if (this.keyWatchTracker == null) {
            this.keyWatchTracker = new KeyWatchTracker();
        }
        return this.keyWatchTracker.register(key);
    }

    public RaftKVTransaction createTransaction() {
        return this.createTransaction(Consistency.LINEARIZABLE);
    }

    public RaftKVTransaction createTransaction(Map<String, ?> options) {
        if (options == null) {
            return this.createTransaction(Consistency.LINEARIZABLE);
        }
        Consistency consistency = null;
        Object isolation = options.get("org.springframework.transaction.annotation.Isolation");
        if (isolation instanceof Enum) {
            isolation = ((Enum)isolation).name();
        }
        if (isolation != null) {
            switch (isolation.toString()) {
                case "READ_UNCOMMITTED": {
                    consistency = Consistency.UNCOMMITTED;
                    break;
                }
                case "READ_COMMITTED": {
                    consistency = Consistency.EVENTUAL_COMMITTED;
                    break;
                }
                case "REPEATABLE_READ": {
                    consistency = Consistency.EVENTUAL;
                    break;
                }
                case "SERIALIZABLE": {
                    consistency = Consistency.LINEARIZABLE;
                    break;
                }
            }
        }
        try {
            Object value = options.get(OPTION_CONSISTENCY);
            if (value instanceof Consistency) {
                consistency = (Consistency)((Object)value);
            } else if (value instanceof String) {
                consistency = Consistency.valueOf((String)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createTransaction(consistency != null ? consistency : Consistency.LINEARIZABLE);
    }

    public synchronized RaftKVTransaction createTransaction(Consistency consistency) {
        assert (this.checkState());
        Preconditions.checkState((consistency != null ? 1 : 0) != 0, (Object)"null consistency");
        Preconditions.checkState((this.role != null ? 1 : 0) != 0, (Object)"not started");
        Preconditions.checkState((!this.shuttingDown ? 1 : 0) != 0, (Object)"shutting down");
        MostRecentView view = new MostRecentView(this, consistency.isBasedOnCommittedLogEntry() ? this.commitIndex : -1L);
        long baseTerm = view.getTerm();
        long baseIndex = view.getIndex();
        RaftKVTransaction tx = new RaftKVTransaction(this, consistency, baseTerm, baseIndex, view.getSnapshot(), view.getView());
        tx.setTimeout(this.commitTimeout);
        this.openTransactions.put(tx.txId, (Object)tx);
        switch (consistency) {
            case UNCOMMITTED: {
                tx.setCommittable();
                break;
            }
            case EVENTUAL_COMMITTED: {
                tx.setCommitInfo(baseTerm, baseIndex, null);
                tx.setCommittable();
                break;
            }
            case EVENTUAL: {
                tx.setCommitInfo(baseTerm, baseIndex, null);
                this.role.checkCommittable(tx);
                break;
            }
            case LINEARIZABLE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.debug("created new transaction " + tx);
        }
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void commit(final RaftKVTransaction tx) {
        try {
            RaftKVDatabase raftKVDatabase = this;
            synchronized (raftKVDatabase) {
                assert (this.checkState());
                assert (this.role != null);
                switch (tx.getState()) {
                    case EXECUTING: {
                        if (this.log.isDebugEnabled()) {
                            this.debug("committing transaction " + tx);
                        }
                        tx.setState(TxState.COMMIT_READY);
                        this.requestService(new CheckReadyTransactionService(this.role, tx));
                        tx.setFailure(null);
                        if (tx.getTimeout() == 0) break;
                        Timer commitTimer = new Timer(this, "commit timer for " + tx, new Service("commit timeout for tx#" + tx.txId){

                            @Override
                            public void run() {
                                switch (tx.getState()) {
                                    case COMMIT_READY: 
                                    case COMMIT_WAITING: {
                                        RaftKVDatabase.this.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, "transaction failed to complete within " + tx.getTimeout() + "ms (in state " + (Object)((Object)tx.getState()) + ")")));
                                        break;
                                    }
                                }
                            }
                        });
                        commitTimer.timeoutAfter(tx.getTimeout());
                        tx.setCommitTimer(commitTimer);
                        break;
                    }
                    case CLOSED: {
                        try {
                            tx.verifyExecuting();
                        }
                        finally {
                            tx.setFailure(null);
                        }
                        assert (false);
                        return;
                    }
                    default: {
                        this.warn("simultaneous commit()'s requested for " + tx + " by two different threads");
                    }
                }
            }
            try {
                tx.getCommitFuture().get();
                return;
            }
            catch (InterruptedException e) {
                throw new RetryTransactionException((KVTransaction)tx, "thread interrupted while waiting for commit", (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                ThrowableUtil.prependCurrentStackTrace((Throwable)cause);
                Throwables.throwIfUnchecked((Throwable)cause);
                throw new KVTransactionException((KVTransaction)tx, "commit failed", cause);
            }
        }
        finally {
            this.cleanupTransaction(tx);
        }
    }

    synchronized void rollback(RaftKVTransaction tx) {
        assert (this.checkState());
        assert (this.role != null);
        tx.setFailure(null);
        switch (tx.getState()) {
            case EXECUTING: {
                if (this.log.isDebugEnabled()) {
                    this.debug("rolling back transaction " + tx);
                }
                this.cleanupTransaction(tx);
                break;
            }
            case CLOSED: {
                break;
            }
            default: {
                this.warn("simultaneous commit() and rollback() requested for " + tx + " by two different threads");
            }
        }
    }

    synchronized void cleanupTransaction(RaftKVTransaction tx) {
        if (this.log.isTraceEnabled()) {
            this.trace("cleaning up transaction " + tx);
        }
        if (this.role != null) {
            this.role.cleanupForTransaction(tx);
        }
        if (tx.getCommitTimer() != null) {
            tx.getCommitTimer().cancel();
        }
        this.openTransactions.remove(tx.txId);
        tx.setState(TxState.CLOSED);
        tx.setNoLongerRebasable();
        if (this.shuttingDown) {
            this.notify();
        }
    }

    void succeed(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this));
        assert (this.role != null);
        assert (tx.getState().equals((Object)TxState.COMMIT_READY) || tx.getState().equals((Object)TxState.COMMIT_WAITING));
        if (this.log.isDebugEnabled()) {
            this.debug("successfully committed " + tx);
        }
        tx.getCommitFuture().set(null);
        tx.setState(TxState.COMPLETED);
        tx.setNoLongerRebasable();
        this.role.cleanupForTransaction(tx);
    }

    void fail(RaftKVTransaction tx, KVTransactionException e) {
        assert (Thread.holdsLock(this));
        assert (this.role != null);
        assert (e != null);
        if (this.log.isDebugEnabled()) {
            this.debug("failing transaction " + tx + ": " + (Object)((Object)e));
        }
        switch (tx.getState()) {
            case EXECUTING: {
                assert (tx.getFailure() == null);
                tx.setFailure(e);
                this.cleanupTransaction(tx);
                break;
            }
            case COMMIT_READY: 
            case COMMIT_WAITING: {
                tx.getCommitFuture().setException((Throwable)e);
                tx.setState(TxState.COMPLETED);
                tx.setNoLongerRebasable();
                this.role.cleanupForTransaction(tx);
                break;
            }
            default: {
                return;
            }
        }
    }

    void requestService(Service service) {
        block5: {
            assert (Thread.holdsLock(this));
            assert (service != null);
            if (!this.pendingService.add(service) || this.performingService) {
                return;
            }
            try {
                this.serviceExecutor.submit(() -> {
                    try {
                        this.handlePendingService();
                    }
                    catch (Throwable t) {
                        this.error("exception in handlePendingService()", t);
                        this.lastInternalError = t;
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (this.shuttingDown) break block5;
                this.warn("service executor task rejected, skipping", e);
                this.lastInternalError = e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handlePendingService() {
        block12: {
            assert (this.checkState());
            if (this.role == null) {
                return;
            }
            this.performingService = true;
            block5: while (true) {
                while (!this.pendingService.isEmpty()) {
                    Iterator i = this.pendingService.iterator();
                    Service service = (Service)i.next();
                    i.remove();
                    assert (service != null);
                    assert (service.getRole() == null || service.getRole() == this.role);
                    if (this.log.isTraceEnabled()) {
                        this.trace("SERVICE [" + service + "] in " + this.role);
                    }
                    try {
                        service.run();
                        continue block5;
                    }
                    catch (Throwable t) {
                        this.error("exception in " + service, t);
                        this.lastInternalError = t;
                    }
                }
                break block12;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                this.performingService = false;
            }
        }
    }

    boolean discardFlipFloppedStateMachine() {
        boolean dirty;
        byte[] dirtyPrefix = this.getFlipFloppedStateMachinePrefix();
        try (CloseableIterator i = this.kv.getRange(KeyRange.forPrefix((byte[])dirtyPrefix));){
            dirty = i.hasNext();
        }
        if (dirty) {
            this.kv.removeRange(dirtyPrefix, ByteUtil.getKeyAfterPrefix((byte[])dirtyPrefix));
        }
        return dirty;
    }

    boolean flipFlopStateMachine(long term, long index, Map<String, String> config) {
        assert (Thread.holdsLock(this));
        assert (term >= 0L);
        assert (index >= 0L);
        if (this.log.isDebugEnabled()) {
            this.debug("performing state machine flip-flop to " + index + "t" + term + " with config " + config);
        }
        if (config == null) {
            config = new HashMap<String, String>(0);
        }
        Writes writes = new Writes();
        writes.getPuts().put(LAST_APPLIED_TERM_KEY, LongEncoder.encode((long)term));
        writes.getPuts().put(LAST_APPLIED_INDEX_KEY, LongEncoder.encode((long)index));
        writes.getPuts().put(LAST_APPLIED_CONFIG_KEY, this.encodeConfig(config));
        writes.getPuts().put(FLIP_FLOP_KEY, this.encodeBoolean(!this.flipflop));
        try {
            this.kv.mutate((Mutations)writes, true);
        }
        catch (Exception e) {
            this.error("flip-flop error updating key/value store term/index to " + index + "t" + term, e);
            return false;
        }
        this.raftLog.clear();
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.logDir.toPath());){
            for (Path path : files) {
                File file = path.toFile();
                if (!LogEntry.LOG_FILE_PATTERN.matcher(file.getName()).matches()) continue;
                this.deleteFile(file, "unapplied log file");
            }
        }
        catch (IOException e) {
            this.error("error deleting unapplied log files in " + this.logDir + " (ignoring)", e);
        }
        this.flipflop = !this.flipflop;
        this.lastAppliedTerm = term;
        this.lastAppliedIndex = index;
        Arrays.fill(this.appliedTerms, 0L);
        this.lastAppliedConfig = config;
        this.commitIndex = this.lastAppliedIndex;
        TreeMap<String, String> previousConfig = new TreeMap<String, String>(this.currentConfig);
        this.currentConfig = this.buildCurrentConfig();
        if (!this.currentConfig.equals(previousConfig)) {
            this.info("apply new cluster configuration after snapshot install: " + this.currentConfig);
        }
        this.discardFlipFloppedStateMachine();
        this.requestService(this.role.triggerKeyWatchesService);
        return true;
    }

    boolean advanceTerm(long newTerm) {
        assert (Thread.holdsLock(this));
        assert (newTerm > this.currentTerm);
        if (this.log.isDebugEnabled()) {
            this.debug("advancing current term from " + this.currentTerm + " -> " + newTerm);
        }
        Writes writes = new Writes();
        writes.getPuts().put(CURRENT_TERM_KEY, LongEncoder.encode((long)newTerm));
        writes.getRemoves().add(new KeyRange(VOTED_FOR_KEY));
        try {
            this.kv.mutate((Mutations)writes, true);
        }
        catch (Exception e) {
            this.error("error persisting new term " + newTerm, e);
            return false;
        }
        this.currentTerm = newTerm;
        this.currentTermStartTime = System.currentTimeMillis();
        return true;
    }

    boolean joinCluster(int newClusterId) {
        assert (Thread.holdsLock(this));
        Preconditions.checkArgument((newClusterId != 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.clusterId == 0 ? 1 : 0) != 0);
        this.info("joining cluster with ID " + String.format("0x%08x", newClusterId));
        Writes writes = new Writes();
        writes.getPuts().put(CLUSTER_ID_KEY, LongEncoder.encode((long)newClusterId));
        try {
            this.kv.mutate((Mutations)writes, true);
        }
        catch (Exception e) {
            this.error("error updating key/value store with new cluster ID", e);
            return false;
        }
        this.clusterId = newClusterId;
        return true;
    }

    byte[] getStateMachinePrefix() {
        return this.getStateMachinePrefix(false);
    }

    byte[] getFlipFloppedStateMachinePrefix() {
        return this.getStateMachinePrefix(true);
    }

    private byte[] getStateMachinePrefix(boolean flipFlopped) {
        return new byte[]{STATE_MACHINE_PREFIXES[flipFlopped ^ this.flipflop ? 1 : 0]};
    }

    void changeRole(Role role) {
        assert (Thread.holdsLock(this));
        assert (role != null);
        if (this.role != null) {
            this.role.shutdown();
            Iterator i = this.pendingService.iterator();
            while (i.hasNext()) {
                Service service = (Service)i.next();
                if (service.getRole() == null) continue;
                i.remove();
            }
        }
        this.role = role;
        this.role.setup();
        if (this.log.isDebugEnabled()) {
            this.debug("changing role to " + role);
        }
        assert (this.checkState());
    }

    LogEntry appendLogEntry(long term, NewLogEntry newLogEntry) throws Exception {
        assert (Thread.holdsLock(this));
        assert (this.role != null);
        assert (newLogEntry != null);
        LogEntry.Data data = newLogEntry.getData();
        File tempFile = newLogEntry.getTempFile();
        long fileLength = Util.getLength(tempFile);
        LogEntry logEntry = new LogEntry(term, this.getLastLogIndex() + 1L, this.logDir, data, fileLength);
        if (this.log.isDebugEnabled()) {
            this.debug("adding new log entry " + logEntry + " using " + tempFile.getName());
        }
        Files.move(tempFile.toPath(), logEntry.getFile().toPath(), StandardCopyOption.ATOMIC_MOVE);
        if (this.logDirChannel != null && !this.disableSync) {
            this.logDirChannel.force(true);
        }
        newLogEntry.resetTempFile();
        this.raftLog.add(logEntry);
        if (logEntry.applyConfigChange(this.currentConfig)) {
            this.info("applying new cluster configuration from log entry " + logEntry + ": " + this.currentConfig);
        }
        return logEntry;
    }

    long getLastLogIndex() {
        assert (Thread.holdsLock(this));
        return this.lastAppliedIndex + (long)this.raftLog.size();
    }

    long getLastLogTerm() {
        assert (Thread.holdsLock(this));
        return this.getLogTermAtIndex(this.getLastLogIndex());
    }

    long getLogTermAtIndex(long index) {
        assert (Thread.holdsLock(this));
        assert (index >= this.lastAppliedIndex);
        assert (index <= this.getLastLogIndex());
        return index == this.lastAppliedIndex ? this.lastAppliedTerm : this.getLogEntryAtIndex(index).getTerm();
    }

    LogEntry getLogEntryAtIndex(long index) {
        assert (Thread.holdsLock(this));
        assert (index > this.lastAppliedIndex);
        assert (index <= this.getLastLogIndex());
        return this.raftLog.get((int)(index - this.lastAppliedIndex - 1L));
    }

    void incrementLastAppliedIndex(long term) {
        assert (Thread.holdsLock(this));
        this.appliedTerms[(int)(this.lastAppliedIndex % 128L)] = this.lastAppliedTerm;
        ++this.lastAppliedIndex;
        this.lastAppliedTerm = term;
    }

    long getAppliedLogEntryTerm(long index) {
        assert (index < this.lastAppliedIndex);
        if (index < this.lastAppliedIndex - 128L) {
            return 0L;
        }
        return this.appliedTerms[(int)(index % 128L)];
    }

    long getLogTermAtIndexIfKnown(long index) {
        return index >= this.lastAppliedIndex ? this.getLogTermAtIndex(index) : this.getAppliedLogEntryTerm(index);
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "[identity=" + (this.identity != null ? "\"" + this.identity + "\"" : null) + ",logDir=" + this.logDir + ",term=" + this.currentTerm + ",commitIndex=" + this.commitIndex + ",lastApplied=" + this.lastAppliedIndex + "t" + this.lastAppliedTerm + ",raftLog=" + this.raftLog + ",role=" + this.role + (this.shuttingDown ? ",shuttingDown" : "") + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(String sender, ByteBuffer buf) {
        NewLogEntry newLogEntry;
        ByteBuffer mutationData;
        Message msg;
        int protocolVersion;
        try {
            protocolVersion = Message.decodeProtocolVersion(buf);
            msg = Message.decode(buf, protocolVersion);
        }
        catch (IllegalArgumentException e) {
            this.error("rec'd bogus message from " + sender + ", ignoring", e);
            return;
        }
        ByteBuffer byteBuffer = msg instanceof AppendRequest ? ((AppendRequest)msg).getMutationData() : (mutationData = msg instanceof CommitRequest ? ((CommitRequest)msg).getMutationData() : null);
        if (mutationData != null) {
            File tempFile = null;
            try {
                tempFile = this.getTempFile();
                try (FileWriter output = new FileWriter(tempFile, this.disableSync);){
                    FileChannel channel = output.getFileOutputStream().getChannel();
                    ByteBuffer writeBuf = mutationData.asReadOnlyBuffer();
                    while (writeBuf.hasRemaining()) {
                        channel.write(writeBuf);
                    }
                }
                var9_10 = null;
                try (ByteBufferInputStream input = new ByteBufferInputStream(mutationData);){
                    newLogEntry = new NewLogEntry(LogEntry.readData((InputStream)input), tempFile);
                }
                catch (Throwable throwable) {
                    var9_10 = throwable;
                    throw throwable;
                }
                tempFile = null;
            }
            catch (IOException e) {
                this.error("error persisting mutations from " + msg + ", ignoring", e);
                return;
            }
            finally {
                if (tempFile != null) {
                    this.deleteFile(tempFile, "new log entry temp file");
                }
            }
        }
        newLogEntry = null;
        try {
            this.receiveMessage(sender, msg, protocolVersion, newLogEntry);
        }
        finally {
            if (newLogEntry != null) {
                newLogEntry.cleanup(this);
            }
        }
    }

    private synchronized void outputQueueEmpty(String address) {
        assert (this.checkState());
        if (!this.transmitting.remove(address)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.trace("QUEUE_EMPTY address " + address + " in " + this.role);
        }
        if (this.role == null) {
            return;
        }
        this.role.outputQueueEmpty(address);
    }

    boolean isTransmitting(String address) {
        return this.transmitting.contains(address);
    }

    synchronized boolean sendMessage(Message msg) {
        ByteBuffer encodedMessage;
        assert (Thread.holdsLock(this));
        String peer = msg.getRecipientId();
        String address = this.currentConfig.get(peer);
        if (address == null) {
            address = this.returnAddress;
        }
        if (address == null) {
            this.warn("can't send " + msg + " to unknown peer \"" + peer + "\"");
            return false;
        }
        int protocolVersion = this.protocolVersionMap.getOrDefault(peer, Message.getCurrentProtocolVersion());
        if (this.log.isTraceEnabled()) {
            this.trace("XMIT " + msg + " to " + address + " (version " + protocolVersion + ")");
        }
        try {
            encodedMessage = msg.encode(protocolVersion);
        }
        catch (IllegalArgumentException e) {
            this.warn("can't send " + msg + " to peer \"" + peer + "\": " + e, e);
            return false;
        }
        if (this.network.send(address, encodedMessage)) {
            this.transmitting.add(address);
            return true;
        }
        this.warn("transmit of " + msg + " to \"" + peer + "\" failed locally");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void receiveMessage(String address, Message msg, int protocolVersion, final NewLogEntry newLogEntry) {
        assert (newLogEntry == null || msg instanceof AppendRequest || msg instanceof CommitRequest);
        assert (Thread.holdsLock(this));
        assert (this.checkState());
        if (this.role == null) {
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd " + msg + " rec'd in shutdown state; ignoring");
            }
            return;
        }
        if (msg.getClusterId() == 0) {
            this.warn("rec'd " + msg + " with zero cluster ID from " + address + "; ignoring");
            return;
        }
        if (this.clusterId != 0 && msg.getClusterId() != this.clusterId) {
            this.warn("rec'd " + msg + " with foreign cluster ID " + String.format("0x%08x", msg.getClusterId()) + " != " + String.format("0x%08x", this.clusterId) + "; ignoring");
            return;
        }
        String peer = msg.getSenderId();
        if (peer.equals(this.identity)) {
            this.warn("rec'd " + msg + " from myself (\"" + peer + "\", address " + address + "); ignoring");
            return;
        }
        String dest = msg.getRecipientId();
        if (!dest.equals(this.identity)) {
            this.warn("rec'd misdirected " + msg + " intended for \"" + dest + "\" from " + address + "; ignoring");
            return;
        }
        if (protocolVersion != -1) {
            Integer previousVersion = this.protocolVersionMap.put(peer, protocolVersion);
            if (!Integer.valueOf(protocolVersion).equals(previousVersion) && this.log.isDebugEnabled()) {
                this.debug("set protocol encoding version for peer \"" + peer + "\" to " + protocolVersion);
            }
        }
        if (msg.getTerm() > this.currentTerm) {
            if (!this.role.mayAdvanceCurrentTerm(msg)) {
                if (this.log.isTraceEnabled()) {
                    this.trace("rec'd " + msg + " with term " + msg.getTerm() + " > " + this.currentTerm + " from \"" + peer + "\" but current role says to ignore it");
                }
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd " + msg.getClass().getSimpleName() + " with term " + msg.getTerm() + " > " + this.currentTerm + " from \"" + peer + "\", updating term and " + (this.role instanceof FollowerRole ? "remaining a" : "reverting to") + " follower");
            }
            if (!this.advanceTerm(msg.getTerm())) {
                return;
            }
            this.changeRole(msg.isLeaderMessage() ? new FollowerRole(this, peer, address) : new FollowerRole(this));
        }
        if (msg.getTerm() < this.currentTerm && !(msg instanceof PingRequest)) {
            if (this.log.isDebugEnabled()) {
                this.debug("rec'd " + msg + " with term " + msg.getTerm() + " < " + this.currentTerm + " from \"" + peer + "\" at " + address + ", ignoring");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.trace("RECV " + msg + " in " + this.role + " from " + address + " (protocol version " + protocolVersion + ")");
        }
        this.returnAddress = address;
        try {
            msg.visit(new MessageSwitch(){

                @Override
                public void caseAppendRequest(AppendRequest msg) {
                    RaftKVDatabase.this.role.caseAppendRequest(msg, newLogEntry);
                }

                @Override
                public void caseAppendResponse(AppendResponse msg) {
                    RaftKVDatabase.this.role.caseAppendResponse(msg);
                }

                @Override
                public void caseCommitRequest(CommitRequest msg) {
                    RaftKVDatabase.this.role.caseCommitRequest(msg, newLogEntry);
                }

                @Override
                public void caseCommitResponse(CommitResponse msg) {
                    RaftKVDatabase.this.role.caseCommitResponse(msg);
                }

                @Override
                public void caseGrantVote(GrantVote msg) {
                    RaftKVDatabase.this.role.caseGrantVote(msg);
                }

                @Override
                public void caseInstallSnapshot(InstallSnapshot msg) {
                    RaftKVDatabase.this.role.caseInstallSnapshot(msg);
                }

                @Override
                public void casePingRequest(PingRequest msg) {
                    RaftKVDatabase.this.role.casePingRequest(msg);
                }

                @Override
                public void casePingResponse(PingResponse msg) {
                    RaftKVDatabase.this.role.casePingResponse(msg);
                }

                @Override
                public void caseRequestVote(RequestVote msg) {
                    RaftKVDatabase.this.role.caseRequestVote(msg);
                }
            });
        }
        finally {
            this.returnAddress = null;
        }
    }

    synchronized void deleteFile(File file, String description) {
        if (this.ioThread == null) {
            Util.delete(file, description);
            return;
        }
        this.ioThread.deleteFile(file, description);
    }

    synchronized File getTempFile() throws IOException {
        if (this.ioThread == null) {
            throw new IOException("instance is shutdown");
        }
        return this.ioThread.getTempFile();
    }

    byte[] encodeBoolean(boolean value) {
        return new byte[]{value ? (byte)1 : 0};
    }

    boolean decodeBoolean(byte[] key) throws IOException {
        byte[] value = this.kv.get(key);
        return value != null && value.length > 0 && value[0] != 0;
    }

    long decodeLong(byte[] key, long defaultValue) throws IOException {
        byte[] value = this.kv.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return LongEncoder.decode((byte[])value);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("can't interpret encoded long value " + ByteUtil.toString((byte[])value) + " under key " + ByteUtil.toString((byte[])key), e);
        }
    }

    String decodeString(byte[] key, String defaultValue) throws IOException {
        byte[] value = this.kv.get(key);
        if (value == null) {
            return defaultValue;
        }
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(value));
        try {
            return input.readUTF();
        }
        catch (IOException e) {
            throw new IOException("can't interpret encoded string value " + ByteUtil.toString((byte[])value) + " under key " + ByteUtil.toString((byte[])key), e);
        }
    }

    byte[] encodeString(String value) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buf);
        try {
            output.writeUTF(value);
            output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected error", e);
        }
        return buf.toByteArray();
    }

    Map<String, String> decodeConfig(byte[] key) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        byte[] value = this.kv.get(key);
        if (value == null) {
            return config;
        }
        try {
            DataInputStream data = new DataInputStream(new ByteArrayInputStream(value));
            while (true) {
                data.mark(1);
                if (data.read() != -1) {
                    data.reset();
                    config.put(data.readUTF(), data.readUTF());
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IOException("can't interpret encoded config " + ByteUtil.toString((byte[])value) + " under key " + ByteUtil.toString((byte[])key), e);
        }
        return config;
    }

    byte[] encodeConfig(Map<String, String> config) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(buf);
        try {
            for (Map.Entry<String, String> entry : config.entrySet()) {
                data.writeUTF(entry.getKey());
                data.writeUTF(entry.getValue());
            }
            data.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected error", e);
        }
        return buf.toByteArray();
    }

    void trace(String msg, Throwable t) {
        this.log.trace(String.format("%s %s: %s", new Timestamp(), this.identity, msg), t);
    }

    void trace(String msg) {
        this.log.trace(String.format("%s %s: %s", new Timestamp(), this.identity, msg));
    }

    void debug(String msg, Throwable t) {
        this.log.debug(String.format("%s %s: %s", new Timestamp(), this.identity, msg), t);
    }

    void debug(String msg) {
        this.log.debug(String.format("%s %s: %s", new Timestamp(), this.identity, msg));
    }

    void info(String msg, Throwable t) {
        this.log.info(String.format("%s %s: %s", new Timestamp(), this.identity, msg), t);
    }

    void info(String msg) {
        this.log.info(String.format("%s %s: %s", new Timestamp(), this.identity, msg));
    }

    void warn(String msg, Throwable t) {
        this.log.warn(String.format("%s %s: %s", new Timestamp(), this.identity, msg), t);
    }

    void warn(String msg) {
        this.log.warn(String.format("%s %s: %s", new Timestamp(), this.identity, msg));
    }

    void error(String msg, Throwable t) {
        this.log.error(String.format("%s %s: %s", new Timestamp(), this.identity, msg), t);
    }

    void error(String msg) {
        this.log.error(String.format("%s %s: %s", new Timestamp(), this.identity, msg));
    }

    private boolean checkState() {
        try {
            this.doCheckState();
        }
        catch (AssertionError e) {
            throw new AssertionError("checkState() failure for " + this, (Throwable)((Object)e));
        }
        return true;
    }

    private void doCheckState() {
        assert (Thread.holdsLock(this));
        if (this.role == null) {
            assert (this.random == null);
            assert (this.currentTerm == 0L);
            assert (this.currentTermStartTime == 0L);
            assert (this.commitIndex == 0L);
            assert (this.lastAppliedTerm == 0L);
            assert (this.lastAppliedIndex == 0L);
            assert (this.lastAppliedConfig == null);
            assert (this.currentConfig == null);
            assert (this.clusterId == 0);
            assert (this.raftLog.isEmpty());
            assert (this.logDirChannel == null);
            assert (this.serviceExecutor == null);
            assert (this.keyWatchTracker == null);
            assert (this.transmitting.isEmpty());
            assert (this.openTransactions.isEmpty());
            assert (this.pendingService.isEmpty());
            assert (!this.shuttingDown);
            return;
        }
        assert (this.kv != null);
        assert (this.random != null);
        assert (this.serviceExecutor != null);
        assert (this.logDirChannel != null || this.isWindows());
        assert (!this.serviceExecutor.isShutdown() || this.shuttingDown);
        assert (this.currentTerm >= 0L);
        assert (this.commitIndex >= 0L);
        assert (this.lastAppliedTerm >= 0L);
        assert (this.lastAppliedIndex >= 0L);
        assert (this.lastAppliedConfig != null);
        assert (this.currentConfig != null);
        assert (this.currentTerm >= this.lastAppliedTerm);
        assert (this.commitIndex >= this.lastAppliedIndex);
        assert (this.commitIndex <= this.lastAppliedIndex + (long)this.raftLog.size());
        assert (this.keyWatchIndex <= this.commitIndex);
        long index = this.lastAppliedIndex;
        long term = this.lastAppliedTerm;
        for (LogEntry logEntry : this.raftLog) {
            assert (logEntry.getIndex() == index + 1L);
            assert (logEntry.getTerm() >= term);
            index = logEntry.getIndex();
            term = logEntry.getTerm();
        }
        if (this.isConfigured()) {
            assert (this.clusterId != 0);
            assert (this.currentTerm > 0L);
            assert (this.lastAppliedTerm >= 0L);
            assert (this.lastAppliedIndex >= 0L);
            assert (!this.currentConfig.isEmpty());
            assert (this.currentConfig.equals(this.buildCurrentConfig()));
            assert (this.getLastLogTerm() > 0L);
            assert (this.getLastLogIndex() > 0L);
        } else {
            assert (this.lastAppliedTerm == 0L);
            assert (this.lastAppliedIndex == 0L);
            assert (this.lastAppliedConfig.isEmpty());
            assert (this.currentConfig.isEmpty());
            assert (this.raftLog.isEmpty());
        }
        assert (this.role.checkState());
        for (RaftKVTransaction tx : this.openTransactions.values()) {
            try {
                assert (!tx.getState().equals((Object)TxState.CLOSED));
                tx.checkStateOpen(this.currentTerm, this.getLastLogIndex(), this.commitIndex);
                this.role.checkTransaction(tx);
            }
            catch (AssertionError e) {
                throw new AssertionError("checkState() failure for " + tx, (Throwable)((Object)e));
            }
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("win");
    }

    private static class FileInfo {
        private final File file;
        private final String description;

        FileInfo(File file) {
            this(file, null);
        }

        FileInfo(File file, String description) {
            Preconditions.checkArgument((file != null ? 1 : 0) != 0);
            this.file = file;
            this.description = description;
        }

        public File getFile() {
            return this.file;
        }

        public String getDescription() {
            return this.description;
        }
    }

    private static final class IOThread
    extends Thread {
        private static final long MAX_WAIT_SECONDS = 1L;
        private static final int MAX_TEMP_FILES = 10;
        private static final int MAX_DELETE_FILES = 1000;
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final File tempDir;
        private final ArrayBlockingQueue<FileInfo> availableTempFiles = new ArrayBlockingQueue(10);
        private final ArrayBlockingQueue<FileInfo> filesToDelete = new ArrayBlockingQueue(1000);
        private boolean shutdown;
        private boolean didWarnDelete;
        private boolean didWarnTempFile;

        private IOThread(File tempDir, String threadName) {
            super(threadName);
            Preconditions.checkArgument((tempDir != null ? 1 : 0) != 0);
            this.tempDir = tempDir;
        }

        public synchronized void shutdown() {
            this.shutdown = true;
            this.notifyAll();
        }

        public synchronized void deleteFile(File file, String description) {
            assert (file != null);
            assert (description != null);
            try {
                this.filesToDelete.add(new FileInfo(file, description));
            }
            catch (IllegalStateException e) {
                if (!this.didWarnDelete) {
                    this.log.error("file deletion queue is full (suppressing further warnings)", (Throwable)e);
                    this.didWarnDelete = true;
                }
                Util.delete(file, description);
                return;
            }
            this.notifyAll();
        }

        public synchronized File getTempFile() throws IOException {
            FileInfo fileInfo;
            try {
                fileInfo = (FileInfo)this.availableTempFiles.remove();
            }
            catch (NoSuchElementException e) {
                return File.createTempFile(RaftKVDatabase.TEMP_FILE_PREFIX, RaftKVDatabase.TEMP_FILE_SUFFIX, this.tempDir);
            }
            this.notifyAll();
            return fileInfo.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    IOThread iOThread = this;
                    synchronized (iOThread) {
                        while (!this.shutdown && this.filesToDelete.isEmpty() && this.availableTempFiles.remainingCapacity() == 0) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                this.log.warn(this + " interrupted, ignoring", (Throwable)e);
                            }
                        }
                        if (this.shutdown) {
                            break;
                        }
                    }
                    if (!this.filesToDelete.isEmpty()) {
                        this.deleteFiles(this.filesToDelete, true);
                    }
                    if (this.availableTempFiles.remainingCapacity() <= 0) continue;
                    try {
                        this.availableTempFiles.add(new FileInfo(File.createTempFile(RaftKVDatabase.TEMP_FILE_PREFIX, RaftKVDatabase.TEMP_FILE_SUFFIX, this.tempDir), "ready temporary file"));
                    }
                    catch (IOException e) {
                        if (this.didWarnTempFile) continue;
                        this.log.error("error creating temporary file in " + this.tempDir + " (suppressing further warnings)", (Throwable)e);
                        this.didWarnTempFile = true;
                    }
                }
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable t) {
                this.log.error("error in " + this + ", bailing out", t);
            }
            finally {
                this.cleanup();
            }
        }

        private void cleanup() {
            this.deleteFiles(this.availableTempFiles, false);
            this.deleteFiles(this.filesToDelete, true);
        }

        private void deleteFiles(ArrayBlockingQueue<FileInfo> queue, boolean warn) {
            while (true) {
                FileInfo fileInfo;
                try {
                    fileInfo = (FileInfo)queue.remove();
                }
                catch (NoSuchElementException e) {
                    break;
                }
                Util.delete(fileInfo.getFile(), warn ? fileInfo.getDescription() : null);
            }
        }
    }
}

