/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.StaleTransactionException;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.SnapshotRefs;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.raft.Consistency;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.Timer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.TxState;
import org.jsimpledb.kv.util.CloseableForwardingKVStore;
import org.jsimpledb.util.CloseableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RaftKVTransaction
implements KVTransaction {
    static final Comparator<RaftKVTransaction> SORT_BY_ID = Comparator.comparingLong(tx -> tx.txId);
    private static final AtomicLong COUNTER = new AtomicLong();
    final RaftKVDatabase raft;
    final long txId = COUNTER.incrementAndGet();
    final Consistency consistency;
    final MutableView view;
    @GuardedBy(value="raft")
    private long baseTerm;
    @GuardedBy(value="raft")
    private long baseIndex;
    @GuardedBy(value="raft")
    private long commitTerm;
    @GuardedBy(value="raft")
    private long commitIndex;
    @GuardedBy(value="raft")
    private boolean rebasable;
    @GuardedBy(value="raft")
    private TxState state = TxState.EXECUTING;
    private volatile boolean executing;
    @GuardedBy(value="raft")
    private Timestamp lastStateChangeTime = new Timestamp();
    @GuardedBy(value="raft")
    private boolean readOnly;
    @GuardedBy(value="raft")
    private String[] configChange;
    @GuardedBy(value="raft")
    private KVTransactionException failure;
    @GuardedBy(value="raft")
    private SnapshotRefs snapshotRefs;
    private final SettableFuture<Void> commitFuture = SettableFuture.create();
    @GuardedBy(value="raft")
    private Timer commitTimer;
    @GuardedBy(value="raft")
    private int timeout;
    @GuardedBy(value="raft")
    private boolean committable;
    @GuardedBy(value="raft")
    private Timestamp commitLeaderLeaseTimeout;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    RaftKVTransaction(RaftKVDatabase raft, Consistency consistency, long baseTerm, long baseIndex, CloseableKVStore snapshot, MutableView view) {
        this.raft = raft;
        this.consistency = consistency;
        this.baseTerm = baseTerm;
        this.baseIndex = baseIndex;
        this.snapshotRefs = new SnapshotRefs(snapshot);
        this.view = view;
        this.rebasable = consistency.isGuaranteesUpToDateReads();
        if (!this.rebasable) {
            this.view.disableReadTracking();
        }
    }

    public long getTxId() {
        return this.txId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TxState getState() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(TxState state) {
        assert (state != null);
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            assert (state.compareTo(this.state) >= 0);
            if (this.state.equals((Object)TxState.EXECUTING) && !this.state.equals((Object)state)) {
                MutableView mutableView = this.view;
                synchronized (mutableView) {
                    this.view.setReadOnly();
                }
                this.snapshotRefs.unref();
                this.snapshotRefs = null;
            }
            this.state = state;
            this.lastStateChangeTime = new Timestamp();
            this.executing = state.equals((Object)TxState.EXECUTING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLastStateChangeTime() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.lastStateChangeTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBaseTerm() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.baseTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBaseIndex() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.baseIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCommitTerm() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.commitTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCommitIndex() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.commitIndex;
        }
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.readOnly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean readOnly) {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            if (readOnly == this.readOnly) {
                return;
            }
            Preconditions.checkArgument((readOnly || this.consistency.equals((Object)Consistency.LINEARIZABLE) ? 1 : 0) != 0, (Object)((Object)((Object)this.consistency) + " transactions must be read-only"));
            Preconditions.checkArgument((readOnly || !this.consistency.equals((Object)Consistency.LINEARIZABLE) ? 1 : 0) != 0, (Object)((Object)((Object)this.consistency) + " transactions cannot be changed back to read-write after being set read-only"));
            assert (this.consistency.equals((Object)Consistency.LINEARIZABLE));
            assert (!this.readOnly);
            this.verifyExecuting();
            this.readOnly = readOnly;
            this.raft.role.handleLinearizableReadOnlyChange(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChange(String identity, String address) {
        Preconditions.checkArgument((identity != null ? 1 : 0) != 0, (Object)"null identity");
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            Preconditions.checkState((this.configChange == null ? 1 : 0) != 0, (Object)"duplicate config change; only one is supported per transaction");
            Preconditions.checkState((!this.readOnly ? 1 : 0) != 0, (Object)"transaction is read-only");
            this.verifyExecuting();
            this.configChange = new String[]{identity, address};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConfigChange() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.configChange != null ? (String[])this.configChange.clone() : null;
        }
    }

    public byte[] get(byte[] key) {
        this.fastVerifyExecuting();
        return this.view.get(key);
    }

    public KVPair getAtLeast(byte[] minKey, byte[] maxKey) {
        this.fastVerifyExecuting();
        return this.view.getAtLeast(minKey, maxKey);
    }

    public KVPair getAtMost(byte[] maxKey, byte[] minKey) {
        this.fastVerifyExecuting();
        return this.view.getAtMost(maxKey, minKey);
    }

    public CloseableIterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        this.fastVerifyExecuting();
        return this.view.getRange(minKey, maxKey, reverse);
    }

    public void put(byte[] key, byte[] value) {
        this.fastVerifyExecuting();
        this.view.put(key, value);
    }

    public void remove(byte[] key) {
        this.fastVerifyExecuting();
        this.view.remove(key);
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        this.fastVerifyExecuting();
        this.view.removeRange(minKey, maxKey);
    }

    public void adjustCounter(byte[] key, long amount) {
        this.fastVerifyExecuting();
        this.view.adjustCounter(key, amount);
    }

    public byte[] encodeCounter(long value) {
        return this.view.encodeCounter(value);
    }

    public long decodeCounter(byte[] bytes) {
        return this.view.decodeCounter(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fastVerifyExecuting() {
        if (this.executing) {
            return;
        }
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            this.verifyExecuting();
        }
    }

    public RaftKVDatabase getKVDatabase() {
        return this.raft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long timeout) {
        Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout < 0");
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            if (timeout == (long)this.timeout) {
                return;
            }
            this.verifyExecuting();
            this.timeout = (int)Math.min(timeout, Integer.MAX_VALUE);
        }
    }

    public ListenableFuture<Void> watchKey(byte[] key) {
        return this.raft.watchKey(this, key);
    }

    public void commit() {
        this.raft.commit(this);
    }

    public void rollback() {
        this.raft.rollback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableKVStore mutableSnapshot() {
        Writes writes;
        Object object = this.view;
        synchronized (object) {
            writes = this.view.getWrites().clone();
        }
        object = this.raft;
        synchronized (object) {
            this.verifyExecuting();
            assert (this.snapshotRefs != null);
            this.snapshotRefs.ref();
            MutableView snapshotView = new MutableView(this.snapshotRefs.getKVStore(), null, writes);
            return new CloseableForwardingKVStore((KVStore)snapshotView, this.snapshotRefs.getUnrefCloseable());
        }
    }

    SettableFuture<Void> getCommitFuture() {
        return this.commitFuture;
    }

    int getTimeout() {
        return this.timeout;
    }

    Timer getCommitTimer() {
        return this.commitTimer;
    }

    void setCommitTimer(Timer commitTimer) {
        this.commitTimer = commitTimer;
    }

    KVTransactionException getFailure() {
        assert (Thread.holdsLock(this.raft));
        return this.failure;
    }

    Timestamp getCommitLeaderLeaseTimeout() {
        return this.commitLeaderLeaseTimeout;
    }

    void setFailure(KVTransactionException failure) {
        assert (Thread.holdsLock(this.raft));
        this.failure = failure;
    }

    boolean hasCommitInfo() {
        assert (this.commitTerm == 0L == (this.commitIndex == 0L));
        return this.commitTerm != 0L;
    }

    void setCommitInfo(long commitTerm, long commitIndex, Timestamp commitLeaderLeaseTimeout) {
        assert (Thread.holdsLock(this.raft));
        assert (!this.hasCommitInfo());
        if (this.raft.log.isTraceEnabled()) {
            this.raft.trace("setting commit to " + commitIndex + "t" + commitTerm + (commitLeaderLeaseTimeout != null ? "@" + commitLeaderLeaseTimeout : "") + " for " + this);
        }
        this.commitTerm = commitTerm;
        this.commitIndex = commitIndex;
        this.commitLeaderLeaseTimeout = commitLeaderLeaseTimeout;
        if (this.rebasable && this.baseIndex >= this.commitIndex) {
            this.setNoLongerRebasable();
        }
    }

    void rebase(long baseTerm, long baseIndex, KVStore kvstore, CloseableKVStore snapshot) {
        assert (Thread.holdsLock(this.view));
        assert (Thread.holdsLock(this.raft));
        assert (this.state.equals((Object)TxState.EXECUTING));
        assert (this.snapshotRefs != null);
        this.rebase(baseTerm, baseIndex);
        this.view.setKVStore(kvstore);
        this.snapshotRefs.unref();
        this.snapshotRefs = new SnapshotRefs(snapshot);
    }

    void rebase(long baseTerm, long baseIndex) {
        assert (baseIndex > this.baseIndex);
        this.setBase(baseTerm, baseIndex);
    }

    void setBase(long baseTerm, long baseIndex) {
        assert (Thread.holdsLock(this.raft));
        assert (this.failure == null);
        this.baseTerm = baseTerm;
        this.baseIndex = baseIndex;
    }

    void verifyExecuting() {
        assert (Thread.holdsLock(this.raft));
        if (!this.state.equals((Object)TxState.EXECUTING)) {
            throw this.failure != null ? this.failure.duplicate() : new StaleTransactionException((KVTransaction)this);
        }
    }

    boolean isCommittable() {
        assert (Thread.holdsLock(this.raft));
        return this.committable;
    }

    void setCommittable() {
        assert (Thread.holdsLock(this.raft));
        assert (!this.committable);
        this.committable = true;
    }

    boolean isRebasable() {
        assert (Thread.holdsLock(this.raft));
        return this.rebasable;
    }

    void setNoLongerRebasable() {
        assert (Thread.holdsLock(this.raft));
        assert (this.rebasable == (this.view.getReads() != null));
        if (this.rebasable) {
            if (this.raft.log.isTraceEnabled()) {
                this.raft.trace("stopping rebasing for " + this);
            }
            this.view.disableReadTracking();
            this.rebasable = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addsLogEntry() {
        assert (Thread.holdsLock(this.raft));
        if (this.readOnly) {
            return false;
        }
        if (this.configChange != null) {
            return true;
        }
        MutableView mutableView = this.view;
        synchronized (mutableView) {
            return !this.view.getWrites().isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        RaftKVDatabase raftKVDatabase = this.raft;
        synchronized (raftKVDatabase) {
            return this.getClass().getSimpleName() + "[txId=" + this.txId + "," + (Object)((Object)this.state) + ",base=" + this.baseIndex + "t" + this.baseTerm + (this.rebasable ? ",rebasable" : "") + "," + (Object)((Object)this.consistency) + (this.addsLogEntry() ? ",mutating" : (!this.readOnly ? ",non-mutating" : "")) + (this.readOnly ? ",readOnly" : "") + (this.configChange != null ? ",config=" + (this.configChange[1] != null ? "+" + this.configChange[0] + "@" + this.configChange[1] : "-" + this.configChange[0]) : "") + ((this.commitIndex | this.commitTerm) != 0L ? ",commit=" + this.commitIndex + "t" + this.commitTerm : "") + (this.committable ? ",committable" : "") + (this.timeout != 0 ? ",timeout=" + this.timeout : "") + (this.commitLeaderLeaseTimeout != null ? ",leaseTimeout=" + this.commitLeaderLeaseTimeout : "") + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            RaftKVDatabase raftKVDatabase = this.raft;
            synchronized (raftKVDatabase) {
                if (!TxState.CLOSED.equals((Object)this.state)) {
                    this.log.warn(this + " leaked without commit() or rollback()");
                    this.rollback();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    void checkStateOpen(long currentTerm, long lastIndex, long raftCommitIndex) {
        assert (!this.commitFuture.isCancelled());
        assert (this.commitFuture.isDone() == this.state.compareTo(TxState.COMPLETED) >= 0);
        if (this.state.compareTo(TxState.COMPLETED) < 0) {
            assert (this.baseTerm <= currentTerm);
            assert (this.commitIndex == 0L || this.commitIndex >= this.baseIndex);
        }
        assert (this.commitTerm <= currentTerm);
        assert (!this.committable || this.commitTerm > 0L || this.commitIndex > 0L || this.consistency == Consistency.UNCOMMITTED);
        assert (this.commitLeaderLeaseTimeout == null || this.commitTerm > 0L || this.commitIndex > 0L);
        assert (this.raft.role.checkRebasableAndCommittableUpToDate(this));
        assert (!this.rebasable || !this.committable);
        assert (!this.rebasable || this.baseIndex >= lastIndex);
        assert (!this.rebasable || this.consistency == Consistency.LINEARIZABLE);
        assert (!this.rebasable || this.commitIndex == 0L || this.commitIndex > raftCommitIndex);
        assert (!this.rebasable || this.commitIndex == 0L || !this.addsLogEntry());
        assert (this.rebasable == (this.view.getReads() != null));
        switch (this.consistency) {
            case LINEARIZABLE: {
                assert (!this.committable || this.addsLogEntry() || this.baseIndex == this.commitIndex || this.state.compareTo(TxState.COMMIT_WAITING) >= 0);
                assert (!this.committable || !this.addsLogEntry() || this.baseIndex < this.commitIndex);
                assert (this.commitIndex == 0L || !this.addsLogEntry() || this.state.compareTo(TxState.COMMIT_WAITING) >= 0);
                assert (this.commitTerm == 0L || this.commitTerm >= this.baseTerm);
                assert (this.commitIndex == 0L || this.commitIndex >= this.baseIndex);
                break;
            }
            case EVENTUAL: {
                assert (this.readOnly);
                assert (!this.rebasable);
                assert (this.configChange == null);
                assert (this.commitTerm == this.baseTerm);
                assert (this.commitIndex == this.baseIndex);
                break;
            }
            case EVENTUAL_COMMITTED: {
                assert (this.readOnly);
                assert (!this.rebasable);
                assert (this.configChange == null);
                assert (this.commitTerm == this.baseTerm);
                assert (this.commitIndex == this.baseIndex);
                assert (this.commitIndex <= raftCommitIndex);
                assert (this.committable);
                break;
            }
            case UNCOMMITTED: {
                assert (this.readOnly);
                assert (!this.rebasable);
                assert (this.configChange == null);
                assert (this.commitTerm == 0L);
                assert (this.commitIndex == 0L);
                assert (this.committable);
                assert (raftCommitIndex >= this.commitIndex);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (this.readOnly || this.consistency.equals((Object)Consistency.LINEARIZABLE));
        assert (!this.readOnly || this.configChange == null);
        switch (this.state) {
            case EXECUTING: {
                assert (this.snapshotRefs != null);
                assert (this.failure == null);
                break;
            }
            case COMMIT_READY: {
                assert (this.snapshotRefs == null);
                assert (this.failure == null);
                break;
            }
            case COMMIT_WAITING: {
                assert (this.commitTerm <= currentTerm);
                if (this.consistency != Consistency.UNCOMMITTED) {
                    assert (this.commitTerm >= this.baseTerm);
                    assert (this.commitIndex >= this.baseIndex);
                }
                assert (this.failure == null);
                break;
            }
            case COMPLETED: {
                assert (this.commitFuture.isDone());
                assert (this.commitTerm == 0L || this.commitTerm >= this.baseTerm);
                assert (this.commitIndex == 0L || this.commitIndex >= this.baseIndex);
                assert (this.commitTerm <= currentTerm);
                assert (this.failure == null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

