/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.mvcc.Reads;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.raft.CheckReadyTransactionService;
import org.jsimpledb.kv.raft.CheckWaitingTransactionService;
import org.jsimpledb.kv.raft.Consistency;
import org.jsimpledb.kv.raft.LogEntry;
import org.jsimpledb.kv.raft.MostRecentView;
import org.jsimpledb.kv.raft.NewLogEntry;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Service;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.TxState;
import org.jsimpledb.kv.raft.msg.AppendRequest;
import org.jsimpledb.kv.raft.msg.AppendResponse;
import org.jsimpledb.kv.raft.msg.CommitRequest;
import org.jsimpledb.kv.raft.msg.CommitResponse;
import org.jsimpledb.kv.raft.msg.GrantVote;
import org.jsimpledb.kv.raft.msg.InstallSnapshot;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.PingRequest;
import org.jsimpledb.kv.raft.msg.PingResponse;
import org.jsimpledb.kv.raft.msg.RequestVote;
import org.jsimpledb.util.LongEncoder;
import org.slf4j.Logger;

public abstract class Role {
    final Logger log;
    final RaftKVDatabase raft;
    final Service checkReadyTransactionsService = new Service(this, "check ready transactions"){

        @Override
        public void run() {
            Role.this.checkReadyTransactions();
        }
    };
    final Service checkWaitingTransactionsService = new Service(this, "check waiting transactions"){

        @Override
        public void run() {
            Role.this.checkWaitingTransactions();
        }
    };
    final Service applyCommittedLogEntriesService = new Service(this, "apply committed logs"){

        @Override
        public void run() {
            Role.this.applyCommittedLogEntries();
        }
    };
    final Service triggerKeyWatchesService = new Service(this, "trigger key watches"){

        @Override
        public void run() {
            Role.this.triggerKeyWatches();
        }
    };

    Role(RaftKVDatabase raft) {
        this.raft = raft;
        this.log = this.raft.log;
        assert (Thread.holdsLock(this.raft));
    }

    public RaftKVDatabase getKVDatabase() {
        return this.raft;
    }

    void setup() {
        assert (Thread.holdsLock(this.raft));
        this.raft.requestService(this.checkReadyTransactionsService);
        this.raft.requestService(this.checkWaitingTransactionsService);
        this.raft.requestService(this.applyCommittedLogEntriesService);
    }

    void shutdown() {
        assert (Thread.holdsLock(this.raft));
        for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
            if (tx.getState().equals((Object)TxState.COMPLETED) || tx.getCommitLeaderLeaseTimeout() == null) continue;
            assert (tx.hasCommitInfo());
            this.raft.fail(tx, (KVTransactionException)((Object)new RetryTransactionException((KVTransaction)tx, "leader was deposed during leader lease timeout wait")));
        }
        for (RaftKVTransaction tx : this.raft.openTransactions.values()) {
            this.cleanupForTransaction(tx);
        }
    }

    abstract void outputQueueEmpty(String var1);

    void checkReadyTransactions() {
        assert (Thread.holdsLock(this.raft));
        for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
            if (!TxState.COMMIT_READY.equals((Object)tx.getState())) continue;
            new CheckReadyTransactionService(this, tx).run();
        }
    }

    void checkWaitingTransactions() {
        assert (Thread.holdsLock(this.raft));
        for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
            if (!TxState.COMMIT_WAITING.equals((Object)tx.getState())) continue;
            new CheckWaitingTransactionService(this, tx).run();
        }
    }

    void applyCommittedLogEntries() {
        assert (Thread.holdsLock(this.raft));
        assert (this.checkRebasableAndCommittableUpToDate());
        int numEntriesToApply = 0;
        while (this.raft.lastAppliedIndex + (long)numEntriesToApply < this.raft.commitIndex && this.mayApplyLogEntry(this.raft.raftLog.get(numEntriesToApply))) {
            ++numEntriesToApply;
        }
        long maxAppliedIndex = this.raft.lastAppliedIndex + (long)numEntriesToApply;
        assert (maxAppliedIndex <= this.raft.commitIndex);
        while (this.raft.lastAppliedIndex < maxAppliedIndex) {
            LogEntry logEntry = this.raft.raftLog.get(0);
            assert (logEntry.getIndex() == this.raft.lastAppliedIndex + 1L);
            HashMap<String, String> logEntryConfig = new HashMap<String, String>(this.raft.lastAppliedConfig);
            logEntry.applyConfigChange(logEntryConfig);
            final Writes logWrites = logEntry.getWrites();
            final Writes myWrites = new Writes();
            myWrites.getPuts().put(RaftKVDatabase.LAST_APPLIED_TERM_KEY, LongEncoder.encode((long)logEntry.getTerm()));
            myWrites.getPuts().put(RaftKVDatabase.LAST_APPLIED_INDEX_KEY, LongEncoder.encode((long)logEntry.getIndex()));
            myWrites.getPuts().put(RaftKVDatabase.LAST_APPLIED_CONFIG_KEY, this.raft.encodeConfig(logEntryConfig));
            final byte[] stateMachinePrefix = this.raft.getStateMachinePrefix();
            Mutations mutations = new Mutations(){

                public Iterable<KeyRange> getRemoveRanges() {
                    return Iterables.transform((Iterable)logWrites.getRemoveRanges(), range -> range.prefixedBy(stateMachinePrefix));
                }

                public Iterable<Map.Entry<byte[], byte[]>> getPutPairs() {
                    return Iterables.concat((Iterable)Iterables.transform((Iterable)logWrites.getPutPairs(), entry -> new AbstractMap.SimpleEntry(Bytes.concat((byte[][])new byte[][]{stateMachinePrefix, (byte[])entry.getKey()}), entry.getValue())), (Iterable)myWrites.getPutPairs());
                }

                public Iterable<Map.Entry<byte[], Long>> getAdjustPairs() {
                    return Iterables.transform((Iterable)logWrites.getAdjustPairs(), entry -> new AbstractMap.SimpleEntry(Bytes.concat((byte[][])new byte[][]{stateMachinePrefix, (byte[])entry.getKey()}), entry.getValue()));
                }
            };
            if (this.log.isDebugEnabled()) {
                this.debug("applying committed log entry " + logEntry + " to key/value store");
            }
            try {
                this.raft.kv.mutate(mutations, !this.raft.disableSync && this.raft.lastAppliedIndex == maxAppliedIndex);
            }
            catch (Exception e2) {
                IOException e2;
                if (e2 instanceof RuntimeException && e2.getCause() instanceof IOException) {
                    e2 = (IOException)e2.getCause();
                }
                this.error("error applying log entry " + logEntry + " to key/value store", e2);
                break;
            }
            assert (logEntry.getIndex() == this.raft.lastAppliedIndex + 1L);
            this.raft.incrementLastAppliedIndex(logEntry.getTerm());
            logEntry.applyConfigChange(this.raft.lastAppliedConfig);
            assert (this.raft.currentConfig.equals(this.raft.buildCurrentConfig()));
            this.raft.raftLog.remove(0);
            this.raft.deleteFile(logEntry.getFile(), "applied log file");
        }
    }

    boolean checkRebasableAndCommittableUpToDate() {
        for (RaftKVTransaction tx : this.raft.openTransactions.values()) {
            this.checkRebasableAndCommittableUpToDate(tx);
        }
        return true;
    }

    boolean checkRebasableAndCommittableUpToDate(RaftKVTransaction tx) {
        assert (!tx.isRebasable() || tx.getBaseIndex() == this.raft.getLastLogIndex()) : "rebasable check failed for " + tx;
        if (!tx.isCommittable()) {
            try {
                assert (!this.checkCommittable(tx));
            }
            catch (KVTransactionException kVTransactionException) {
                // empty catch block
            }
        }
        return true;
    }

    final boolean mayApplyLogEntry(LogEntry logEntry) {
        assert (Thread.holdsLock(this.raft));
        long logEntryMemoryUsage = this.raft.getUnappliedLogMemoryUsage();
        if (logEntryMemoryUsage > this.raft.maxUnappliedLogMemory || this.raft.raftLog.size() > this.raft.maxUnappliedLogEntries) {
            if (this.log.isTraceEnabled()) {
                this.trace("allowing log entry " + logEntry + " to be applied because memory usage " + logEntryMemoryUsage + " > " + this.raft.maxUnappliedLogMemory + " and/or log length " + this.raft.raftLog.size() + " > " + this.raft.maxUnappliedLogEntries);
            }
            return true;
        }
        return this.roleMayApplyLogEntry(logEntry);
    }

    boolean roleMayApplyLogEntry(LogEntry logEntry) {
        return true;
    }

    void triggerKeyWatches() {
        assert (Thread.holdsLock(this.raft));
        assert (this.raft.commitIndex >= this.raft.lastAppliedIndex);
        assert (this.raft.commitIndex <= this.raft.lastAppliedIndex + (long)this.raft.raftLog.size());
        assert (this.raft.keyWatchIndex <= this.raft.commitIndex);
        if (this.raft.keyWatchTracker == null) {
            return;
        }
        if (this.raft.keyWatchIndex < this.raft.lastAppliedIndex) {
            this.raft.keyWatchTracker.triggerAll();
            this.raft.keyWatchIndex = this.raft.commitIndex;
        } else {
            while (this.raft.keyWatchIndex < this.raft.commitIndex) {
                this.raft.keyWatchTracker.trigger((Mutations)this.raft.getLogEntryAtIndex(++this.raft.keyWatchIndex).getWrites());
            }
        }
    }

    void handleLinearizableReadOnlyChange(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
        assert (tx.getState().equals((Object)TxState.EXECUTING));
        assert (tx.getConsistency().equals((Object)Consistency.LINEARIZABLE));
        assert (tx.isReadOnly());
        assert (!tx.hasCommitInfo());
        assert (tx.isRebasable());
        assert (!tx.isCommittable());
        assert (this.checkRebasableAndCommittableUpToDate(tx));
    }

    final void checkReadyTransaction(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
        assert (tx.getState().equals((Object)TxState.COMMIT_READY));
        if (tx.hasCommitInfo()) {
            this.advanceReadyTransaction(tx);
            return;
        }
        assert (!tx.isCommittable());
        assert (tx.getConsistency().equals((Object)Consistency.LINEARIZABLE));
        this.checkReadyTransactionNeedingCommitInfo(tx);
    }

    void checkReadyTransactionNeedingCommitInfo(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
        assert (tx.getState().equals((Object)TxState.COMMIT_READY));
        assert (tx.getConsistency().equals((Object)Consistency.LINEARIZABLE));
        assert (!tx.hasCommitInfo());
        assert (!tx.isCommittable());
        assert (this.checkRebasableAndCommittableUpToDate(tx));
    }

    final void advanceReadyTransactionWithCommitInfo(RaftKVTransaction tx, long commitTerm, long commitIndex, Timestamp commitLeaderLeaseTimeout) {
        assert (Thread.holdsLock(this.raft));
        assert (tx.getState().equals((Object)TxState.COMMIT_READY));
        assert (!tx.hasCommitInfo());
        tx.setCommitInfo(commitTerm, commitIndex, commitLeaderLeaseTimeout);
        this.advanceReadyTransaction(tx);
    }

    final void advanceReadyTransaction(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
        assert (tx.getState().equals((Object)TxState.COMMIT_READY));
        assert (tx.hasCommitInfo());
        if (this.log.isTraceEnabled()) {
            this.trace("advancing " + tx + " to " + (Object)((Object)TxState.COMMIT_WAITING));
        }
        tx.setState(TxState.COMMIT_WAITING);
        tx.setNoLongerRebasable();
        this.checkCommittable(tx);
        new CheckWaitingTransactionService(this, tx).run();
    }

    final void checkWaitingTransaction(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
        assert (tx.getConsistency().isGuaranteesUpToDateReads());
        if (!this.checkCommittable(tx)) {
            return;
        }
        Timestamp commitLeaderLeaseTimeout = tx.getCommitLeaderLeaseTimeout();
        if (commitLeaderLeaseTimeout != null && !this.isLeaderLeaseActiveAt(commitLeaderLeaseTimeout)) {
            if (this.log.isTraceEnabled()) {
                this.trace("committable " + tx + " must wait for leader lease timeout " + commitLeaderLeaseTimeout);
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.trace("commit successful for " + tx);
        }
        this.raft.succeed(tx);
    }

    void checkCommittables() {
        assert (Thread.holdsLock(this.raft));
        for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
            try {
                this.checkCommittable(tx);
            }
            catch (KVTransactionException e) {
                this.raft.fail(tx, e);
            }
            catch (Error | Exception e) {
                this.raft.error("error checking committable for transaction " + tx, e);
                this.raft.fail(tx, new KVTransactionException((KVTransaction)tx, e));
            }
        }
    }

    boolean checkCommittable(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
        if (tx.isCommittable()) {
            return true;
        }
        long commitIndex = tx.getCommitIndex();
        long commitTerm = tx.getCommitTerm();
        if (commitIndex == 0L) {
            return false;
        }
        long lastIndex = this.raft.getLastLogIndex();
        if (commitIndex > lastIndex) {
            return false;
        }
        long commitIndexActualTerm = this.raft.getLogTermAtIndexIfKnown(commitIndex);
        if (commitIndexActualTerm == 0L) {
            throw new RetryTransactionException((KVTransaction)tx, "commit index " + commitIndex + " < last applied log index " + this.raft.lastAppliedIndex);
        }
        if (commitTerm != commitIndexActualTerm) {
            throw new RetryTransactionException((KVTransaction)tx, "leader was deposed during commit and transaction's commit log entry " + commitIndex + "t" + commitTerm + " overwritten by " + commitIndex + "t" + commitIndexActualTerm);
        }
        if (commitIndex > this.raft.commitIndex) {
            return false;
        }
        if (tx.isRebasable() && tx.getBaseIndex() < commitIndex) {
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.trace(tx + " is now committable: " + this.raft.commitIndex + " >= " + commitIndex + "t" + commitTerm);
        }
        tx.setCommittable();
        if (tx.isRebasable()) {
            tx.setNoLongerRebasable();
        }
        return true;
    }

    void rebaseTransactions() {
        assert (Thread.holdsLock(this.raft));
        for (RaftKVTransaction tx : new ArrayList(this.raft.openTransactions.values())) {
            if (!tx.isRebasable()) continue;
            try {
                this.rebaseTransaction(tx);
            }
            catch (KVTransactionException e) {
                this.raft.fail(tx, e);
            }
            catch (Error | Exception e) {
                this.raft.error("error rebasing transaction " + tx, e);
                this.raft.fail(tx, new KVTransactionException((KVTransaction)tx, e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebaseTransaction(RaftKVTransaction tx) {
        long lastIndex;
        assert (Thread.holdsLock(this.raft));
        assert (tx.isRebasable());
        assert (tx.getFailure() == null);
        assert (tx.getBaseIndex() >= this.raft.lastAppliedIndex);
        assert (!tx.hasCommitInfo() || tx.getCommitIndex() > tx.getBaseIndex());
        assert (!tx.hasCommitInfo() || !tx.addsLogEntry());
        long baseIndex = tx.getBaseIndex();
        if (baseIndex == (lastIndex = this.raft.getLastLogIndex())) {
            return;
        }
        MutableView mutableView = tx.view;
        synchronized (mutableView) {
            while (baseIndex < lastIndex) {
                LogEntry logEntry = this.raft.getLogEntryAtIndex(++baseIndex);
                if (tx.view.getReads().isConflict((Mutations)logEntry.getWrites())) {
                    if (this.log.isDebugEnabled()) {
                        this.debug("cannot rebase " + tx + " past " + logEntry + " due to conflicts, failing");
                    }
                    if (this.raft.dumpConflicts) {
                        this.dumpConflicts(tx.view.getReads(), logEntry, "local txId=" + tx.txId);
                    }
                    throw new RetryTransactionException((KVTransaction)tx, "writes of committed transaction at index " + baseIndex + " conflict with transaction reads from transaction base index " + tx.getBaseIndex());
                }
                if (baseIndex != tx.getCommitIndex()) continue;
                tx.setNoLongerRebasable();
                break;
            }
            long baseTerm = this.raft.getLogTermAtIndex(baseIndex);
            if (this.log.isDebugEnabled()) {
                this.debug("rebased " + tx + " from " + tx.getBaseIndex() + "t" + tx.getBaseTerm() + " -> " + baseIndex + "t" + baseTerm);
            }
            switch (tx.getState()) {
                case EXECUTING: {
                    assert (!tx.hasCommitInfo() || tx.isReadOnly());
                    MostRecentView view = new MostRecentView(this.raft, baseIndex);
                    assert (view.getTerm() == baseTerm);
                    assert (view.getIndex() == baseIndex);
                    tx.rebase(baseTerm, baseIndex, view.getView().getKVStore(), view.getSnapshot());
                    break;
                }
                case COMMIT_READY: {
                    tx.rebase(baseTerm, baseIndex);
                    break;
                }
                case COMMIT_WAITING: {
                    tx.rebase(baseTerm, baseIndex);
                    this.checkWaitingTransaction(tx);
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
        }
        if (baseIndex == tx.getCommitIndex()) {
            this.checkCommittable(tx);
        }
    }

    void dumpConflicts(Reads reads, LogEntry logEntry, String description) {
        StringBuilder buf = new StringBuilder();
        buf.append(description + " failing due to conflicts with " + logEntry + ":");
        for (String conflict : reads.getConflicts((Mutations)logEntry.getWrites())) {
            buf.append("\n  ").append(conflict);
        }
        this.info(buf.toString());
    }

    Timestamp getLeaderLeaseTimeout() {
        return null;
    }

    protected boolean isLeaderLeaseActiveNow() {
        return this.isLeaderLeaseActiveAt(new Timestamp());
    }

    protected boolean isLeaderLeaseActiveAt(Timestamp time) {
        Timestamp leaderLeaseTimeout = this.getLeaderLeaseTimeout();
        return leaderLeaseTimeout != null && leaderLeaseTimeout.compareTo(time) > 0;
    }

    void cleanupForTransaction(RaftKVTransaction tx) {
        assert (Thread.holdsLock(this.raft));
    }

    abstract void caseAppendRequest(AppendRequest var1, NewLogEntry var2);

    abstract void caseAppendResponse(AppendResponse var1);

    abstract void caseCommitRequest(CommitRequest var1, NewLogEntry var2);

    abstract void caseCommitResponse(CommitResponse var1);

    abstract void caseGrantVote(GrantVote var1);

    abstract void caseInstallSnapshot(InstallSnapshot var1);

    abstract void caseRequestVote(RequestVote var1);

    void casePingRequest(PingRequest msg) {
        assert (Thread.holdsLock(this.raft));
        int responseClusterId = this.raft.clusterId != 0 ? this.raft.clusterId : msg.getClusterId();
        this.raft.sendMessage(new PingResponse(responseClusterId, this.raft.identity, msg.getSenderId(), this.raft.currentTerm, msg.getTimestamp()));
    }

    void casePingResponse(PingResponse msg) {
        assert (Thread.holdsLock(this.raft));
    }

    boolean mayAdvanceCurrentTerm(Message msg) {
        return true;
    }

    void failUnexpectedMessage(Message msg) {
        this.warn("rec'd unexpected message " + msg + " while in role " + this + "; ignoring");
    }

    abstract boolean checkState();

    void checkTransaction(RaftKVTransaction tx) {
        this.checkRebasableAndCommittableUpToDate(tx);
    }

    void trace(String msg, Throwable t) {
        this.raft.trace(msg, t);
    }

    void trace(String msg) {
        this.raft.trace(msg);
    }

    void debug(String msg, Throwable t) {
        this.raft.debug(msg, t);
    }

    void debug(String msg) {
        this.raft.debug(msg);
    }

    void info(String msg, Throwable t) {
        this.raft.info(msg, t);
    }

    void info(String msg) {
        this.raft.info(msg);
    }

    void warn(String msg, Throwable t) {
        this.raft.warn(msg, t);
    }

    void warn(String msg) {
        this.raft.warn(msg);
    }

    void error(String msg, Throwable t) {
        this.raft.error(msg, t);
    }

    void error(String msg) {
        this.raft.error(msg);
    }

    public abstract String toString();

    String toStringPrefix() {
        assert (Thread.holdsLock(this.raft));
        return this.getClass().getSimpleName() + "[term=" + this.raft.currentTerm + ",applied=" + this.raft.lastAppliedIndex + "t" + this.raft.lastAppliedTerm + ",commit=" + this.raft.commitIndex + ",log=" + this.raft.raftLog + "]";
    }
}

