/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.dellroad.stuff.io.ByteBufferOutputStream;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.Util;
import org.jsimpledb.kv.util.KeyListEncoder;
import org.jsimpledb.util.CloseableIterator;

class SnapshotTransmit
implements Closeable {
    private static final int MAX_CHUNK_SIZE = 10250;
    private final Timestamp createTime = new Timestamp();
    private final long snapshotTerm;
    private final long snapshotIndex;
    private final Map<String, String> snapshotConfig;
    private CloseableKVStore snapshot;
    private CloseableIterator<KVPair> iterator;
    private long pairIndex;
    private KVPair nextPair;
    private byte[] previousKey;
    private boolean anyChunksSent;

    SnapshotTransmit(long snapshotTerm, long snapshotIndex, Map<String, String> snapshotConfig, CloseableKVStore snapshot, KVStore view) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0);
        Preconditions.checkArgument((snapshotTerm > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((snapshotIndex > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((snapshotConfig != null ? 1 : 0) != 0);
        this.snapshotTerm = snapshotTerm;
        this.snapshotIndex = snapshotIndex;
        this.snapshotConfig = snapshotConfig;
        this.snapshot = snapshot;
        this.iterator = view.getRange(null, null);
        this.advance();
    }

    public int getAge() {
        return -this.createTime.offsetFromNow();
    }

    public long getSnapshotTerm() {
        return this.snapshotTerm;
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    public Map<String, String> getSnapshotConfig() {
        return this.snapshotConfig;
    }

    public long getPairIndex() {
        return this.pairIndex;
    }

    public boolean hasMoreChunks() {
        return this.nextPair != null;
    }

    public ByteBuffer getNextChunk() {
        if (this.nextPair == null) {
            if (!this.anyChunksSent) {
                this.anyChunksSent = true;
                return ByteBuffer.allocate(0);
            }
            return null;
        }
        ByteBuffer buf = Util.allocateByteBuffer(Math.max(this.nextPairLength(), 10250));
        ByteBufferOutputStream output = new ByteBufferOutputStream(buf);
        do {
            byte[] key = this.nextPair.getKey();
            byte[] value = this.nextPair.getValue();
            try {
                KeyListEncoder.write((OutputStream)output, (byte[])key, (byte[])this.previousKey);
                KeyListEncoder.write((OutputStream)output, (byte[])value, null);
            }
            catch (IOException e) {
                throw new RuntimeException("unexpected exception");
            }
            this.previousKey = key;
            ++this.pairIndex;
        } while (this.advance() && buf.remaining() >= this.nextPairLength());
        this.anyChunksSent = true;
        return (ByteBuffer)buf.flip();
    }

    private boolean advance() {
        if (!this.iterator.hasNext()) {
            this.nextPair = null;
            return false;
        }
        this.nextPair = (KVPair)this.iterator.next();
        return true;
    }

    private int nextPairLength() {
        return KeyListEncoder.writeLength((byte[])this.nextPair.getKey(), (byte[])this.previousKey) + KeyListEncoder.writeLength((byte[])this.nextPair.getValue(), null);
    }

    @Override
    public void close() {
        this.snapshot.close();
        this.iterator.close();
        this.snapshot = null;
        this.iterator = null;
        this.nextPair = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[snapshotTerm=" + this.snapshotTerm + ",snapshotIndex=" + this.snapshotIndex + ",snapshotConfig=" + this.snapshotConfig + ",pairIndex=" + this.pairIndex + (this.snapshot == null ? ",closed" : "") + "]";
    }
}

