/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft;

import com.google.common.base.Preconditions;
import java.util.Comparator;

public class Timestamp
implements Comparable<Timestamp> {
    public static final Comparator<Timestamp> NULL_FIRST_SORT = Comparator.nullsFirst(Comparator.naturalOrder());
    private static final int TIME_BASE = Timestamp.milliTime();
    private final int millis;

    public Timestamp() {
        this(Timestamp.now());
    }

    public Timestamp(int millis) {
        this.millis = millis;
    }

    public int getMillis() {
        return this.millis;
    }

    public int offsetFromNow() {
        return this.millis - Timestamp.now();
    }

    public int offsetFrom(Timestamp base) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"null base");
        return this.millis - base.millis;
    }

    public Timestamp offset(int offset) {
        return new Timestamp(this.millis + offset);
    }

    public boolean hasOccurred() {
        return Timestamp.now() - this.millis >= 0;
    }

    public boolean isRolloverDanger() {
        return this.offsetFromNow() <= -2040109440;
    }

    private static int now() {
        return Timestamp.milliTime() - TIME_BASE;
    }

    private static int milliTime() {
        return (int)(System.nanoTime() / 1000000L);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Timestamp that = (Timestamp)obj;
        return this.millis == that.millis;
    }

    public int hashCode() {
        return this.millis;
    }

    public String toString() {
        long value = (long)this.millis & 0xFFFFFFFFL;
        return String.format("%05d.%03d", value / 1000L, value % 1000L);
    }

    @Override
    public int compareTo(Timestamp that) {
        Preconditions.checkArgument((this.millis != (that.millis ^ Integer.MIN_VALUE) ? 1 : 0) != 0);
        int diff = this.millis - that.millis;
        return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
    }
}

