/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.cmd;

import java.util.EnumSet;
import java.util.Map;
import org.jsimpledb.SessionMode;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.cli.cmd.AbstractCommand;
import org.jsimpledb.kv.raft.fallback.FallbackKVDatabase;
import org.jsimpledb.util.ParseContext;

public class RaftFallbackForceStandaloneCommand
extends AbstractCommand {
    public RaftFallbackForceStandaloneCommand() {
        super("raft-fallback-force-standalone on:boolean");
    }

    public String getHelpSummary() {
        return "Forces the Raft fallback database into standalone mode";
    }

    public EnumSet<SessionMode> getSessionModes() {
        return EnumSet.allOf(SessionMode.class);
    }

    public CliSession.Action getAction(CliSession session0, ParseContext ctx, boolean complete, Map<String, Object> params) {
        boolean on = (Boolean)params.get("on");
        return session -> {
            if (!(session.getKVDatabase() instanceof FallbackKVDatabase)) {
                throw new Exception("key/value store is not Raft fallback");
            }
            FallbackKVDatabase fallbackKV = (FallbackKVDatabase)session.getKVDatabase();
            fallbackKV.setMaximumTargetIndex(on ? -1 : Integer.MAX_VALUE);
        };
    }
}

