/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.cmd;

import java.util.Map;
import org.jsimpledb.cli.CliSession;
import org.jsimpledb.kv.raft.NonLeaderRole;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.cmd.AbstractRaftCommand;
import org.jsimpledb.util.ParseContext;

public class RaftStartElectionCommand
extends AbstractRaftCommand {
    public RaftStartElectionCommand() {
        super("raft-start-election");
    }

    public String getHelpSummary() {
        return "Forces a immediate Raft election";
    }

    public String getHelpDetail() {
        return "This command forces an immediate election timeout on the local node, which must be a follower (or a candidate). If follower probing is disabled, this node will then (be very likely to) be elected for a new term, deposing the current leader.";
    }

    public CliSession.Action getAction(CliSession session, ParseContext ctx, boolean complete, Map<String, Object> params) {
        return new AbstractRaftCommand.RaftAction(){

            @Override
            protected void run(CliSession session, RaftKVDatabase db) throws Exception {
                NonLeaderRole role;
                try {
                    role = (NonLeaderRole)db.getCurrentRole();
                }
                catch (ClassCastException e) {
                    throw new Exception("current role is not follower or candidate; try `raft-status' for more info");
                }
                session.getWriter().println("Triggering early Raft election");
                role.startElection();
            }
        };
    }
}

