/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.fallback;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import org.dellroad.stuff.io.AtomicUpdateFileOutputStream;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.raft.Consistency;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.fallback.FallbackKVTransaction;
import org.jsimpledb.kv.raft.fallback.FallbackTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackKVDatabase
implements KVDatabase {
    private static final int MIGRATION_CHECK_INTERVAL = 1000;
    private static final int STATE_FILE_COOKIE = -490923370;
    private static final int CURRENT_FORMAT_VERSION = 1;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @GuardedBy(value="this")
    private final ArrayList<FallbackTarget> targets = new ArrayList();
    @GuardedBy(value="this")
    private File stateFile;
    @GuardedBy(value="this")
    private KVDatabase standaloneKV;
    @GuardedBy(value="this")
    private int initialTargetIndex = Integer.MAX_VALUE;
    @GuardedBy(value="this")
    private int maximumTargetIndex = Integer.MAX_VALUE;
    @GuardedBy(value="this")
    private boolean migrating;
    @GuardedBy(value="this")
    private int migrationCount;
    @GuardedBy(value="this")
    private ScheduledExecutorService executor;
    @GuardedBy(value="this")
    private ScheduledFuture<?> migrationCheckFuture;
    @GuardedBy(value="this")
    private int startCount;
    @GuardedBy(value="this")
    private boolean started;
    @GuardedBy(value="this")
    private int currentTargetIndex;
    @GuardedBy(value="this")
    private Date lastStandaloneActiveTime;
    @GuardedBy(value="this")
    private final HashSet<FallbackFuture> futures = new HashSet();

    public synchronized File getStateFile() {
        return this.stateFile;
    }

    public synchronized void setStateFile(File stateFile) {
        Preconditions.checkArgument((stateFile != null ? 1 : 0) != 0, (Object)"null stateFile");
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.stateFile = stateFile;
    }

    public synchronized KVDatabase getStandaloneTarget() {
        return this.standaloneKV;
    }

    public synchronized void setStandaloneTarget(KVDatabase standaloneKV) {
        Preconditions.checkArgument((standaloneKV != null ? 1 : 0) != 0, (Object)"null standaloneKV");
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.standaloneKV = standaloneKV;
    }

    public synchronized FallbackTarget getFallbackTarget() {
        return !this.targets.isEmpty() ? this.targets.get(this.targets.size() - 1) : null;
    }

    public synchronized List<FallbackTarget> getFallbackTargets() {
        ArrayList<FallbackTarget> result = new ArrayList<FallbackTarget>(this.targets);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, result.get(i).clone());
        }
        return result;
    }

    public synchronized void setFallbackTarget(FallbackTarget target) {
        this.setFallbackTargets(Collections.singletonList(target));
    }

    public synchronized void setFallbackTargets(List<? extends FallbackTarget> targets) {
        Preconditions.checkArgument((targets != null ? 1 : 0) != 0, (Object)"null targets");
        Preconditions.checkArgument((!targets.isEmpty() ? 1 : 0) != 0, (Object)"empty targets");
        Preconditions.checkState((!this.started ? 1 : 0) != 0, (Object)"already started");
        this.targets.clear();
        for (FallbackTarget fallbackTarget : targets) {
            Preconditions.checkArgument((fallbackTarget != null ? 1 : 0) != 0, (Object)"null target");
            Preconditions.checkArgument((fallbackTarget.getRaftKVDatabase() != null ? 1 : 0) != 0, (Object)"target with no database configured");
            this.targets.add(fallbackTarget.clone());
        }
    }

    public synchronized int getInitialTargetIndex() {
        return this.initialTargetIndex;
    }

    public synchronized void setInitialTargetIndex(int initialTargetIndex) {
        this.initialTargetIndex = initialTargetIndex;
    }

    public synchronized int getCurrentTargetIndex() {
        return this.currentTargetIndex;
    }

    public synchronized void setMaximumTargetIndex(int maximumTargetIndex) {
        if (this.maximumTargetIndex != (maximumTargetIndex = Math.max(-1, maximumTargetIndex))) {
            this.log.info("adjusting maximum target index to " + maximumTargetIndex);
            this.maximumTargetIndex = maximumTargetIndex;
            this.executor.submit(new MigrationCheckTask());
        }
    }

    public synchronized int getMaximumTargetIndex() {
        return this.maximumTargetIndex;
    }

    public synchronized Date getLastStandaloneActiveTime() {
        return (Date)this.lastStandaloneActiveTime.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public synchronized void start() {
        if (this.started) {
            return;
        }
        ++this.startCount;
        Preconditions.checkState((this.stateFile != null ? 1 : 0) != 0, (Object)"no state file configured");
        Preconditions.checkState((this.standaloneKV != null ? 1 : 0) != 0, (Object)"no standaloneKV configured");
        Preconditions.checkState((this.targets != null ? 1 : 0) != 0, (Object)"no targets configured");
        try {
            if (this.log.isDebugEnabled()) {
                this.log.info("starting up " + this);
            }
            this.executor = Executors.newScheduledThreadPool(this.targets.size(), new ExecutorThreadFactory());
            this.standaloneKV.start();
            for (FallbackTarget target : this.targets) {
                target.getRaftKVDatabase().start();
            }
            this.migrating = false;
            this.lastStandaloneActiveTime = null;
            this.currentTargetIndex = Math.max(-1, Math.min(this.targets.size() - 1, this.initialTargetIndex));
            for (FallbackTarget target : this.targets) {
                block15: {
                    this.log.info("performing initial availability check for " + target);
                    target.available = false;
                    try {
                        target.available = target.checkAvailability();
                    }
                    catch (Exception e) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("checkAvailable() for " + target + " threw exception", (Throwable)e);
                        }
                        if (!this.log.isDebugEnabled()) break block15;
                        this.log.debug("checkAvailable() for " + target + " threw exception: " + e);
                    }
                }
                this.log.info(target + " is initially " + (target.available ? "" : "un") + "available");
                target.lastChangeTimestamp = null;
            }
            for (FallbackTarget target : this.targets) {
                target.future = this.executor.scheduleWithFixedDelay(new AvailabilityCheckTask(target), target.getCheckInterval(), target.getCheckInterval(), TimeUnit.MILLISECONDS);
            }
            if (this.stateFile.exists()) {
                try {
                    this.readStateFile();
                }
                catch (IOException e) {
                    throw new RuntimeException("error reading persistent state file " + this.stateFile, e);
                }
            }
            this.migrationCheckFuture = this.executor.scheduleWithFixedDelay(new MigrationCheckTask(), 0L, 1000L, TimeUnit.MILLISECONDS);
            this.started = true;
        }
        finally {
            if (!this.started) {
                this.cleanup();
            }
        }
    }

    @PreDestroy
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.cleanup();
    }

    protected Thread createExecutorThread(Runnable action, int uniqueId) {
        Thread thread = new Thread(action);
        thread.setName("Executor#" + uniqueId + " for " + FallbackKVDatabase.class.getSimpleName());
        return thread;
    }

    private void cleanup() {
        assert (Thread.holdsLock(this));
        if (this.log.isDebugEnabled()) {
            this.log.info("shutting down " + this);
        }
        if (this.migrating) {
            if (this.log.isDebugEnabled()) {
                this.log.info("waiting for migration to finish to shut down " + this);
            }
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.log.warn("interrupted during " + this + " shutdown while waiting for migration to finish (ignoring)", (Throwable)e);
                }
                if (this.started) continue;
                return;
            } while (this.migrating);
            if (this.log.isDebugEnabled()) {
                this.log.info("migration finished, continuing with shut down of " + this);
            }
        }
        for (FallbackTarget target2 : this.targets) {
            target2.available = false;
            target2.lastChangeTimestamp = null;
        }
        this.targets.stream().filter(target -> target.future != null).forEach(target -> {
            target.future.cancel(true);
            target.future = null;
        });
        if (this.migrationCheckFuture != null) {
            this.migrationCheckFuture.cancel(true);
            this.migrationCheckFuture = null;
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
        for (FallbackTarget target2 : this.targets) {
            try {
                target2.getRaftKVDatabase().stop();
            }
            catch (Exception e) {
                this.log.warn("error stopping database target " + target2 + " (ignoring)", (Throwable)e);
            }
        }
        try {
            this.standaloneKV.stop();
        }
        catch (Exception e) {
            this.log.warn("error stopping fallback database " + this.standaloneKV + " (ignoring)", (Throwable)e);
        }
        this.started = false;
    }

    public FallbackKVTransaction createTransaction() {
        return this.createTransaction((Map)null);
    }

    public synchronized FallbackKVTransaction createTransaction(Map<String, ?> options) {
        Preconditions.checkState((boolean)this.started, (Object)"not started");
        KVDatabase currentKV = this.currentTargetIndex == -1 ? this.standaloneKV : this.targets.get(this.currentTargetIndex).getRaftKVDatabase();
        KVTransaction tx = currentKV.createTransaction(options);
        return new FallbackKVTransaction(this, tx, this.migrationCount);
    }

    protected boolean isMigrationAllowed(int currTargetIndex, int nextTargetIndex) {
        return true;
    }

    protected void migrationCompleted(int prevTargetIndex, int currTargetIndex) {
    }

    public synchronized String toString() {
        return this.getClass().getSimpleName() + "[standalone=" + this.standaloneKV + ",targets=" + this.targets + "]";
    }

    synchronized boolean checkNoMigration(int migrationCount) {
        return !this.migrating && migrationCount == this.migrationCount;
    }

    synchronized boolean registerFallbackFutures(List<FallbackFuture> futureList, int migrationCount) {
        if (!this.checkNoMigration(migrationCount)) {
            return false;
        }
        this.futures.addAll(futureList);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCheck(FallbackTarget target, int startCount) {
        boolean available;
        block15: {
            boolean wasAvailable;
            assert (!Thread.holdsLock(this));
            FallbackKVDatabase fallbackKVDatabase = this;
            synchronized (fallbackKVDatabase) {
                if (!this.started || startCount != this.startCount) {
                    return;
                }
                wasAvailable = target.available;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("performing availability check for " + target + " (currently " + (wasAvailable ? "" : "un") + "available)");
            }
            available = false;
            try {
                available = target.checkAvailability();
            }
            catch (Exception e) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("checkAvailable() for " + target + " threw exception", (Throwable)e);
                }
                if (!wasAvailable || !this.log.isDebugEnabled()) break block15;
                this.log.debug("checkAvailable() for " + target + " threw exception: " + e);
            }
        }
        FallbackKVDatabase fallbackKVDatabase = this;
        synchronized (fallbackKVDatabase) {
            if (!this.started || startCount != this.startCount) {
                return;
            }
            if (target.lastChangeTimestamp != null && target.lastChangeTimestamp.isRolloverDanger()) {
                target.lastChangeTimestamp = null;
            }
            if (available == target.available) {
                return;
            }
            target.available = available;
            target.lastChangeTimestamp = new Timestamp();
            this.executor.submit(new MigrationCheckTask());
        }
        this.log.info(target + " has become " + (available ? "" : "un") + "available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkMigration(int startCount) {
        var6_2 = this;
        // MONITORENTER : this
        if (!this.started || startCount != this.startCount) {
            // MONITOREXIT : var6_2
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("performing migration check");
        }
        if (this.migrating) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("migration check canceled: migration in progress");
            }
            // MONITOREXIT : var6_2
            return;
        }
        for (bestIndex = Math.max(-1, Math.min(this.maximumTargetIndex, this.targets.size() - 1)); bestIndex >= 0; --bestIndex) {
            target = this.targets.get(bestIndex);
            previousAvailable = bestIndex >= this.currentTargetIndex;
            currentAvailable = target.available;
            v0 = timeSinceChange = target.lastChangeTimestamp != null ? -target.lastChangeTimestamp.offsetFromNow() : 0x7FFFFFFF;
            if (currentAvailable) {
                hysteresisAvailable = previousAvailable != false || timeSinceChange >= target.getMinAvailableTime();
            } else {
                v1 = hysteresisAvailable = previousAvailable != false && timeSinceChange < target.getMinUnavailableTime();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(target + " availability: previous=" + previousAvailable + ", current=" + currentAvailable + ", hysteresis=" + hysteresisAvailable);
            }
            if (hysteresisAvailable) break;
        }
        if ((currIndex = this.currentTargetIndex) == bestIndex) {
            // MONITOREXIT : var6_2
            return;
        }
        currTarget = currIndex != -1 ? this.targets.get(currIndex) : null;
        v2 = bestTarget = bestIndex != -1 ? this.targets.get(bestIndex) : null;
        if (!this.isMigrationAllowed(currIndex, bestIndex)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("migration canceled: denied by " + this.getClass().getSimpleName() + ".isMigrationAllowed()");
            }
            // MONITOREXIT : var6_2
            return;
        }
        this.migrating = true;
        // MONITOREXIT : var6_2
        try {
            desc = "migration from " + (currIndex != -1 ? "fallback target #" + currIndex : "standalone database") + " to " + (bestIndex != -1 ? "fallback target #" + bestIndex : "standalone database");
            try {
                hysteresisAvailable = this;
                // MONITORENTER : this
                currKV = currTarget != null ? currTarget.getRaftKVDatabase() : this.standaloneKV;
                bestKV = bestTarget != null ? bestTarget.getRaftKVDatabase() : this.standaloneKV;
                lastActiveTime = bestTarget != null ? bestTarget.lastActiveTime : this.lastStandaloneActiveTime;
                // MONITOREXIT : hysteresisAvailable
                mergeStrategy = bestIndex < currIndex ? currTarget.getUnavailableMergeStrategy() : bestTarget.getRejoinMergeStrategy();
                this.log.info("starting fallback " + desc + " using " + mergeStrategy);
                if (currKV instanceof RaftKVDatabase) {
                    src = currKV.createTransaction(Consistency.EVENTUAL_COMMITTED);
                    ((RaftKVTransaction)src).setReadOnly(true);
                } else {
                    src = currKV.createTransaction();
                }
                try {
                    dst = bestKV.createTransaction();
                    try {
                        currentTime = new Date();
                        mergeStrategy.mergeAndCommit(src, dst, lastActiveTime);
                        this.log.info(desc + " succeeded");
                        var15_25 = this;
                        // MONITORENTER : this
                        if (currTarget != null) {
                            currTarget.lastActiveTime = currentTime;
                        } else {
                            this.lastStandaloneActiveTime = currentTime;
                        }
                        this.currentTargetIndex = bestIndex;
                        ++this.migrationCount;
                        // MONITOREXIT : var15_25
                        this.migrationCompleted(currIndex, bestIndex);
                    }
                    finally {
                        dst.rollback();
                    }
                }
                finally {
                    src.rollback();
                }
            }
            catch (RetryTransactionException e) {
                this.log.info(desc + " failed (will try again later): " + (Object)e);
            }
            catch (Throwable t) {
                this.log.error(desc + " failed", t);
            }
            var7_4 = this;
        }
        catch (Throwable var20_28) {
            var21_29 = this;
            // MONITORENTER : this
            this.migrating = false;
            this.notifyAll();
            oldFutures = this.futures.toArray(new FallbackFuture[this.futures.size()]);
            this.futures.clear();
            // MONITOREXIT : var21_29
            throw var20_28;
        }
        this.migrating = false;
        this.notifyAll();
        oldFutures = this.futures.toArray(new FallbackFuture[this.futures.size()]);
        this.futures.clear();
        // MONITOREXIT : var7_4
        var7_4 = this;
        // MONITORENTER : this
        ** try [egrp 10[TRYBLOCK] [22 : 1068->1075)] { 
lbl-1000:
        // 1 sources

        {
            this.writeStateFile();
        }
lbl105:
        // 1 sources

        catch (IOException e) {
            this.log.error("error writing state to state file " + this.stateFile, (Throwable)e);
        }
        // MONITOREXIT : var7_4
        var7_4 = oldFutures;
        var8_10 = var7_4.length;
        var9_11 = 0;
        while (var9_11 < var8_10) {
            future = var7_4[var9_11];
            future.set(null);
            ++var9_11;
        }
    }

    private void readStateFile() throws IOException {
        long[] lastActiveTimes;
        long standaloneActiveTime;
        int targetIndex;
        assert (Thread.holdsLock(this));
        try (DataInputStream input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.stateFile)));){
            int cookie = input.readInt();
            if (cookie != -490923370) {
                throw new IOException("invalid state file " + this.stateFile + " (incorrect header)");
            }
            int formatVersion = input.readInt();
            switch (formatVersion) {
                case 1: {
                    break;
                }
                default: {
                    throw new IOException("invalid state file " + this.stateFile + " format version (expecting " + 1 + ", found " + formatVersion + ")");
                }
            }
            int numTargets = input.readInt();
            if (numTargets != this.targets.size()) {
                this.log.warn("state file " + this.stateFile + " lists " + numTargets + " != " + this.targets.size() + ", assuming configuration change and ignoring file");
                return;
            }
            targetIndex = input.readInt();
            if (targetIndex < -1 || targetIndex >= this.targets.size()) {
                throw new IOException("invalid state file " + this.stateFile + " target index " + targetIndex);
            }
            standaloneActiveTime = input.readLong();
            lastActiveTimes = new long[numTargets];
            for (int i = 0; i < numTargets; ++i) {
                lastActiveTimes[i] = input.readLong();
            }
        }
        this.currentTargetIndex = targetIndex;
        for (int i = 0; i < this.targets.size(); ++i) {
            FallbackTarget target = this.targets.get(i);
            target.lastActiveTime = lastActiveTimes[i] != 0L ? new Date(lastActiveTimes[i]) : null;
        }
        this.lastStandaloneActiveTime = standaloneActiveTime != 0L ? new Date(standaloneActiveTime) : null;
    }

    private void writeStateFile() throws IOException {
        assert (Thread.holdsLock(this));
        Object fileOutput = !this.isWindows() ? new AtomicUpdateFileOutputStream(this.stateFile) : new FileOutputStream(this.stateFile);
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream((OutputStream)fileOutput));){
            output.writeInt(-490923370);
            output.writeInt(1);
            output.writeInt(this.targets.size());
            output.writeInt(this.currentTargetIndex);
            output.writeLong(this.lastStandaloneActiveTime != null ? this.lastStandaloneActiveTime.getTime() : 0L);
            for (FallbackTarget target : this.targets) {
                output.writeLong(target.lastActiveTime != null ? target.lastActiveTime.getTime() : 0L);
            }
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).contains("win");
    }

    private class MigrationCheckTask
    implements Runnable {
        private final int startCount;

        MigrationCheckTask() {
            assert (Thread.holdsLock(FallbackKVDatabase.this));
            this.startCount = FallbackKVDatabase.this.startCount;
        }

        @Override
        public void run() {
            try {
                FallbackKVDatabase.this.checkMigration(this.startCount);
            }
            catch (Throwable t) {
                FallbackKVDatabase.this.log.error("exception from migration check", t);
            }
        }
    }

    private class AvailabilityCheckTask
    implements Runnable {
        private final FallbackTarget target;
        private final int startCount;

        AvailabilityCheckTask(FallbackTarget target) {
            assert (Thread.holdsLock(FallbackKVDatabase.this));
            this.target = target;
            this.startCount = FallbackKVDatabase.this.startCount;
        }

        @Override
        public void run() {
            try {
                FallbackKVDatabase.this.performCheck(this.target, this.startCount);
            }
            catch (Throwable t) {
                FallbackKVDatabase.this.log.error("exception from " + this.target + " availability check", t);
            }
        }
    }

    private class ExecutorThreadFactory
    implements ThreadFactory {
        private final AtomicInteger id = new AtomicInteger();

        private ExecutorThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable action) {
            return FallbackKVDatabase.this.createExecutorThread(action, this.id.incrementAndGet());
        }
    }

    class FallbackFuture
    extends AbstractFuture<Void> {
        FallbackFuture(ListenableFuture<Void> innerFuture) {
            Futures.addCallback(innerFuture, (FutureCallback)new FutureCallback<Void>(){

                public void onFailure(Throwable t) {
                    FallbackFuture.this.notifyAsync(t);
                }

                public void onSuccess(Void value) {
                    FallbackFuture.this.notifyAsync(null);
                }
            });
        }

        protected boolean set(Void value) {
            this.forget();
            try {
                return super.set((Object)value);
            }
            catch (Throwable t2) {
                FallbackKVDatabase.this.log.error("exception from key watch listener", t2);
                return true;
            }
        }

        protected boolean setException(Throwable t) {
            this.forget();
            try {
                return super.setException(t);
            }
            catch (Throwable t2) {
                FallbackKVDatabase.this.log.error("exception from key watch listener", t2);
                return true;
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.forget();
            return super.cancel(mayInterruptIfRunning);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAsync(Throwable t) {
            ScheduledExecutorService notifyExecutor;
            this.forget();
            FallbackKVDatabase fallbackKVDatabase = FallbackKVDatabase.this;
            synchronized (fallbackKVDatabase) {
                notifyExecutor = FallbackKVDatabase.this.executor;
            }
            if (notifyExecutor == null) {
                return;
            }
            notifyExecutor.submit(() -> this.notify(t));
        }

        private void notify(Throwable t) {
            if (t != null) {
                this.setException(t);
            } else {
                this.set(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forget() {
            FallbackKVDatabase fallbackKVDatabase = FallbackKVDatabase.this;
            synchronized (fallbackKVDatabase) {
                FallbackKVDatabase.this.futures.remove((Object)this);
            }
        }
    }
}

