/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.fallback;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.jsimpledb.kv.raft.Follower;
import org.jsimpledb.kv.raft.LeaderRole;
import org.jsimpledb.kv.raft.RaftKVDatabase;
import org.jsimpledb.kv.raft.RaftKVTransaction;
import org.jsimpledb.kv.raft.Role;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.fallback.MergeStrategy;
import org.jsimpledb.kv.raft.fallback.NullMergeStrategy;
import org.jsimpledb.kv.raft.fallback.OverwriteMergeStrategy;
import org.jsimpledb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackTarget
implements Cloneable {
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 1000;
    public static final int DEFAULT_CHECK_INTERVAL = 2000;
    public static final int DEFAULT_MIN_AVAILABLE_TIME = 10000;
    public static final int DEFAULT_MIN_UNAVAILABLE_TIME = 30000;
    private static final int MAX_2NODE_FOLLOWER_STALENESS = 2000;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    boolean available;
    Date lastActiveTime;
    Timestamp lastChangeTimestamp;
    ScheduledFuture<?> future;
    private RaftKVDatabase raft;
    private int transactionTimeout = 1000;
    private int checkInterval = 2000;
    private int minAvailableTime = 10000;
    private int minUnavailableTime = 30000;
    private MergeStrategy unavailableMergeStrategy = new OverwriteMergeStrategy();
    private MergeStrategy rejoinMergeStrategy = new NullMergeStrategy();

    public RaftKVDatabase getRaftKVDatabase() {
        return this.raft;
    }

    public void setRaftKVDatabase(RaftKVDatabase raft) {
        this.raft = raft;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int timeout) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0, (Object)"timeout <= 0");
        this.transactionTimeout = timeout;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(int checkInterval) {
        Preconditions.checkArgument((checkInterval > 0 ? 1 : 0) != 0, (Object)"checkInterval <= 0");
        this.checkInterval = checkInterval;
    }

    public int getMinAvailableTime() {
        return this.minAvailableTime;
    }

    public void setMinAvailableTime(int minAvailableTime) {
        Preconditions.checkArgument((minAvailableTime > 0 ? 1 : 0) != 0, (Object)"minAvailableTime <= 0");
        this.minAvailableTime = minAvailableTime;
    }

    public int getMinUnavailableTime() {
        return this.minUnavailableTime;
    }

    public void setMinUnavailableTime(int minUnavailableTime) {
        Preconditions.checkArgument((minUnavailableTime > 0 ? 1 : 0) != 0, (Object)"minUnavailableTime <= 0");
        this.minUnavailableTime = minUnavailableTime;
    }

    public MergeStrategy getUnavailableMergeStrategy() {
        return this.unavailableMergeStrategy;
    }

    public void setUnavailableMergeStrategy(MergeStrategy strategy) {
        Preconditions.checkArgument((strategy != null ? 1 : 0) != 0, (Object)"null strategy");
        this.unavailableMergeStrategy = strategy;
    }

    public MergeStrategy getRejoinMergeStrategy() {
        return this.rejoinMergeStrategy;
    }

    public void setRejoinMergeStrategy(MergeStrategy strategy) {
        Preconditions.checkArgument((strategy != null ? 1 : 0) != 0, (Object)"null strategy");
        this.rejoinMergeStrategy = strategy;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public Date getLastChangeTime() {
        return this.lastChangeTimestamp != null ? new Date(System.currentTimeMillis() + (long)this.lastChangeTimestamp.offsetFromNow()) : null;
    }

    public Date getLastActiveTime() {
        Date copy = this.lastActiveTime;
        return copy != null ? (Date)copy.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkAvailability() {
        Follower follower;
        Timestamp leaderTimestamp;
        List<Follower> followerList;
        boolean timedOut;
        if (!this.raft.isConfigured()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("checking availability of " + this.raft + " - cluster is not configured");
            }
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("checking availability of " + this.raft + " with timeout of " + this.transactionTimeout + "ms");
        }
        long startTimeNanos = System.nanoTime();
        boolean success = false;
        RaftKVTransaction tx = this.raft.createTransaction();
        try {
            tx.setTimeout(this.transactionTimeout);
            tx.get(ByteUtil.EMPTY);
            tx.commit();
            success = true;
        }
        finally {
            if (!success) {
                tx.rollback();
            }
        }
        int duration = (int)((System.nanoTime() - startTimeNanos) / 1000000L);
        boolean bl = timedOut = duration > this.transactionTimeout;
        if (this.log.isTraceEnabled()) {
            this.log.trace("availability transaction on " + this.raft + " completed in " + duration + "ms (" + (timedOut ? "failed" : "successful") + ")");
        }
        if (timedOut) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("availability transaction on " + this.raft + " completed in " + duration + " > " + this.transactionTimeout + " ms, returning unavailable");
            }
            return false;
        }
        Role role = this.raft.getCurrentRole();
        if (role instanceof LeaderRole && (followerList = ((LeaderRole)role).getFollowers()).size() == 1 && ((leaderTimestamp = (follower = followerList.get(0)).getLeaderTimestamp()) == null || -leaderTimestamp.offsetFromNow() > 2000) && this.log.isDebugEnabled()) {
            this.log.debug("single follower's leader timestamp is " + -leaderTimestamp.offsetFromNow() + " > " + 2000 + " ms stale, returning unavailable");
            return false;
        }
        return true;
    }

    public FallbackTarget clone() {
        try {
            return (FallbackTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[raft=" + this.raft + "]";
    }
}

