/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.fallback;

import java.util.Date;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.raft.fallback.MergeStrategy;
import org.jsimpledb.util.CloseableIterator;

public class OverwriteMergeStrategy
implements MergeStrategy {
    @Override
    public void mergeAndCommit(KVTransaction src, KVTransaction dst, Date lastActiveTime) {
        this.overwrite(src, dst);
        src.commit();
        dst.commit();
    }

    protected void overwrite(KVTransaction src, KVTransaction dst) {
        dst.removeRange(null, null);
        try (CloseableIterator i = src.getRange(null, null);){
            while (i.hasNext()) {
                KVPair pair = (KVPair)i.next();
                dst.put(pair.getKey(), pair.getValue());
            }
        }
    }

    public String toString() {
        return "Overwrite";
    }
}

