/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.msg;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.raft.Timestamp;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.util.LongEncoder;

public class AppendRequest
extends Message {
    private final Timestamp leaderTimestamp;
    private final Timestamp leaderLeaseTimeout;
    private final long leaderCommit;
    private final long prevLogTerm;
    private final long prevLogIndex;
    private final long logEntryTerm;
    private ByteBuffer mutationData;
    private boolean mutationDataInvalid;

    public AppendRequest(int clusterId, String senderId, String recipientId, long term, Timestamp leaderTimestamp, Timestamp leaderLeaseTimeout, long leaderCommit, long prevLogTerm, long prevLogIndex) {
        this(clusterId, senderId, recipientId, term, leaderTimestamp, leaderLeaseTimeout, Math.min(leaderCommit, prevLogIndex), prevLogTerm, prevLogIndex, 0L, null);
    }

    public AppendRequest(int clusterId, String senderId, String recipientId, long term, Timestamp leaderTimestamp, Timestamp leaderLeaseTimeout, long leaderCommit, long prevLogTerm, long prevLogIndex, long logEntryTerm, ByteBuffer mutationData) {
        super((byte)1, clusterId, senderId, recipientId, term);
        this.leaderTimestamp = leaderTimestamp;
        this.leaderLeaseTimeout = leaderLeaseTimeout;
        this.leaderCommit = leaderCommit;
        this.prevLogTerm = prevLogTerm;
        this.prevLogIndex = prevLogIndex;
        this.logEntryTerm = logEntryTerm;
        this.mutationData = mutationData;
        this.checkArguments();
    }

    AppendRequest(ByteBuffer buf, int version) {
        super((byte)1, buf, version);
        this.leaderTimestamp = Message.getTimestamp(buf, version);
        this.leaderLeaseTimeout = Message.getBoolean(buf) ? this.leaderTimestamp.offset((int)LongEncoder.read((ByteBuffer)buf)) : null;
        this.leaderCommit = LongEncoder.read((ByteBuffer)buf);
        this.prevLogTerm = LongEncoder.read((ByteBuffer)buf);
        this.prevLogIndex = LongEncoder.read((ByteBuffer)buf);
        this.logEntryTerm = LongEncoder.read((ByteBuffer)buf);
        this.mutationData = this.logEntryTerm != 0L && Message.getBoolean(buf) ? Message.getByteBuffer(buf) : null;
        this.checkArguments();
    }

    @Override
    void checkArguments() {
        super.checkArguments();
        Preconditions.checkArgument((this.leaderTimestamp != null ? 1 : 0) != 0);
        Preconditions.checkArgument((this.leaderCommit >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.prevLogTerm >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.prevLogIndex >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.logEntryTerm >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.mutationData == null || this.logEntryTerm > 0L ? 1 : 0) != 0);
    }

    public Timestamp getLeaderTimestamp() {
        return this.leaderTimestamp;
    }

    public Timestamp getLeaderLeaseTimeout() {
        return this.leaderLeaseTimeout;
    }

    public long getLeaderCommit() {
        return this.leaderCommit;
    }

    public long getPrevLogTerm() {
        return this.prevLogTerm;
    }

    public long getPrevLogIndex() {
        return this.prevLogIndex;
    }

    public boolean isProbe() {
        return this.logEntryTerm == 0L;
    }

    public long getLogEntryTerm() {
        return this.logEntryTerm;
    }

    public ByteBuffer getMutationData() {
        Preconditions.checkState((!this.mutationDataInvalid ? 1 : 0) != 0);
        ByteBuffer result = this.mutationData;
        this.mutationData = null;
        this.mutationDataInvalid = true;
        return result;
    }

    @Override
    public boolean isLeaderMessage() {
        return true;
    }

    @Override
    public void visit(MessageSwitch handler) {
        handler.caseAppendRequest(this);
    }

    @Override
    public void writeTo(ByteBuffer dest, int version) {
        Preconditions.checkState((!this.mutationDataInvalid ? 1 : 0) != 0);
        super.writeTo(dest, version);
        Message.putTimestamp(dest, this.leaderTimestamp, version);
        Message.putBoolean(dest, this.leaderLeaseTimeout != null);
        if (this.leaderLeaseTimeout != null) {
            LongEncoder.write((ByteBuffer)dest, (long)this.leaderLeaseTimeout.offsetFrom(this.leaderTimestamp));
        }
        LongEncoder.write((ByteBuffer)dest, (long)this.leaderCommit);
        LongEncoder.write((ByteBuffer)dest, (long)this.prevLogTerm);
        LongEncoder.write((ByteBuffer)dest, (long)this.prevLogIndex);
        LongEncoder.write((ByteBuffer)dest, (long)this.logEntryTerm);
        if (this.logEntryTerm != 0L) {
            Message.putBoolean(dest, this.mutationData != null);
            if (this.mutationData != null) {
                Message.putByteBuffer(dest, this.mutationData);
            }
        }
    }

    @Override
    protected int calculateSize(int version) {
        Preconditions.checkState((!this.mutationDataInvalid ? 1 : 0) != 0);
        return super.calculateSize(version) + Message.calculateSize(this.leaderTimestamp, version) + 1 + (this.leaderLeaseTimeout != null ? LongEncoder.encodeLength((long)this.leaderLeaseTimeout.offsetFrom(this.leaderTimestamp)) : 0) + LongEncoder.encodeLength((long)this.leaderCommit) + LongEncoder.encodeLength((long)this.prevLogTerm) + LongEncoder.encodeLength((long)this.prevLogIndex) + LongEncoder.encodeLength((long)this.logEntryTerm) + (this.logEntryTerm != 0L ? 1 + (this.mutationData != null ? Message.calculateSize(this.mutationData) : 0) : 0);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.getSenderId() + "\"->\"" + this.getRecipientId() + "\",clusterId=" + String.format("%08x", this.getClusterId()) + ",term=" + this.getTerm() + ",leaderTimestamp=" + this.leaderTimestamp + (this.leaderLeaseTimeout != null ? ",leaderLeaseTimeout=" + String.format("%+dms", this.leaderLeaseTimeout.offsetFrom(this.leaderTimestamp)) : "") + ",leaderCommit=" + this.leaderCommit + ",prevLog=" + this.prevLogIndex + "t" + this.prevLogTerm + (this.logEntryTerm != 0L ? ",logEntryTerm=" + this.logEntryTerm : "") + (this.mutationData != null ? ",mutationData=" + this.describe(this.mutationData) : (this.mutationDataInvalid ? ",mutationData=invalid" : "")) + "]";
    }
}

