/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.raft.msg;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.raft.msg.Message;
import org.jsimpledb.kv.raft.msg.MessageSwitch;
import org.jsimpledb.util.LongEncoder;

public class RequestVote
extends Message {
    private final long lastLogTerm;
    private final long lastLogIndex;

    public RequestVote(int clusterId, String senderId, String recipientId, long term, long lastLogTerm, long lastLogIndex) {
        super((byte)7, clusterId, senderId, recipientId, term);
        this.lastLogTerm = lastLogTerm;
        this.lastLogIndex = lastLogIndex;
        this.checkArguments();
    }

    RequestVote(ByteBuffer buf, int version) {
        super((byte)7, buf, version);
        this.lastLogTerm = LongEncoder.read((ByteBuffer)buf);
        this.lastLogIndex = LongEncoder.read((ByteBuffer)buf);
        this.checkArguments();
    }

    @Override
    void checkArguments() {
        super.checkArguments();
        Preconditions.checkArgument((this.lastLogTerm > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((this.lastLogIndex > 0L ? 1 : 0) != 0);
    }

    public long getLastLogTerm() {
        return this.lastLogTerm;
    }

    public long getLastLogIndex() {
        return this.lastLogIndex;
    }

    @Override
    public void visit(MessageSwitch handler) {
        handler.caseRequestVote(this);
    }

    @Override
    public void writeTo(ByteBuffer dest, int version) {
        super.writeTo(dest, version);
        LongEncoder.write((ByteBuffer)dest, (long)this.lastLogTerm);
        LongEncoder.write((ByteBuffer)dest, (long)this.lastLogIndex);
    }

    @Override
    protected int calculateSize(int version) {
        return super.calculateSize(version) + LongEncoder.encodeLength((long)this.lastLogTerm) + LongEncoder.encodeLength((long)this.lastLogIndex);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.getSenderId() + "\"->\"" + this.getRecipientId() + "\",clusterId=" + String.format("%08x", this.getClusterId()) + ",term=" + this.getTerm() + ",lastLogTerm=" + this.lastLogTerm + ",lastLogIndex=" + this.lastLogIndex + "]";
    }
}

