/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.leveldb;

import java.io.File;
import java.util.ArrayDeque;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.leveldb.LevelDBAtomicKVStore;
import org.jsimpledb.kv.leveldb.LevelDBKVDatabase;
import org.jsimpledb.kv.mvcc.AtomicKVStore;

public class LevelDBKVImplementation
extends KVImplementation {
    public String[][] getCommandLineOptions() {
        return new String[][]{{"--leveldb directory", "Use LevelDB key/value database in the specified directory"}};
    }

    public File parseCommandLineOptions(ArrayDeque<String> options) {
        String arg = this.parseCommandLineOption(options, "--leveldb");
        return arg != null ? new File(arg) : null;
    }

    public LevelDBKVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        LevelDBKVDatabase leveldb = new LevelDBKVDatabase();
        leveldb.setKVStore(this.createAtomicKVStore(configuration));
        return leveldb;
    }

    public LevelDBAtomicKVStore createAtomicKVStore(Object configuration) {
        LevelDBAtomicKVStore kvstore = new LevelDBAtomicKVStore();
        kvstore.setDirectory((File)configuration);
        kvstore.setCreateIfMissing(true);
        return kvstore;
    }

    public String getDescription(Object configuration) {
        return "LevelDB " + ((File)configuration).getName();
    }
}

