/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.leveldb;

import java.util.ArrayList;
import org.iq80.leveldb.DBFactory;
import org.jsimpledb.kv.leveldb.LevelDBKVDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LevelDBUtil {
    public static final String LEVELDBJNI_CLASS_NAME = "org.fusesource.leveldbjni.JniDBFactory";
    public static final String LEVELDB_CLASS_NAME = "org.iq80.leveldb.impl.Iq80DBFactory";
    public static final String DB_FACTORY_PROPERTY = LevelDBUtil.class.getName() + ".db_factory";

    private LevelDBUtil() {
    }

    public static DBFactory getDefaultDBFactory() {
        ArrayList<String> classNames = new ArrayList<String>(3);
        String configuredFactoryClass = System.getProperty(DB_FACTORY_PROPERTY, null);
        if (configuredFactoryClass != null) {
            classNames.add(configuredFactoryClass);
        }
        classNames.add(LEVELDBJNI_CLASS_NAME);
        classNames.add(LEVELDB_CLASS_NAME);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Logger log = LoggerFactory.getLogger(LevelDBKVDatabase.class);
        for (String className : classNames) {
            try {
                return Class.forName(className, false, loader).asSubclass(DBFactory.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("can't load factory class `" + className + "': " + e);
            }
        }
        throw new RuntimeException("no " + DBFactory.class.getName() + " implementation found; tried: " + classNames);
    }
}

