/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.leveldb;

import org.iq80.leveldb.DB;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.leveldb.LevelDBKVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLevelDBKVStore
extends LevelDBKVStore
implements CloseableKVStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Snapshot snapshot;
    private boolean closed;

    public SnapshotLevelDBKVStore(DB db, boolean verifyChecksums) {
        this(db, db.getSnapshot(), verifyChecksums);
    }

    private SnapshotLevelDBKVStore(DB db, Snapshot snapshot, boolean verifyChecksums) {
        super(db, new ReadOptions().snapshot(snapshot).verifyChecksums(verifyChecksums), null);
        this.snapshot = snapshot;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        try {
            this.snapshot.close();
        }
        catch (Throwable e) {
            this.log.error("caught exception closing LevelDB snapshot (ignoring)", e);
        }
    }

    @Override
    public void put(byte[] key, byte[] value) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    @Override
    public void remove(byte[] key) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }

    public void adjustCounter(byte[] key, long amount) {
        throw new UnsupportedOperationException("KVStore is read-only");
    }
}

