/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.array;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.jsimpledb.kv.KVPair;

class ArrayKVFinder {
    private static final int MAX_PREFIX_LENGTH = 20;
    private static final int END = -1;
    private final ByteBuffer indx;
    private final ByteBuffer keys;
    private final ByteBuffer vals;
    private final int size;
    private final byte[] prefix = new byte[20];
    private final int[] prefixMin = new int[20];
    private final int[] prefixMax = new int[20];
    private int prefixLength;

    ArrayKVFinder(ByteBuffer indx, ByteBuffer keys, ByteBuffer vals) {
        Preconditions.checkArgument((indx.capacity() % 8 == 0 ? 1 : 0) != 0, (Object)"index size is not a multiple of 8");
        this.indx = indx.duplicate();
        this.keys = keys.duplicate();
        this.vals = vals.duplicate();
        this.indx.limit(this.indx.capacity());
        this.keys.limit(this.keys.capacity());
        this.vals.limit(this.vals.capacity());
        this.size = this.indx.capacity() / 8;
    }

    public int find(byte[] searchKey) {
        int min = 0;
        int max = this.size;
        for (int i = 0; i < this.prefixLength; ++i) {
            int diff;
            int n = diff = i < searchKey.length ? (searchKey[i] & 0xFF) - (this.prefix[i] & 0xFF) : -1;
            if (diff <= 0) {
                max = Math.min(max, this.prefixMax[i]);
            }
            if (diff >= 0) {
                min = Math.max(min, this.prefixMin[i]);
            }
            if (diff == 0) continue;
            this.prefixLength = i;
            break;
        }
        while (min < max) {
            int nextMax;
            int mid = min + (max - 1) >>> 1;
            byte[] midKey = this.readKey(mid);
            int len = 0;
            boolean extendPrefix = false;
            boolean newLowerPrefixBound = false;
            boolean newUpperPrefixBound = false;
            while (true) {
                if (len == searchKey.length) {
                    if (len == midKey.length) {
                        return mid;
                    }
                    max = mid;
                    break;
                }
                if (len == midKey.length) {
                    min = mid + 1;
                    extendPrefix = true;
                    newLowerPrefixBound = true;
                    break;
                }
                int searchKeyByte = searchKey[len] & 0xFF;
                int midKeyByte = midKey[len] & 0xFF;
                if (searchKeyByte < midKeyByte) {
                    max = mid;
                    extendPrefix = true;
                    newUpperPrefixBound = true;
                    break;
                }
                if (searchKeyByte > midKeyByte) {
                    min = mid + 1;
                    extendPrefix = true;
                    newLowerPrefixBound = true;
                    break;
                }
                ++len;
            }
            if (!extendPrefix) continue;
            while (this.prefixLength < len && this.prefixLength < 20) {
                int next = this.prefixLength;
                this.prefix[next] = searchKey[next];
                this.prefixMin[next] = next > 0 ? this.prefixMin[next - 1] : 0;
                this.prefixMax[next] = next > 0 ? this.prefixMax[next - 1] : this.size;
                ++this.prefixLength;
            }
            if (this.prefixLength >= 20) continue;
            this.prefix[len] = searchKey[len];
            int nextMin = len > 0 ? this.prefixMin[len - 1] : 0;
            int n = nextMax = len > 0 ? this.prefixMax[len - 1] : this.size;
            if (newLowerPrefixBound) {
                nextMin = Math.max(nextMin, min);
            }
            if (newUpperPrefixBound) {
                nextMax = Math.min(nextMax, max);
            }
            this.prefixMin[len] = nextMin;
            this.prefixMax[len] = nextMax;
            this.prefixLength = len + 1;
        }
        return ~min;
    }

    public byte[] readKey(int index) {
        int nextOffset;
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index < 0");
        Preconditions.checkArgument((index < this.size ? 1 : 0) != 0, (Object)"index >= size");
        int baseIndex = index & 0xFFFFFFE0;
        int baseKeyOffset = this.indx.getInt(baseIndex * 8);
        if (index == baseIndex) {
            int length = index + 1 < this.size ? this.indx.getInt((index + 1) * 8) & 0xFFFFFF : this.keys.capacity() - baseKeyOffset;
            byte[] data = new byte[length];
            this.keys.position(baseKeyOffset);
            this.keys.get(data);
            return data;
        }
        int encodedValue = this.indx.getInt(index * 8);
        int prefixLen = encodedValue >>> 24;
        int suffixOffset = baseKeyOffset + (encodedValue & 0xFFFFFF);
        int nextIndex = index + 1;
        if (nextIndex < this.size) {
            nextOffset = this.indx.getInt(nextIndex * 8);
            if ((nextIndex & 0x1F) != 0) {
                nextOffset = baseKeyOffset + (nextOffset & 0xFFFFFF);
            }
        } else {
            nextOffset = this.keys.capacity();
        }
        int suffixLen = nextOffset - suffixOffset;
        byte[] key = new byte[prefixLen + suffixLen];
        if (prefixLen > 0) {
            this.keys.position(baseKeyOffset);
            this.keys.get(key, 0, prefixLen);
        }
        assert (suffixLen > 0);
        this.keys.position(suffixOffset);
        this.keys.get(key, prefixLen, suffixLen);
        return key;
    }

    public byte[] readValue(int index) {
        Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0, (Object)"index < 0");
        Preconditions.checkArgument((index < this.size ? 1 : 0) != 0, (Object)"index >= size");
        int dataOffset = this.indx.getInt(index * 8 + 4);
        int nextOffset = index + 1 < this.size ? this.indx.getInt((index + 1) * 8 + 4) : this.vals.capacity();
        int length = nextOffset - dataOffset;
        byte[] data = new byte[length];
        this.vals.position(dataOffset);
        this.vals.get(data);
        return data;
    }

    public KVPair readKV(int index) {
        return new KVPair(this.readKey(index), this.readValue(index));
    }
}

