/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.array;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.array.ArrayKVFinder;

public class ArrayKVStore
extends AbstractKVStore {
    private final ByteBuffer indx;
    private final ByteBuffer keys;
    private final ByteBuffer vals;
    private final int size;
    private final ThreadLocal<ArrayKVFinder> finderThreadLocal = new ThreadLocal<ArrayKVFinder>(){

        @Override
        protected ArrayKVFinder initialValue() {
            return new ArrayKVFinder(ArrayKVStore.this.indx, ArrayKVStore.this.keys, ArrayKVStore.this.vals);
        }
    };

    public ArrayKVStore(ByteBuffer indx, ByteBuffer keys, ByteBuffer vals) {
        Preconditions.checkArgument((indx != null ? 1 : 0) != 0, (Object)"null indx");
        Preconditions.checkArgument((keys != null ? 1 : 0) != 0, (Object)"null keys");
        Preconditions.checkArgument((vals != null ? 1 : 0) != 0, (Object)"null vals");
        Preconditions.checkArgument((indx.capacity() % 8 == 0 ? 1 : 0) != 0, (Object)"index size is not a multiple of 8");
        this.indx = indx;
        this.keys = keys;
        this.vals = vals;
        this.size = this.indx.capacity() / 8;
    }

    public byte[] get(byte[] key) {
        ArrayKVFinder finder = this.finderThreadLocal.get();
        int index = finder.find(key);
        if (index < 0) {
            return null;
        }
        return finder.readValue(index);
    }

    public KVPair getAtLeast(byte[] minKey) {
        ArrayKVFinder finder = this.finderThreadLocal.get();
        int index = finder.find(minKey);
        if (index < 0 && (index ^= 0xFFFFFFFF) == this.size) {
            return null;
        }
        return finder.readKV(index);
    }

    public KVPair getAtMost(byte[] maxKey) {
        ArrayKVFinder finder = this.finderThreadLocal.get();
        int index = finder.find(maxKey);
        if (index < 0) {
            index ^= 0xFFFFFFFF;
        }
        if (index == 0) {
            return null;
        }
        return finder.readKV(index - 1);
    }

    public Iterator<KVPair> getRange(byte[] minKey, byte[] maxKey, final boolean reverse) {
        int index;
        ArrayKVFinder finder = this.finderThreadLocal.get();
        if (minKey == null || minKey.length == 0) {
            index = 0;
        } else {
            index = finder.find(minKey);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
        }
        final int minIndex = index;
        if (maxKey == null) {
            index = this.size;
        } else {
            index = finder.find(maxKey);
            if (index < 0) {
                index ^= 0xFFFFFFFF;
            }
        }
        final int maxIndex = index;
        return new UnmodifiableIterator<KVPair>(){
            private int index;
            {
                this.index = reverse ? maxIndex : minIndex;
            }

            public boolean hasNext() {
                return reverse ? this.index > minIndex : this.index < maxIndex;
            }

            public KVPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (reverse) {
                    --this.index;
                }
                KVPair kv = ((ArrayKVFinder)ArrayKVStore.this.finderThreadLocal.get()).readKV(this.index);
                if (!reverse) {
                    ++this.index;
                }
                return kv;
            }
        };
    }

    public void put(byte[] key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    public void remove(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        throw new UnsupportedOperationException();
    }
}

