/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.array;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ForwardingFuture;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.dellroad.stuff.io.AtomicUpdateFileOutputStream;
import org.jsimpledb.kv.AbstractKVStore;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVPair;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.array.ArrayKVException;
import org.jsimpledb.kv.array.ArrayKVStore;
import org.jsimpledb.kv.array.ArrayKVWriter;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.Mutations;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.util.CloseableForwardingKVStore;
import org.jsimpledb.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AtomicArrayKVStore
extends AbstractKVStore
implements AtomicKVStore {
    public static final int DEFAULT_COMPACTION_MAX_DELAY = 90;
    public static final int DEFAULT_COMPACTION_LOW_WATER = 65536;
    public static final int DEFAULT_COMPACTION_HIGH_WATER = 0x40000000;
    private static final int MIN_MMAP_LENGTH = 0x100000;
    private static final String GENERATION_FILE_NAME = "gen";
    private static final String LOCK_FILE_NAME = "lockfile";
    private static final String INDX_FILE_NAME_BASE = "indx.";
    private static final String KEYS_FILE_NAME_BASE = "keys.";
    private static final String VALS_FILE_NAME_BASE = "vals.";
    private static final String MODS_FILE_NAME_BASE = "mods.";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private final Condition hotCopyFinishedCondition = this.writeLock.newCondition();
    private final boolean suckyOS = this.isWindows();
    @GuardedBy(value="lock")
    private File directory;
    @GuardedBy(value="lock")
    private ScheduledExecutorService scheduledExecutorService;
    @GuardedBy(value="lock")
    private int compactMaxDelay = 90;
    @GuardedBy(value="lock")
    private int compactLowWater = 65536;
    @GuardedBy(value="lock")
    private int compactHighWater = 0x40000000;
    @GuardedBy(value="lock")
    private long generation;
    @GuardedBy(value="lock")
    private boolean createdExecutorService;
    @GuardedBy(value="lock")
    private File generationFile;
    @GuardedBy(value="lock")
    private File lockFile;
    @GuardedBy(value="lock")
    private FileChannel lockFileChannel;
    @GuardedBy(value="lock")
    private File indxFile;
    @GuardedBy(value="lock")
    private File keysFile;
    @GuardedBy(value="lock")
    private File valsFile;
    @GuardedBy(value="lock")
    private File modsFile;
    @GuardedBy(value="lock")
    private FileOutputStream modsFileOutput;
    @GuardedBy(value="lock")
    private FileChannel directoryChannel;
    @GuardedBy(value="lock")
    private long modsFileLength;
    @GuardedBy(value="lock")
    private long modsFileSyncPoint;
    @GuardedBy(value="lock")
    private ByteBuffer indx;
    @GuardedBy(value="lock")
    private ByteBuffer keys;
    @GuardedBy(value="lock")
    private ByteBuffer vals;
    @GuardedBy(value="lock")
    private ArrayKVStore kvstore;
    @GuardedBy(value="lock")
    private MutableView mods;
    @GuardedBy(value="lock")
    private Compaction compaction;
    @GuardedBy(value="lock")
    private long firstModTimestamp;
    @GuardedBy(value="lock")
    private int hotCopiesInProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getDirectory() {
        this.readLock.lock();
        try {
            File file = this.directory;
            return file;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectory(File directory) {
        this.writeLock.lock();
        try {
            Preconditions.checkState((this.kvstore == null ? 1 : 0) != 0, (Object)"already started");
            this.directory = directory;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.writeLock.lock();
        try {
            Preconditions.checkState((this.kvstore == null ? 1 : 0) != 0, (Object)"already started");
            this.scheduledExecutorService = scheduledExecutorService;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompactMaxDelay(int compactMaxDelay) {
        Preconditions.checkState((compactMaxDelay >= 0 ? 1 : 0) != 0, (Object)"negative value");
        this.writeLock.lock();
        try {
            Preconditions.checkState((this.kvstore == null ? 1 : 0) != 0, (Object)"already started");
            this.compactMaxDelay = compactMaxDelay;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompactLowWater(int compactLowWater) {
        Preconditions.checkState((compactLowWater >= 0 ? 1 : 0) != 0, (Object)"negative value");
        this.writeLock.lock();
        try {
            Preconditions.checkState((this.kvstore == null ? 1 : 0) != 0, (Object)"already started");
            this.compactLowWater = compactLowWater;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompactHighWater(int compactHighWater) {
        Preconditions.checkState((compactHighWater >= 0 ? 1 : 0) != 0, (Object)"negative value");
        this.writeLock.lock();
        try {
            Preconditions.checkState((this.kvstore == null ? 1 : 0) != 0, (Object)"already started");
            this.compactHighWater = compactHighWater;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void start() {
        boolean success = false;
        this.writeLock.lock();
        try {
            Throwable throwable;
            block201: {
                if (this.kvstore != null) {
                    success = true;
                    return;
                }
                this.log.info("starting " + (Object)((Object)this));
                assert (this.compaction == null);
                assert (this.scheduledExecutorService == null);
                assert (!this.createdExecutorService);
                assert (this.generation == 0L);
                assert (this.generationFile == null);
                assert (this.lockFile == null);
                assert (this.lockFileChannel == null);
                assert (this.indxFile == null);
                assert (this.keysFile == null);
                assert (this.valsFile == null);
                assert (this.modsFile == null);
                assert (this.modsFileOutput == null);
                assert (this.directoryChannel == null);
                assert (this.modsFileLength == 0L);
                assert (this.modsFileSyncPoint == 0L);
                assert (this.indx == null);
                assert (this.keys == null);
                assert (this.vals == null);
                assert (this.kvstore == null);
                assert (this.mods == null);
                assert (this.firstModTimestamp == 0L);
                Preconditions.checkState((this.directory != null ? 1 : 0) != 0, (Object)"no directory configured");
                boolean bl = this.createdExecutorService = this.scheduledExecutorService == null;
                if (this.createdExecutorService) {
                    this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable action) {
                            Thread thread = new Thread(action);
                            thread.setName("Compactor for " + (Object)((Object)AtomicArrayKVStore.this));
                            return thread;
                        }
                    });
                }
                boolean initializeFiles = false;
                if (!this.directory.exists() && !this.directory.mkdirs()) {
                    throw new ArrayKVException("failed to create directory `" + this.directory + "'");
                }
                if (!this.directory.isDirectory()) {
                    throw new ArrayKVException("file `" + this.directory + "' is not a directory");
                }
                try {
                    this.directoryChannel = FileChannel.open(this.directory.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    if (this.suckyOS) break block201;
                    throw e;
                }
            }
            this.lockFile = new File(this.directory, LOCK_FILE_NAME);
            this.lockFileChannel = !this.lockFile.exists() ? FileChannel.open(this.lockFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW) : FileChannel.open(this.lockFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            FileLock fileLock = null;
            try {
                fileLock = this.lockFileChannel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                // empty catch block
            }
            if (fileLock == null) {
                throw new ArrayKVException("database is already locked by another process or thread");
            }
            this.generationFile = new File(this.directory, GENERATION_FILE_NAME);
            if (!this.generationFile.exists()) {
                Object name;
                throwable = null;
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.directory.toPath());){
                    for (Path path : paths) {
                        File file = path.toFile();
                        name = file.getName();
                        if (!((String)name).startsWith(INDX_FILE_NAME_BASE) && !((String)name).startsWith(KEYS_FILE_NAME_BASE) && !((String)name).startsWith(VALS_FILE_NAME_BASE)) continue;
                        throw new ArrayKVException("database file inconsistency: found " + (String)name + " but not " + GENERATION_FILE_NAME + " in " + this.directory);
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                throwable = null;
                try (FileOutputStream indxOutput = new FileOutputStream(new File(this.directory, "indx.0"));){
                    Throwable throwable2 = null;
                    try (FileOutputStream keysOutput = new FileOutputStream(new File(this.directory, "keys.0"));){
                        FileOutputStream valsOutput = new FileOutputStream(new File(this.directory, "vals.0"));
                        name = null;
                        try (ArrayKVWriter arrayWriter = new ArrayKVWriter(indxOutput, keysOutput, valsOutput);){
                            arrayWriter.flush();
                            valsOutput.getChannel().force(false);
                            keysOutput.getChannel().force(false);
                            indxOutput.getChannel().force(false);
                        }
                        catch (Throwable throwable3) {
                            name = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (valsOutput != null) {
                                if (name != null) {
                                    try {
                                        valsOutput.close();
                                    }
                                    catch (Throwable x2) {
                                        ((Throwable)name).addSuppressed(x2);
                                    }
                                } else {
                                    valsOutput.close();
                                }
                            }
                        }
                    }
                    catch (Throwable x2) {
                        Throwable throwable4 = x2;
                        throw x2;
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                if (this.directoryChannel != null) {
                    this.directoryChannel.force(false);
                }
                throwable = null;
                try (FileOutputStream output = new FileOutputStream(this.generationFile);){
                    output.write("0\n".getBytes(StandardCharsets.UTF_8));
                    output.flush();
                    output.getChannel().force(false);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                if (this.directoryChannel != null) {
                    this.directoryChannel.force(false);
                }
            }
            try {
                throwable = null;
                try (LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(this.generationFile), "UTF-8"));){
                    String line = reader.readLine();
                    if (line == null) {
                        throw new ArrayKVException("generation file " + this.generationFile + " is empty");
                    }
                    this.generation = Long.parseLong(line.trim(), 10);
                    if (this.generation < 0L) {
                        throw new ArrayKVException("read negative generation number from " + this.generationFile);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception e) {
                throw new ArrayKVException("error reading generation file", e);
            }
            this.indxFile = new File(this.directory, INDX_FILE_NAME_BASE + this.generation);
            this.keysFile = new File(this.directory, KEYS_FILE_NAME_BASE + this.generation);
            this.valsFile = new File(this.directory, VALS_FILE_NAME_BASE + this.generation);
            this.modsFile = new File(this.directory, MODS_FILE_NAME_BASE + this.generation);
            List<File> expectedFiles = Arrays.asList(this.lockFile, this.generationFile, this.indxFile, this.keysFile, this.valsFile, this.modsFile);
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.directory.toPath());){
                for (Path path : paths) {
                    File file = path.toFile();
                    if (expectedFiles.contains(file)) continue;
                    this.log.warn("ignoring unexpected file " + file.getName() + " in my database directory");
                }
            }
            var6_11 = null;
            try (FileInputStream input = new FileInputStream(this.indxFile);){
                this.indx = AtomicArrayKVStore.getBuffer(this.indxFile, input.getChannel());
            }
            catch (Throwable throwable5) {
                var6_11 = throwable5;
                throw throwable5;
            }
            input = new FileInputStream(this.keysFile);
            var6_11 = null;
            try {
                this.keys = AtomicArrayKVStore.getBuffer(this.keysFile, input.getChannel());
            }
            catch (Throwable throwable6) {
                var6_11 = throwable6;
                throw throwable6;
            }
            finally {
                if (input != null) {
                    if (var6_11 != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable4) {
                            var6_11.addSuppressed(throwable4);
                        }
                    } else {
                        input.close();
                    }
                }
            }
            input = new FileInputStream(this.valsFile);
            var6_11 = null;
            try {
                this.vals = AtomicArrayKVStore.getBuffer(this.valsFile, input.getChannel());
            }
            catch (Throwable throwable7) {
                var6_11 = throwable7;
                throw throwable7;
            }
            finally {
                if (input != null) {
                    if (var6_11 != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable8) {
                            var6_11.addSuppressed(throwable8);
                        }
                    } else {
                        input.close();
                    }
                }
            }
            this.kvstore = new ArrayKVStore(this.indx, this.keys, this.vals);
            this.mods = new MutableView((KVStore)this.kvstore, null, new Writes());
            this.modsFileOutput = new FileOutputStream(this.modsFile, true);
            this.modsFileSyncPoint = this.modsFileLength = this.modsFileOutput.getChannel().size();
            if (this.modsFileLength > 0L) {
                this.log.info("reading " + this.modsFileLength + " bytes of uncompacted modifications from " + this.modsFile);
                input = new FileInputStream(this.modsFile);
                var6_11 = null;
                try {
                    while (input.available() > 0) {
                        Writes writes;
                        try {
                            writes = Writes.deserialize((InputStream)input);
                        }
                        catch (Exception e) {
                            break;
                        }
                        writes.applyTo((KVStore)this.mods);
                    }
                }
                catch (Throwable throwable9) {
                    var6_11 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (input != null) {
                        if (var6_11 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable10) {
                                var6_11.addSuppressed(throwable10);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
                this.firstModTimestamp = System.nanoTime() | 1L;
            }
            this.scheduleCompactionIfNecessary();
            success = true;
        }
        catch (IOException e) {
            throw new ArrayKVException("startup failed", e);
        }
        finally {
            try {
                if (!success) {
                    this.cleanup();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() {
        this.writeLock.lock();
        try {
            if (this.kvstore == null) {
                return;
            }
            this.log.info("stopping " + (Object)((Object)this));
            this.cleanup();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void cleanup() {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (this.compaction != null && !this.compaction.cancel()) {
            this.log.debug("waiting for in-progress compaction to complete before shutdown");
            this.compaction.waitForCompletion(0L);
            this.log.debug("compaction completed, proceeding with shutdown");
            if (this.kvstore == null) {
                return;
            }
        }
        if (this.hotCopiesInProgress > 0) {
            this.log.debug("waiting for " + this.hotCopiesInProgress + " hot copies to complete before shutdown");
            boolean interrupted = false;
            do {
                try {
                    this.hotCopyFinishedCondition.await();
                }
                catch (InterruptedException e) {
                    this.log.warn("thread interrupted while waiting for " + this.hotCopiesInProgress + " hot copies to complete (ignoring)", (Throwable)e);
                    interrupted = true;
                }
                if (this.kvstore != null) continue;
                return;
            } while (this.hotCopiesInProgress > 0);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.log.debug("hot copies completed, proceeding with shutdown");
        }
        if (this.createdExecutorService) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
            this.createdExecutorService = false;
        }
        for (Closeable resource : new Closeable[]{this.modsFileOutput, this.directoryChannel, this.lockFileChannel}) {
            if (resource == null) continue;
            this.closeIgnoreException(resource);
        }
        this.generation = 0L;
        this.generationFile = null;
        this.lockFile = null;
        this.lockFileChannel = null;
        this.indxFile = null;
        this.keysFile = null;
        this.valsFile = null;
        this.modsFile = null;
        this.modsFileOutput = null;
        this.directoryChannel = null;
        this.modsFileLength = 0L;
        this.modsFileSyncPoint = 0L;
        this.indx = null;
        this.keys = null;
        this.vals = null;
        this.kvstore = null;
        this.mods = null;
        this.firstModTimestamp = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) {
        this.readLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"closed");
            byte[] byArray = this.mods.get(key);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVPair getAtLeast(byte[] minKey) {
        this.readLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"closed");
            KVPair kVPair = this.mods.getAtLeast(minKey);
            return kVPair;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVPair getAtMost(byte[] maxKey) {
        this.readLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"closed");
            KVPair kVPair = this.mods.getAtMost(maxKey);
            return kVPair;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<KVPair> getRange(byte[] minKey, byte[] maxKey, boolean reverse) {
        this.readLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"closed");
            Iterator iterator = this.mods.getRange(minKey, maxKey, reverse);
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void put(byte[] key, byte[] value) {
        Writes writes = new Writes();
        writes.getPuts().put(key, value);
        this.mutate((Mutations)writes, false);
    }

    public void remove(byte[] key) {
        Writes writes = new Writes();
        writes.setRemoves(new KeyRanges(key));
        this.mutate((Mutations)writes, false);
    }

    public void removeRange(byte[] minKey, byte[] maxKey) {
        Writes writes = new Writes();
        writes.setRemoves(new KeyRanges(minKey != null ? minKey : ByteUtil.EMPTY, maxKey));
        this.mutate((Mutations)writes, false);
    }

    public void adjustCounter(byte[] key, long amount) {
        Writes writes = new Writes();
        writes.getAdjusts().put(key, amount);
        this.mutate((Mutations)writes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeCounter(long value) {
        this.readLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"closed");
            byte[] byArray = this.mods.encodeCounter(value);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decodeCounter(byte[] bytes) {
        this.readLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"closed");
            long l = this.mods.decodeCounter(bytes);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableKVStore snapshot() {
        this.readLock.lock();
        try {
            Writes writes1;
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"closed");
            if (this.mods.getKVStore() instanceof MutableView) {
                MutableView oldMods = (MutableView)this.mods.getKVStore();
                assert (oldMods.getKVStore() == this.kvstore);
                writes1 = oldMods.getWrites();
            } else {
                writes1 = null;
            }
            Writes writes2 = this.mods.getWrites();
            ArrayKVStore snapshot = this.kvstore;
            if (writes1 != null && !writes1.isEmpty()) {
                snapshot = new MutableView((KVStore)snapshot, null, writes1.clone());
            }
            if (writes2 != null && !writes2.isEmpty()) {
                snapshot = new MutableView((KVStore)snapshot, null, writes2.clone());
            }
            CloseableForwardingKVStore closeableForwardingKVStore = new CloseableForwardingKVStore((KVStore)snapshot);
            return closeableForwardingKVStore;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(Mutations mutations, boolean sync) {
        Preconditions.checkArgument((mutations != null ? 1 : 0) != 0, (Object)"null mutations");
        this.writeLock.lock();
        try {
            long newModsFileLength;
            Writes writes;
            float windowRatio;
            long delayMillis;
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"not started");
            if (this.compaction != null && (delayMillis = this.calculateCompactionPressureDelay(windowRatio = this.modsFileLength <= (long)this.compactLowWater ? 0.0f : (this.modsFileLength >= (long)this.compactHighWater ? 1.0f : (float)(this.modsFileLength - (long)this.compactLowWater) / (float)(this.compactHighWater - this.compactLowWater)))) >= 0L) {
                if (this.compaction.getDelay() > 0L) {
                    this.scheduleCompaction(0L);
                }
                long delayNanos = TimeUnit.MILLISECONDS.toNanos(delayMillis);
                long waitStart = 0L;
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("reached %d%% of high-water mark; waiting up to %dms for in-progress compaction to complete before applying mutation(s)", (int)(windowRatio * 100.0f), delayMillis));
                    waitStart = System.nanoTime();
                }
                this.compaction.waitForCompletion(delayNanos);
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("compaction completed after %dms, proceeding with application of mutation(s)", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - waitStart)));
                }
                if (this.kvstore == null) {
                    throw new ArrayKVException("k/v store was closed while waiting for compaction to complete");
                }
            }
            if (mutations instanceof Writes) {
                writes = (Writes)mutations;
            } else {
                writes = new Writes();
                writes.setRemoves(new KeyRanges(mutations.getRemoveRanges()));
                for (Map.Entry entry : mutations.getPutPairs()) {
                    writes.getPuts().put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : mutations.getAdjustPairs()) {
                    writes.getAdjusts().put(entry.getKey(), entry.getValue());
                }
            }
            if (writes.isEmpty()) {
                return;
            }
            try {
                BufferedOutputStream buf = new BufferedOutputStream(this.modsFileOutput);
                writes.serialize((OutputStream)buf);
                buf.flush();
            }
            catch (IOException e) {
                try {
                    this.modsFileOutput.getChannel().truncate(this.modsFileLength);
                }
                catch (IOException e2) {
                    this.log.error("error truncating log file (ignoring)", (Throwable)e2);
                }
                throw new ArrayKVException("error appending to " + this.modsFile, e);
            }
            try {
                newModsFileLength = this.modsFileOutput.getChannel().size();
            }
            catch (IOException e) {
                throw new ArrayKVException("error getting length of " + this.modsFile, e);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("appended " + (newModsFileLength - this.modsFileLength) + " bytes to " + this.modsFile + " (new length " + newModsFileLength + ")");
            }
            this.modsFileLength = newModsFileLength;
            for (KeyRange range : mutations.getRemoveRanges()) {
                byte[] min = range.getMin();
                byte[] max = range.getMax();
                this.mods.removeRange(min, max);
            }
            for (Map.Entry entry : mutations.getPutPairs()) {
                byte[] key = (byte[])entry.getKey();
                byte[] val = (byte[])entry.getValue();
                this.mods.put(key, val);
            }
            for (Map.Entry entry : mutations.getAdjustPairs()) {
                byte[] key = (byte[])entry.getKey();
                long adjust = (Long)entry.getValue();
                this.mods.adjustCounter(key, adjust);
            }
            if (this.firstModTimestamp == 0L) {
                this.firstModTimestamp = System.nanoTime() | 1L;
            }
            this.scheduleCompactionIfNecessary();
            if (!sync) {
                return;
            }
            this.modsFileSyncPoint = this.modsFileLength;
            this.readLock.lock();
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.modsFileOutput.getChannel().force(false);
        }
        catch (IOException e) {
            this.log.error("error syncing log file (ignoring)", (Throwable)e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hotCopy(File target) throws IOException {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"null target");
        Path dir = target.toPath();
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("target `" + dir + "' is not a directory");
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            Iterator<Path> i$ = stream.iterator();
            if (i$.hasNext()) {
                Path path = i$.next();
                throw new IllegalArgumentException("target `" + dir + "' is not empty");
            }
        }
        this.writeLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"not started");
            ++this.hotCopiesInProgress;
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            this.log.debug("started hot copy into " + target);
            ArrayList<File> regularCopyFiles = new ArrayList<File>(5);
            for (File file : new File[]{this.indxFile, this.keysFile, this.valsFile}) {
                try {
                    Files.createLink(dir.resolve(file.getName()), file.toPath());
                }
                catch (IOException | UnsupportedOperationException e) {
                    regularCopyFiles.add(file);
                }
            }
            regularCopyFiles.add(this.modsFile);
            regularCopyFiles.add(this.generationFile);
            for (File file : regularCopyFiles) {
                FileOutputStream fileCopy = new FileOutputStream(new File(target, file.getName()));
                Throwable throwable = null;
                try {
                    Files.copy(file.toPath(), fileCopy);
                    fileCopy.getChannel().force(false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileCopy == null) continue;
                    if (throwable != null) {
                        try {
                            fileCopy.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    fileCopy.close();
                }
            }
            try (FileChannel dirChannel = FileChannel.open(dir, new OpenOption[0]);){
                dirChannel.force(false);
            }
            catch (IOException e) {
                if (!this.suckyOS) {
                    throw e;
                }
            }
        }
        finally {
            this.writeLock.lock();
            try {
                assert (this.hotCopiesInProgress > 0);
                assert (this.kvstore != null);
                this.log.debug("completed hot copy into " + target);
                --this.hotCopiesInProgress;
                this.hotCopyFinishedCondition.signalAll();
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    protected long calculateCompactionPressureDelay(float windowRatio) {
        float f;
        windowRatio -= 0.5f;
        if (f < 0.0f) {
            return -1L;
        }
        return (long)(100.0f * (1.0f / (0.5f - windowRatio) - 1.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> scheduleCompaction() {
        this.writeLock.lock();
        try {
            Preconditions.checkState((this.kvstore != null ? 1 : 0) != 0, (Object)"not started");
            if (this.modsFileLength == 0L) {
                Future<?> future = null;
                return future;
            }
            Future<?> future = this.scheduleCompaction(0L);
            return future;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Future<?> scheduleCompaction(long millis) {
        assert (this.lock.isWriteLockedByCurrentThread());
        assert (this.modsFileLength > 0L);
        if (this.compaction == null || this.compaction.getDelay() > millis && this.compaction.cancel()) {
            assert (this.compaction == null);
            this.compaction = new Compaction(millis);
        }
        return new ForwardingFuture.SimpleForwardingFuture<Void>(this.compaction.getFuture()){

            public boolean cancel(boolean mayInterrupt) {
                return false;
            }
        };
    }

    private void scheduleCompactionIfNecessary() {
        assert (this.lock.isWriteLockedByCurrentThread());
        if (this.modsFileLength == 0L) {
            return;
        }
        if (this.modsFileLength > (long)this.compactLowWater) {
            this.scheduleCompaction(0L);
            return;
        }
        if (this.firstModTimestamp != 0L) {
            long firstModAgeMillis = (System.nanoTime() - this.firstModTimestamp) / 1000000L;
            this.scheduleCompaction(firstModAgeMillis);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void compact(Compaction compaction) throws IOException {
        assert (compaction != null);
        this.writeLock.lock();
        try {
            if (compaction != this.compaction) {
                return;
            }
            assert (!compaction.isStarted());
            assert (!compaction.isCompleted());
            compaction.setStarted();
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            boolean success;
            FileOutputStream newModsFileOutput;
            ByteBuffer newVals;
            ByteBuffer newKeys;
            ByteBuffer newIndx;
            File newModsFile;
            File newValsFile;
            File newKeysFile;
            File newIndxFile;
            long newGeneration;
            long previousModsFileSyncPoint;
            long previousModsFileLength;
            Writes writesToCompact;
            long compactionStartTime;
            block218: {
                Throwable throwable;
                this.writeLock.lock();
                try {
                    assert (this.kvstore != null);
                    assert (this.modsFileLength > 0L);
                    compactionStartTime = System.nanoTime();
                    writesToCompact = this.mods.getWrites();
                    if (writesToCompact.isEmpty()) {
                        while (this.hotCopiesInProgress > 0) {
                            this.log.debug("waiting for " + this.hotCopiesInProgress + " hot copies to complete before completing (trivial) compaction");
                            try {
                                this.hotCopyFinishedCondition.await();
                            }
                            catch (InterruptedException e) {
                                throw new ArrayKVException("thread was interrupted while waiting for " + this.hotCopiesInProgress + " hot copies to complete", e);
                            }
                            this.log.debug("hot copies completed, proceeding with completion of (trivial) compaction");
                        }
                        assert (this.kvstore != null);
                        assert (this.modsFileLength > 0L);
                        this.modsFileOutput.getChannel().truncate(0L);
                        this.modsFileLength = 0L;
                        this.modsFileSyncPoint = 0L;
                        this.modsFileOutput.getChannel().force(false);
                        return;
                    }
                    this.mods = new MutableView((KVStore)this.mods, null, new Writes());
                    previousModsFileLength = this.modsFileLength;
                    previousModsFileSyncPoint = this.modsFileSyncPoint;
                }
                finally {
                    this.writeLock.unlock();
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("starting compaction for generation " + this.generation + " -> " + (this.generation + 1L) + " with mods file length " + previousModsFileLength);
                }
                newGeneration = this.generation + 1L;
                newIndxFile = new File(this.directory, INDX_FILE_NAME_BASE + newGeneration);
                newKeysFile = new File(this.directory, KEYS_FILE_NAME_BASE + newGeneration);
                newValsFile = new File(this.directory, VALS_FILE_NAME_BASE + newGeneration);
                newModsFile = new File(this.directory, MODS_FILE_NAME_BASE + newGeneration);
                newIndx = null;
                newKeys = null;
                newVals = null;
                newModsFileOutput = null;
                success = false;
                try (FileOutputStream indxOutput = new FileOutputStream(newIndxFile);
                     FileOutputStream keysOutput = new FileOutputStream(newKeysFile);
                     FileOutputStream valsOutput = new FileOutputStream(newValsFile);){
                    throwable = null;
                    try (ArrayKVWriter arrayWriter = new ArrayKVWriter(indxOutput, keysOutput, valsOutput);){
                        arrayWriter.writeMerged((KVStore)this.kvstore, this.kvstore.getRange(null, null, false), (Mutations)writesToCompact);
                        arrayWriter.flush();
                        valsOutput.getChannel().force(false);
                        keysOutput.getChannel().force(false);
                        indxOutput.getChannel().force(false);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                }
                assert (newIndxFile.exists());
                assert (newKeysFile.exists());
                assert (newValsFile.exists());
                var21_24 = null;
                try (FileInputStream input = new FileInputStream(newIndxFile);){
                    newIndx = AtomicArrayKVStore.getBuffer(newIndxFile, input.getChannel());
                }
                catch (Throwable x2) {
                    var21_24 = x2;
                    throw x2;
                }
                input = new FileInputStream(newKeysFile);
                var21_24 = null;
                try {
                    newKeys = AtomicArrayKVStore.getBuffer(newKeysFile, input.getChannel());
                }
                catch (Throwable x2) {
                    var21_24 = x2;
                    throw x2;
                }
                finally {
                    if (input != null) {
                        if (var21_24 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable x2) {
                                var21_24.addSuppressed(x2);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
                input = new FileInputStream(newValsFile);
                var21_24 = null;
                try {
                    newVals = AtomicArrayKVStore.getBuffer(newValsFile, input.getChannel());
                }
                catch (Throwable x2) {
                    var21_24 = x2;
                    throw x2;
                }
                finally {
                    if (input != null) {
                        if (var21_24 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable x2) {
                                var21_24.addSuppressed(x2);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
                newModsFileOutput = new FileOutputStream(newModsFile, true);
                assert (newModsFile.exists());
                if (this.directoryChannel != null) {
                    this.directoryChannel.force(false);
                }
                success = true;
                this.writeLock.lock();
                try {
                    long newModsFileLength;
                    if (!success) break block218;
                    success = false;
                    long additionalModsLength = this.modsFileLength - previousModsFileLength;
                    if (this.log.isDebugEnabled()) {
                        float duration = (float)(System.nanoTime() - compactionStartTime) / 1.0E9f;
                        this.log.debug("compaction for generation " + this.generation + " -> " + (this.generation + 1L) + " finishing up with " + additionalModsLength + " bytes of new modifications after " + String.format("%.4f", Float.valueOf(duration)) + " seconds");
                    }
                    while (this.hotCopiesInProgress > 0) {
                        this.log.debug("waiting for " + this.hotCopiesInProgress + " hot copies to complete before completing compaction");
                        try {
                            this.hotCopyFinishedCondition.await();
                        }
                        catch (InterruptedException e) {
                            throw new ArrayKVException("thread was interrupted while waiting for " + this.hotCopiesInProgress + " hot copies to complete", e);
                        }
                        assert (this.compaction == compaction);
                        assert (this.kvstore != null);
                        this.log.debug("hot copies completed, proceeding with completion of compaction");
                    }
                    long newModsFileSyncPoint = 0L;
                    if (additionalModsLength > 0L) {
                        throwable = null;
                        try (FileChannel modsFileChannel = FileChannel.open(this.modsFile.toPath(), StandardOpenOption.READ);){
                            long transferred;
                            FileChannel newModsFileChannel = newModsFileOutput.getChannel();
                            for (newModsFileLength = 0L; newModsFileLength < additionalModsLength; newModsFileLength += transferred) {
                                transferred = modsFileChannel.transferTo(previousModsFileLength + newModsFileLength, additionalModsLength - newModsFileLength, newModsFileChannel);
                                assert (transferred > 0L);
                            }
                            if (this.modsFileSyncPoint > previousModsFileSyncPoint) {
                                newModsFileChannel.force(false);
                                newModsFileSyncPoint = newModsFileLength;
                            }
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                    }
                    Object genOutput = !this.suckyOS ? new AtomicUpdateFileOutputStream(this.generationFile) : new FileOutputStream(this.generationFile);
                    boolean genSuccess = false;
                    try {
                        ((FileOutputStream)genOutput).write((newGeneration + "\n").getBytes(StandardCharsets.UTF_8));
                        ((OutputStream)genOutput).flush();
                        ((FileOutputStream)genOutput).getChannel().force(false);
                        genSuccess = true;
                    }
                    finally {
                        if (genSuccess) {
                            ((FileOutputStream)genOutput).close();
                        } else if (genOutput instanceof AtomicUpdateFileOutputStream) {
                            ((AtomicUpdateFileOutputStream)genOutput).cancel();
                        }
                    }
                    success = true;
                    File oldIndxFile = this.indxFile;
                    File oldKeysFile = this.keysFile;
                    File oldValsFile = this.valsFile;
                    File oldModsFile = this.modsFile;
                    FileOutputStream oldModsFileOutput = this.modsFileOutput;
                    this.generation = newGeneration;
                    this.indx = newIndx;
                    this.keys = newKeys;
                    this.vals = newVals;
                    this.indxFile = newIndxFile;
                    this.keysFile = newKeysFile;
                    this.valsFile = newValsFile;
                    this.modsFile = newModsFile;
                    this.modsFileOutput = newModsFileOutput;
                    newModsFileOutput = null;
                    this.modsFileLength = newModsFileLength;
                    this.modsFileSyncPoint = newModsFileSyncPoint;
                    this.kvstore = new ArrayKVStore(this.indx, this.keys, this.vals);
                    this.mods = new MutableView((KVStore)this.kvstore, null, this.mods.getWrites());
                    if (this.directoryChannel != null) {
                        try {
                            this.directoryChannel.force(false);
                        }
                        catch (IOException e) {
                            this.log.error("error syncing directory " + this.directory + " (ignoring)", (Throwable)e);
                        }
                    }
                    this.closeIgnoreException(oldModsFileOutput);
                    this.deleteWarnException(oldIndxFile);
                    this.deleteWarnException(oldKeysFile);
                    this.deleteWarnException(oldValsFile);
                    this.deleteWarnException(oldModsFile);
                }
                catch (Throwable throwable2) {
                    try {
                        if (this.log.isDebugEnabled()) {
                            float duration = (float)(System.nanoTime() - compactionStartTime) / 1.0E9f;
                            this.log.debug("compaction for generation " + (newGeneration - 1L) + " -> " + newGeneration + (success ? " succeeded" : " failed") + " in " + String.format("%.4f", Float.valueOf(duration)) + " seconds");
                        }
                        if (newModsFileOutput != null) {
                            this.closeIgnoreException(newModsFileOutput);
                            this.deleteWarnException(newModsFile);
                        }
                        if (success) throw throwable2;
                        Writes writesDuringCompaction = this.mods.getWrites();
                        this.mods = new MutableView((KVStore)this.kvstore, null, writesToCompact);
                        writesDuringCompaction.applyTo((KVStore)this.mods);
                        this.deleteWarnException(newIndxFile);
                        this.deleteWarnException(newKeysFile);
                        this.deleteWarnException(newValsFile);
                        throw throwable2;
                    }
                    finally {
                        this.writeLock.unlock();
                    }
                }
            }
            try {
                if (this.log.isDebugEnabled()) {
                    float duration = (float)(System.nanoTime() - compactionStartTime) / 1.0E9f;
                    this.log.debug("compaction for generation " + (newGeneration - 1L) + " -> " + newGeneration + (success ? " succeeded" : " failed") + " in " + String.format("%.4f", Float.valueOf(duration)) + " seconds");
                }
                if (newModsFileOutput != null) {
                    this.closeIgnoreException(newModsFileOutput);
                    this.deleteWarnException(newModsFile);
                }
                if (success) return;
                Writes writesDuringCompaction = this.mods.getWrites();
                this.mods = new MutableView((KVStore)this.kvstore, null, writesToCompact);
                writesDuringCompaction.applyTo((KVStore)this.mods);
                this.deleteWarnException(newIndxFile);
                this.deleteWarnException(newKeysFile);
                this.deleteWarnException(newValsFile);
                return;
            }
            finally {
                this.writeLock.unlock();
            }
            catch (Throwable throwable) {
                block221: {
                    this.writeLock.lock();
                    try {
                        long newModsFileLength;
                        if (!success) break block221;
                        success = false;
                        long additionalModsLength = this.modsFileLength - previousModsFileLength;
                        if (this.log.isDebugEnabled()) {
                            float duration = (float)(System.nanoTime() - compactionStartTime) / 1.0E9f;
                            this.log.debug("compaction for generation " + this.generation + " -> " + (this.generation + 1L) + " finishing up with " + additionalModsLength + " bytes of new modifications after " + String.format("%.4f", Float.valueOf(duration)) + " seconds");
                        }
                        while (this.hotCopiesInProgress > 0) {
                            this.log.debug("waiting for " + this.hotCopiesInProgress + " hot copies to complete before completing compaction");
                            try {
                                this.hotCopyFinishedCondition.await();
                            }
                            catch (InterruptedException e) {
                                throw new ArrayKVException("thread was interrupted while waiting for " + this.hotCopiesInProgress + " hot copies to complete", e);
                            }
                            assert (this.compaction == compaction);
                            assert (this.kvstore != null);
                            this.log.debug("hot copies completed, proceeding with completion of compaction");
                        }
                        long newModsFileSyncPoint = 0L;
                        if (additionalModsLength > 0L) {
                            try (FileChannel modsFileChannel = FileChannel.open(this.modsFile.toPath(), StandardOpenOption.READ);){
                                long transferred;
                                FileChannel newModsFileChannel = newModsFileOutput.getChannel();
                                for (newModsFileLength = 0L; newModsFileLength < additionalModsLength; newModsFileLength += transferred) {
                                    transferred = modsFileChannel.transferTo(previousModsFileLength + newModsFileLength, additionalModsLength - newModsFileLength, newModsFileChannel);
                                    assert (transferred > 0L);
                                }
                                if (this.modsFileSyncPoint > previousModsFileSyncPoint) {
                                    newModsFileChannel.force(false);
                                    newModsFileSyncPoint = newModsFileLength;
                                }
                            }
                        }
                        Object genOutput = !this.suckyOS ? new AtomicUpdateFileOutputStream(this.generationFile) : new FileOutputStream(this.generationFile);
                        boolean genSuccess = false;
                        try {
                            ((FileOutputStream)genOutput).write((newGeneration + "\n").getBytes(StandardCharsets.UTF_8));
                            ((OutputStream)genOutput).flush();
                            ((FileOutputStream)genOutput).getChannel().force(false);
                            genSuccess = true;
                        }
                        finally {
                            if (genSuccess) {
                                ((FileOutputStream)genOutput).close();
                            } else if (genOutput instanceof AtomicUpdateFileOutputStream) {
                                ((AtomicUpdateFileOutputStream)genOutput).cancel();
                            }
                        }
                        success = true;
                        File oldIndxFile = this.indxFile;
                        File oldKeysFile = this.keysFile;
                        File oldValsFile = this.valsFile;
                        File oldModsFile = this.modsFile;
                        FileOutputStream oldModsFileOutput = this.modsFileOutput;
                        this.generation = newGeneration;
                        this.indx = newIndx;
                        this.keys = newKeys;
                        this.vals = newVals;
                        this.indxFile = newIndxFile;
                        this.keysFile = newKeysFile;
                        this.valsFile = newValsFile;
                        this.modsFile = newModsFile;
                        this.modsFileOutput = newModsFileOutput;
                        newModsFileOutput = null;
                        this.modsFileLength = newModsFileLength;
                        this.modsFileSyncPoint = newModsFileSyncPoint;
                        this.kvstore = new ArrayKVStore(this.indx, this.keys, this.vals);
                        this.mods = new MutableView((KVStore)this.kvstore, null, this.mods.getWrites());
                        if (this.directoryChannel != null) {
                            try {
                                this.directoryChannel.force(false);
                            }
                            catch (IOException e) {
                                this.log.error("error syncing directory " + this.directory + " (ignoring)", (Throwable)e);
                            }
                        }
                        this.closeIgnoreException(oldModsFileOutput);
                        this.deleteWarnException(oldIndxFile);
                        this.deleteWarnException(oldKeysFile);
                        this.deleteWarnException(oldValsFile);
                        this.deleteWarnException(oldModsFile);
                    }
                    catch (Throwable throwable3) {
                        try {
                            if (this.log.isDebugEnabled()) {
                                float duration = (float)(System.nanoTime() - compactionStartTime) / 1.0E9f;
                                this.log.debug("compaction for generation " + (newGeneration - 1L) + " -> " + newGeneration + (success ? " succeeded" : " failed") + " in " + String.format("%.4f", Float.valueOf(duration)) + " seconds");
                            }
                            if (newModsFileOutput != null) {
                                this.closeIgnoreException(newModsFileOutput);
                                this.deleteWarnException(newModsFile);
                            }
                            if (success) throw throwable3;
                            Writes writesDuringCompaction = this.mods.getWrites();
                            this.mods = new MutableView((KVStore)this.kvstore, null, writesToCompact);
                            writesDuringCompaction.applyTo((KVStore)this.mods);
                            this.deleteWarnException(newIndxFile);
                            this.deleteWarnException(newKeysFile);
                            this.deleteWarnException(newValsFile);
                            throw throwable3;
                        }
                        finally {
                            this.writeLock.unlock();
                        }
                    }
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        float duration = (float)(System.nanoTime() - compactionStartTime) / 1.0E9f;
                        this.log.debug("compaction for generation " + (newGeneration - 1L) + " -> " + newGeneration + (success ? " succeeded" : " failed") + " in " + String.format("%.4f", Float.valueOf(duration)) + " seconds");
                    }
                    if (newModsFileOutput != null) {
                        this.closeIgnoreException(newModsFileOutput);
                        this.deleteWarnException(newModsFile);
                    }
                    if (success) throw throwable;
                    Writes writesDuringCompaction = this.mods.getWrites();
                    this.mods = new MutableView((KVStore)this.kvstore, null, writesToCompact);
                    writesDuringCompaction.applyTo((KVStore)this.mods);
                    this.deleteWarnException(newIndxFile);
                    this.deleteWarnException(newKeysFile);
                    this.deleteWarnException(newValsFile);
                    throw throwable;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
        }
        finally {
            this.writeLock.lock();
            try {
                assert (this.kvstore != null);
                assert (this.compaction == compaction);
                compaction.setCompleted();
                this.compaction = null;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH).indexOf("win") != -1;
    }

    private void deleteWarnException(File file) {
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            this.log.warn("error deleting " + file + " (proceeding anyway): " + e);
        }
    }

    private void closeIgnoreException(Closeable resource) {
        try {
            resource.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.kvstore != null) {
                this.log.warn((Object)((Object)this) + " leaked without invoking stop()");
            }
            this.stop();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.directory + "]";
    }

    private static ByteBuffer getBuffer(File file, FileChannel fileChannel) throws IOException {
        long length = fileChannel.size();
        return length >= 0x100000L ? fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, length) : ByteBuffer.wrap(Files.readAllBytes(file.toPath())).asReadOnlyBuffer();
    }

    private class Compaction
    implements Runnable {
        private final Condition completedCondition;
        private final ScheduledFuture<Void> future;
        private boolean started;
        private boolean completed;

        Compaction(long millis) {
            this.completedCondition = AtomicArrayKVStore.this.writeLock.newCondition();
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            Preconditions.checkState((AtomicArrayKVStore.this.compaction == null ? 1 : 0) != 0, (Object)"compaction already exists");
            this.future = AtomicArrayKVStore.this.scheduledExecutorService.schedule(this, millis, TimeUnit.MILLISECONDS);
        }

        public boolean cancel() {
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            Preconditions.checkState((this.future != null ? 1 : 0) != 0, (Object)"not scheduled");
            if (AtomicArrayKVStore.this.compaction != this) {
                return false;
            }
            if (this.started) {
                return false;
            }
            assert (this.future != null);
            this.future.cancel(false);
            AtomicArrayKVStore.this.compaction = null;
            return true;
        }

        public long getDelay() {
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            Preconditions.checkState((this.future != null ? 1 : 0) != 0, (Object)"not scheduled");
            return Math.max(0L, this.future.getDelay(TimeUnit.MILLISECONDS));
        }

        public boolean waitForCompletion(long nanos) {
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            boolean interrupted = false;
            while (!this.completed) {
                try {
                    if (nanos > 0L) {
                        if ((nanos = this.completedCondition.awaitNanos(nanos)) > 0L) continue;
                        break;
                    }
                    this.completedCondition.await();
                }
                catch (InterruptedException e) {
                    AtomicArrayKVStore.this.log.warn("thread was interrupted while waiting for compaction to complete (ignoring)", (Throwable)e);
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return this.completed;
        }

        public Future<Void> getFuture() {
            return this.future;
        }

        public boolean isStarted() {
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            return this.started;
        }

        public void setStarted() {
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            this.started = true;
        }

        public boolean isCompleted() {
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            return this.completed;
        }

        public void setCompleted() {
            assert (AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            this.completed = true;
            this.completedCondition.signalAll();
        }

        @Override
        public void run() {
            assert (!AtomicArrayKVStore.this.lock.isWriteLockedByCurrentThread());
            try {
                AtomicArrayKVStore.this.compact(this);
            }
            catch (Throwable t) {
                AtomicArrayKVStore.this.log.error("error during compaction", t);
            }
        }
    }
}

