/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.array;

import java.io.File;
import java.util.ArrayDeque;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.array.ArrayKVDatabase;
import org.jsimpledb.kv.array.AtomicArrayKVStore;
import org.jsimpledb.kv.mvcc.AtomicKVStore;

public class ArrayKVImplementation
extends KVImplementation {
    public String[][] getCommandLineOptions() {
        return new String[][]{{"--arraydb dir", "Use array key/value database in the specified directory"}};
    }

    public File parseCommandLineOptions(ArrayDeque<String> options) {
        String arg = this.parseCommandLineOption(options, "--arraydb");
        return arg != null ? new File(arg) : null;
    }

    public ArrayKVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        ArrayKVDatabase arraydb = new ArrayKVDatabase();
        arraydb.setKVStore(this.createAtomicKVStore(configuration));
        return arraydb;
    }

    public AtomicArrayKVStore createAtomicKVStore(Object configuration) {
        AtomicArrayKVStore kvstore = new AtomicArrayKVStore();
        kvstore.setDirectory((File)configuration);
        return kvstore;
    }

    public String getDescription(Object configuration) {
        return "ArrayDB " + ((File)configuration).getName();
    }
}

