/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.mssql.MSSQLKVTransaction;
import org.jsimpledb.kv.sql.SQLKVDatabase;
import org.jsimpledb.kv.sql.SQLKVTransaction;

public class MSSQLKVDatabase
extends SQLKVDatabase {
    public static final String DEFAULT_SCHEMA = "dbo";
    public static final boolean DEFAULT_LARGE_KEYS = false;
    public static final boolean DEFAULT_LARGE_VALUES = true;
    public static final int DEFAULT_LOCK_TIMEOUT = 3000;
    private static final int MAX_SMALL_VARBINARY = 8000;
    private boolean largeKeys = false;
    private boolean largeValues = true;
    private int lockTimeout = 3000;
    private String schema = "dbo";

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public boolean isLargeKeys() {
        return this.largeKeys;
    }

    public void setLargeKeys(boolean largeKeys) {
        this.largeKeys = largeKeys;
    }

    public boolean isLargeValues() {
        return this.largeValues;
    }

    public void setLargeValues(boolean largeValues) {
        this.largeValues = largeValues;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    protected void initializeDatabaseIfNecessary(Connection connection) throws SQLException {
        String keySize = this.largeKeys ? "max" : "8000";
        String valSize = this.largeValues ? "max" : "8000";
        String sql = "if not exists (select * from sys.tables t\n   join sys.schemas s on (t.schema_id = s.schema_id)\n   where s.name = " + this.quoteString(this.schema) + "\n     and t.name = " + this.quoteString(this.getTableName()) + ")\ncreate table " + this.getTableName() + " (\n  " + this.getKeyColumnName() + " VARBINARY(" + keySize + ") NOT NULL PRIMARY KEY,\n  " + this.getValueColumnName() + " VARBINARY(" + valSize + ") NOT NULL\n)\n";
        try (Statement statement = connection.createStatement();){
            this.log.debug("auto-creating table `" + this.getTableName() + "' if not already existing:\n{}", (Object)sql);
            statement.execute(sql);
        }
    }

    protected void configureConnection(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.execute("SET LOCK_TIMEOUT " + this.lockTimeout);
        }
    }

    protected SQLKVTransaction createSQLKVTransaction(Connection connection) throws SQLException {
        return new MSSQLKVTransaction(this, connection);
    }

    public String createPutStatement() {
        String tn = this.quote(this.tableName);
        String kc = this.quote(this.keyColumnName);
        String vc = this.quote(this.valueColumnName);
        return "merge " + tn + " with(HOLDLOCK) as target\n  using (values (?))\n  as source (" + vc + ")\n  on target." + kc + " = ?\nwhen matched then\n  update set " + vc + " = source." + vc + "\nwhen not matched then\n  insert (" + kc + ", " + vc + ")\n  values (?, ?);";
    }

    protected String quoteString(String value) {
        return "'" + value.replaceAll("'", "''") + "'";
    }

    public String limitSingleRow(String sql) {
        return sql.replaceAll("(?i)^SELECT ", "SELECT TOP 1 ");
    }

    public KVTransactionException wrapException(SQLKVTransaction tx, SQLException e) {
        switch (e.getErrorCode()) {
            case 1205: 
            case 1222: 
            case 8645: {
                return new RetryTransactionException((KVTransaction)tx, (Throwable)e);
            }
        }
        return super.wrapException(tx, e);
    }
}

