/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.mssql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jsimpledb.kv.sql.SQLKVDatabase;
import org.jsimpledb.kv.sql.SQLKVTransaction;
import org.jsimpledb.util.ByteUtil;

class MSSQLKVTransaction
extends SQLKVTransaction {
    MSSQLKVTransaction(SQLKVDatabase database, Connection connection) throws SQLException {
        super(database, connection);
    }

    public void setTimeout(long timeout) {
        super.setTimeout(timeout);
        try (Statement statement = this.connection.createStatement();){
            statement.execute("SET LOCK_TIMEOUT " + timeout);
        }
        catch (SQLException e) {
            throw this.handleException(e);
        }
    }

    protected void update(SQLKVTransaction.StmtType stmtType, byte[] ... params) {
        if (SQLKVTransaction.StmtType.PUT.equals((Object)stmtType)) {
            byte[][] swizzledParams = new byte[][]{params[1], params[0], params[0], params[1]};
            params = swizzledParams;
        }
        super.update(stmtType, params);
    }

    protected byte[] encodeKey(byte[] key) {
        int keyLength = key.length;
        int dbkeyLength = key.length;
        for (int i = 0; i < keyLength; ++i) {
            if ((key[i] & 0xFE) != 0) continue;
            ++dbkeyLength;
        }
        if (dbkeyLength == keyLength) {
            return key;
        }
        byte[] dbkey = new byte[dbkeyLength];
        int j = 0;
        for (int i = 0; i < keyLength; ++i) {
            byte b = key[i];
            if ((b & 0xFE) == 0) {
                dbkey[j++] = 1;
                b = (byte)(b + 1);
            }
            dbkey[j++] = b;
        }
        assert (j == dbkeyLength);
        return dbkey;
    }

    protected byte[] decodeKey(byte[] dbkey) {
        int keyLength = dbkey.length;
        block4: for (int i = 0; i < dbkey.length; ++i) {
            switch (dbkey[i]) {
                case 0: {
                    throw new RuntimeException(String.format("read invalid key [%s]: zero byte at offset %d", ByteUtil.toString((byte[])dbkey), i));
                }
                case 1: {
                    if (++i == dbkey.length || dbkey[i] != 1 && dbkey[i] != 2) {
                        throw new RuntimeException(String.format("read invalid key [%s]: invalid escape sequence at offset %d", ByteUtil.toString((byte[])dbkey), i - 1));
                    }
                    --keyLength;
                    continue block4;
                }
            }
        }
        if (keyLength == dbkey.length) {
            return dbkey;
        }
        byte[] key = new byte[keyLength];
        int j = 0;
        int i = 0;
        while (i < dbkey.length) {
            if (dbkey[i] != 1) {
                key[j] = dbkey[i];
            } else if (dbkey[++i] == 2) {
                key[j] = 1;
            }
            ++i;
            ++j;
        }
        assert (j == key.length);
        return key;
    }
}

