/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.spanner;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class Access {
    public static final Method TRANSACTION_CONTEXT_COMMIT_METHOD;
    public static final Method TRANSACTION_CONTEXT_ROLLBACK_METHOD;
    public static final Method TRANSACTION_CONTEXT_ENSURE_TXN_METHOD;
    public static final Method TRANSACTION_CONTEXT_COMMIT_TIMESTAMP_METHOD;
    public static final Field POOLED_SESSION_1_RUNNER_FIELD;
    public static final Field TRANSACTION_RUNNER_TXN_FIELD;

    private Access() {
    }

    static Object invoke(Method method, Object instance, Object ... params) {
        try {
            return method.invoke(instance, params);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static Object read(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> tc = Class.forName("com.google.cloud.spanner.SpannerImpl$TransactionContextImpl", false, loader);
            TRANSACTION_CONTEXT_COMMIT_METHOD = tc.getDeclaredMethod("commit", new Class[0]);
            TRANSACTION_CONTEXT_COMMIT_METHOD.setAccessible(true);
            TRANSACTION_CONTEXT_ROLLBACK_METHOD = tc.getDeclaredMethod("rollback", new Class[0]);
            TRANSACTION_CONTEXT_ROLLBACK_METHOD.setAccessible(true);
            TRANSACTION_CONTEXT_ENSURE_TXN_METHOD = tc.getDeclaredMethod("ensureTxn", new Class[0]);
            TRANSACTION_CONTEXT_ENSURE_TXN_METHOD.setAccessible(true);
            TRANSACTION_CONTEXT_COMMIT_TIMESTAMP_METHOD = tc.getDeclaredMethod("commitTimestamp", new Class[0]);
            TRANSACTION_CONTEXT_COMMIT_TIMESTAMP_METHOD.setAccessible(true);
            Class<?> tr = Class.forName("com.google.cloud.spanner.SpannerImpl$TransactionRunnerImpl", false, loader);
            TRANSACTION_RUNNER_TXN_FIELD = tr.getDeclaredField("txn");
            TRANSACTION_RUNNER_TXN_FIELD.setAccessible(true);
            Class<?> ps1 = Class.forName("com.google.cloud.spanner.SessionPool$PooledSession$1", false, loader);
            POOLED_SESSION_1_RUNNER_FIELD = ps1.getDeclaredField("val$runner");
            POOLED_SESSION_1_RUNNER_FIELD.setAccessible(true);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

