/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.jsimpledb.kv.CloseableKVStore;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.mvcc.MutableView;
import org.jsimpledb.kv.mvcc.Writes;
import org.jsimpledb.kv.spanner.ReadOnlySpannerView;
import org.jsimpledb.kv.util.BatchingKVStore;
import org.jsimpledb.util.ByteReader;
import org.jsimpledb.util.ByteUtil;
import org.jsimpledb.util.ByteWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteSpannerView
extends MutableView
implements CloseableKVStore {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String tableName;
    protected final Function<? super SpannerException, RuntimeException> exceptionMapper;

    public ReadWriteSpannerView(String tableName, ReadContext context, Function<? super SpannerException, RuntimeException> exceptionMapper) {
        this(tableName, (KVStore)new ReadOnlySpannerView(tableName, context, exceptionMapper), exceptionMapper);
    }

    public ReadWriteSpannerView(String tableName, ReadContext context, Function<? super SpannerException, RuntimeException> exceptionMapper, ExecutorService executor, int rttEstimate) {
        this(tableName, (KVStore)new BatchingKVStore((CloseableKVStore)new ReadOnlySpannerView(tableName, context, exceptionMapper), executor, rttEstimate), null);
    }

    private ReadWriteSpannerView(String tableName, KVStore view, Function<? super SpannerException, RuntimeException> exceptionMapper) {
        super(view, null, new Writes());
        this.tableName = tableName;
        this.exceptionMapper = exceptionMapper;
    }

    public synchronized void bufferMutations(TransactionContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0);
        Writes writes = this.getWrites();
        if (this.log.isTraceEnabled()) {
            this.log.trace("applying " + writes + " to " + context);
        }
        for (KeyRange range : writes.getRemoves()) {
            byte[] rangeMax = range.getMax();
            Key minKey = Key.of((Object[])new Object[]{ByteArray.copyFrom((byte[])range.getMin())});
            this.buffer(context, Mutation.delete((String)this.tableName, (KeySet)(rangeMax != null ? KeySet.range((com.google.cloud.spanner.KeyRange)com.google.cloud.spanner.KeyRange.closedOpen((Key)minKey, (Key)Key.of((Object[])new Object[]{ByteArray.copyFrom((byte[])rangeMax)}))) : KeySet.range((com.google.cloud.spanner.KeyRange)com.google.cloud.spanner.KeyRange.closedClosed((Key)minKey, (Key)Key.of((Object[])new Object[0]))))));
        }
        for (Map.Entry put : writes.getPuts().entrySet()) {
            this.buffer(context, ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newReplaceBuilder((String)this.tableName).set("key").to(ByteArray.copyFrom((byte[])((byte[])put.getKey())))).set("val").to(ByteArray.copyFrom((byte[])((byte[])put.getValue())))).build());
        }
        for (Map.Entry adjust : writes.getAdjusts().entrySet()) {
            byte[] data;
            ByteArray key = ByteArray.copyFrom((byte[])((byte[])adjust.getKey()));
            Struct row = context.readRow(this.tableName, Key.of((Object[])new Object[]{key}), Collections.singleton("val"));
            if (row == null || (data = row.getBytes(0).toByteArray()).length != 8) continue;
            long adjustedValue = ByteUtil.readLong((ByteReader)new ByteReader(data)) + (Long)adjust.getValue();
            ByteWriter writer = new ByteWriter(8);
            ByteUtil.writeLong((ByteWriter)writer, (long)adjustedValue);
            this.buffer(context, ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newReplaceBuilder((String)this.tableName).set("key").to(key)).set("val").to(ByteArray.copyFrom((byte[])writer.getBytes()))).build());
        }
        writes.clear();
    }

    private void buffer(TransactionContext context, Mutation mutation) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("adding mutation " + mutation);
        }
        context.buffer(mutation);
    }

    public ReadWriteSpannerView clone() {
        return (ReadWriteSpannerView)super.clone();
    }

    public void close() {
        ((CloseableKVStore)this.getKVStore()).close();
    }
}

