/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.spanner;

import com.google.cloud.spanner.SpannerOptions;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVImplementation;
import org.jsimpledb.kv.mvcc.AtomicKVStore;
import org.jsimpledb.kv.spanner.SpannerKVDatabase;

public class SpannerKVImplementation
extends KVImplementation {
    public String[][] getCommandLineOptions() {
        return new String[][]{{"--spanner id", "Specify Google Cloud Spanner instance ID"}, {"--spanner-project id", "Specify Google Cloud Spanner project ID"}, {"--spanner-database id", "Specify Google Cloud Spanner database ID (default `jsimpledb')"}, {"--spanner-table name", "Specify Google Cloud Spanner table name (default `KV')"}};
    }

    public Config parseCommandLineOptions(ArrayDeque<String> options) {
        Config config = new Config();
        config.setInstanceId(this.parseCommandLineOption(options, "--spanner"));
        config.setProjectId(this.parseCommandLineOption(options, "--spanner-project"));
        config.setDatabaseId(this.parseCommandLineOption(options, "--spanner-database"));
        config.setTableName(this.parseCommandLineOption(options, "--spanner-table"));
        return !config.isEmpty() ? config : null;
    }

    public SpannerKVDatabase createKVDatabase(Object configuration, KVDatabase kvdb, AtomicKVStore kvstore) {
        Config config = (Config)configuration;
        SpannerKVDatabase spannerKV = new SpannerKVDatabase();
        config.configure(spannerKV);
        return spannerKV;
    }

    public String getDescription(Object configuration) {
        Config config = (Config)configuration;
        return "Spanner " + config.getInstanceId();
    }

    private static class Config {
        private String projectId;
        private String instanceId;
        private String databaseId;
        private String tableName;

        private Config() {
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getDatabaseId() {
            return this.databaseId;
        }

        public void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public boolean isEmpty() {
            return this.projectId == null && this.instanceId == null && this.databaseId == null && this.tableName == null;
        }

        public void configure(SpannerKVDatabase kvdb) {
            Preconditions.checkArgument((this.instanceId != null ? 1 : 0) != 0, (Object)"Spanner instance ID must be specified via the `--spanner' flag");
            SpannerOptions.Builder builder = SpannerOptions.newBuilder();
            if (this.projectId != null) {
                builder.setProjectId(this.projectId);
            }
            kvdb.setSpannerOptions(builder.build());
            kvdb.setInstanceId(this.instanceId);
            if (this.databaseId != null) {
                kvdb.setDatabaseId(this.databaseId);
            }
            if (this.tableName != null) {
                kvdb.setTableName(this.tableName);
            }
        }
    }
}

