/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb.kv.sql;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientException;
import java.util.Map;
import javax.sql.DataSource;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVDatabaseException;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KVTransactionException;
import org.jsimpledb.kv.RetryTransactionException;
import org.jsimpledb.kv.TransactionTimeoutException;
import org.jsimpledb.kv.sql.IsolationLevel;
import org.jsimpledb.kv.sql.SQLKVTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLKVDatabase
implements KVDatabase {
    public static final String DEFAULT_TABLE_NAME = "KV";
    public static final String DEFAULT_KEY_COLUMN_NAME = "kv_key";
    public static final String DEFAULT_VALUE_COLUMN_NAME = "kv_value";
    public static final String OPTION_ISOLATION = "isolation";
    protected DataSource dataSource;
    protected String tableName = "KV";
    protected String keyColumnName = "kv_key";
    protected String valueColumnName = "kv_value";
    protected IsolationLevel isolationLevel = IsolationLevel.SERIALIZABLE;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    volatile boolean rollbackForReadOnly = true;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"null tableName");
        this.tableName = tableName;
    }

    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    public void setKeyColumnName(String keyColumnName) {
        Preconditions.checkArgument((keyColumnName != null ? 1 : 0) != 0, (Object)"null keyColumnName");
        this.keyColumnName = keyColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        Preconditions.checkArgument((valueColumnName != null ? 1 : 0) != 0, (Object)"null valueColumnName");
        this.valueColumnName = valueColumnName;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        Preconditions.checkArgument((isolationLevel != null ? 1 : 0) != 0, (Object)"null isolationLevel");
        this.isolationLevel = isolationLevel;
    }

    public boolean isRollbackForReadOnly() {
        return this.rollbackForReadOnly;
    }

    public void setRollbackForReadOnly(boolean rollbackForReadOnly) {
        this.rollbackForReadOnly = rollbackForReadOnly;
    }

    public void start() {
        try (Connection connection = this.createTransactionConnection();){
            this.initializeDatabaseIfNecessary(connection);
        }
        catch (SQLException e) {
            throw new KVDatabaseException((KVDatabase)this, (Throwable)e);
        }
    }

    public void stop() {
    }

    protected void initializeDatabaseIfNecessary(Connection connection) throws SQLException {
    }

    public SQLKVTransaction createTransaction(Map<String, ?> options) {
        SQLKVTransaction tx;
        Preconditions.checkState((this.dataSource != null ? 1 : 0) != 0, (Object)"no DataSource configured");
        IsolationLevel txIsolationLevel = options != null ? this.getIsolationLevel(options) : this.isolationLevel;
        try {
            Connection connection = this.createTransactionConnection();
            connection.setTransactionIsolation(txIsolationLevel.getConnectionIsolation());
            this.preBeginTransaction(connection);
            this.beginTransaction(connection);
            this.postBeginTransaction(connection);
            tx = this.createSQLKVTransaction(connection);
        }
        catch (SQLException e) {
            throw new KVDatabaseException((KVDatabase)this, (Throwable)e);
        }
        return tx;
    }

    public SQLKVTransaction createTransaction() {
        return this.createTransaction((Map)null);
    }

    protected IsolationLevel getIsolationLevel(Map<String, ?> options) {
        IsolationLevel txIsolationLevel = this.isolationLevel;
        Object isolation = options.get("org.springframework.transaction.annotation.Isolation");
        if (isolation instanceof Enum) {
            isolation = ((Enum)isolation).name();
        }
        if (isolation != null) {
            switch (isolation.toString()) {
                case "DEFAULT": {
                    break;
                }
                default: {
                    txIsolationLevel = IsolationLevel.valueOf(isolation.toString());
                }
            }
        }
        try {
            Object value = options.get(OPTION_ISOLATION);
            if (value instanceof IsolationLevel) {
                txIsolationLevel = (IsolationLevel)((Object)value);
            } else if (value instanceof String) {
                txIsolationLevel = IsolationLevel.valueOf((String)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return txIsolationLevel;
    }

    protected Connection createTransactionConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        this.configureConnection(connection);
        return connection;
    }

    protected void configureConnection(Connection connection) throws SQLException {
    }

    protected void preBeginTransaction(Connection connection) throws SQLException {
    }

    protected void beginTransaction(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    protected void postBeginTransaction(Connection connection) throws SQLException {
    }

    protected SQLKVTransaction createSQLKVTransaction(Connection connection) throws SQLException {
        return new SQLKVTransaction(this, connection);
    }

    public String createGetStatement() {
        return "SELECT " + this.quote(this.valueColumnName) + " FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " = ?";
    }

    public String createGetAtLeastStatement(boolean reverse) {
        return "SELECT " + this.quote(this.keyColumnName) + ", " + this.quote(this.valueColumnName) + " FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " >= ? ORDER BY " + this.quote(this.keyColumnName) + (reverse ? " DESC" : " ASC");
    }

    public String createGetAtMostStatement(boolean reverse) {
        return "SELECT " + this.quote(this.keyColumnName) + ", " + this.quote(this.valueColumnName) + " FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " < ? ORDER BY " + this.quote(this.keyColumnName) + (reverse ? " DESC" : " ASC");
    }

    public String createGetRangeStatement(boolean reverse) {
        return "SELECT " + this.quote(this.keyColumnName) + ", " + this.quote(this.valueColumnName) + " FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " >= ? and " + this.quote(this.keyColumnName) + " < ? ORDER BY " + this.quote(this.keyColumnName) + (reverse ? " DESC" : " ASC");
    }

    public String createGetAllStatement(boolean reverse) {
        return "SELECT " + this.quote(this.keyColumnName) + ", " + this.quote(this.valueColumnName) + " FROM " + this.quote(this.tableName) + " ORDER BY " + this.quote(this.keyColumnName) + (reverse ? " DESC" : " ASC");
    }

    public String createPutStatement() {
        return "INSERT INTO " + this.quote(this.tableName) + " (" + this.quote(this.keyColumnName) + ", " + this.quote(this.valueColumnName) + ") VALUES (?, ?) ON DUPLICATE KEY UPDATE " + this.quote(this.valueColumnName) + " = ?";
    }

    public String createRemoveStatement() {
        return "DELETE FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " = ?";
    }

    public String createRemoveRangeStatement() {
        return "DELETE FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " >= ? AND " + this.quote(this.keyColumnName) + " < ?";
    }

    public String createRemoveAtLeastStatement() {
        return "DELETE FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " >= ?";
    }

    public String createRemoveAtMostStatement() {
        return "DELETE FROM " + this.quote(this.tableName) + " WHERE " + this.quote(this.keyColumnName) + " < ?";
    }

    public String createRemoveAllStatement() {
        return "DELETE FROM " + this.quote(this.tableName);
    }

    public String limitSingleRow(String sql) {
        return sql;
    }

    public String quote(String name) {
        return name;
    }

    public KVTransactionException wrapException(SQLKVTransaction transaction, SQLException e) {
        if (e instanceof SQLTimeoutException) {
            return new TransactionTimeoutException((KVTransaction)transaction, (Throwable)e);
        }
        if (e instanceof SQLRecoverableException) {
            return new RetryTransactionException((KVTransaction)transaction, (Throwable)e);
        }
        if (e instanceof SQLTransientException) {
            return new RetryTransactionException((KVTransaction)transaction, (Throwable)e);
        }
        return new KVTransactionException((KVTransaction)transaction, (Throwable)e);
    }
}

