/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.NavigableMap;
import java.util.NavigableSet;
import org.jsimpledb.NavigableSetConverter;
import org.jsimpledb.Tuple2Converter;
import org.jsimpledb.index.Index;
import org.jsimpledb.tuple.Tuple2;
import org.jsimpledb.util.ConvertedNavigableMap;
import org.jsimpledb.util.ConvertedNavigableSet;

class ConvertedIndex<V, T, WV, WT>
implements Index<V, T> {
    private final Index<WV, WT> index;
    private final Converter<V, WV> valueConverter;
    private final Converter<T, WT> targetConverter;

    ConvertedIndex(Index<WV, WT> index, Converter<V, WV> valueConverter, Converter<T, WT> targetConverter) {
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"null index");
        Preconditions.checkArgument((valueConverter != null ? 1 : 0) != 0, (Object)"null valueConverter");
        Preconditions.checkArgument((targetConverter != null ? 1 : 0) != 0, (Object)"null targetConverter");
        this.index = index;
        this.valueConverter = valueConverter;
        this.targetConverter = targetConverter;
    }

    public NavigableSet<Tuple2<V, T>> asSet() {
        return new ConvertedNavigableSet(this.index.asSet(), new Tuple2Converter<V, T, WV, WT>(this.valueConverter, this.targetConverter));
    }

    public NavigableMap<V, NavigableSet<T>> asMap() {
        return new ConvertedNavigableMap(this.index.asMap(), this.valueConverter, new NavigableSetConverter<T, WT>(this.targetConverter));
    }
}

