/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import org.jsimpledb.core.EnumValue;

public class EnumConverter<T extends Enum<T>>
extends Converter<T, EnumValue> {
    private final Class<T> enumType;
    private final EnumHashBiMap<T, EnumValue> valueMap;

    public EnumConverter(Class<T> enumType) {
        Preconditions.checkArgument((enumType != null ? 1 : 0) != 0, (Object)"null enumType");
        enumType.asSubclass(Enum.class);
        this.enumType = enumType;
        this.valueMap = EnumHashBiMap.create((Map)Maps.asMap(EnumSet.allOf(this.enumType), (Function)new Function<T, EnumValue>(){

            public EnumValue apply(T value) {
                return new EnumValue(value);
            }
        }));
    }

    protected EnumValue doForward(T value) {
        if (value == null) {
            return null;
        }
        EnumValue enumValue = (EnumValue)this.valueMap.get(value);
        if (enumValue == null) {
            throw new IllegalArgumentException("invalid enum value " + value + " not an instance of " + this.enumType);
        }
        return enumValue;
    }

    protected T doBackward(EnumValue enumValue) {
        if (enumValue == null) {
            return null;
        }
        Enum value = (Enum)this.valueMap.inverse().get((Object)enumValue);
        if (value == null) {
            throw new IllegalArgumentException("invalid value " + enumValue + " not found in " + this.enumType);
        }
        return (T)value;
    }

    public Class<T> getEnumType() {
        return this.enumType;
    }

    public static EnumConverter<?> createEnumConverter(Class<? extends Enum<?>> enumType) {
        return new EnumConverter(enumType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        EnumConverter that = (EnumConverter)((Object)obj);
        return this.enumType == that.enumType;
    }

    public int hashCode() {
        return this.enumType.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[type=" + this.enumType.getName() + "]";
    }
}

