/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import java.util.Arrays;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.JSimpleDB;

class IndexInfoKey {
    private final Class<?>[] types;
    private final boolean composite;
    private final String name;

    IndexInfoKey(String name, boolean composite, Class<?> ... types) {
        this.name = name;
        this.composite = composite;
        this.types = types;
    }

    public IndexInfo getIndexInfo(JSimpleDB jdb) {
        if (this.composite) {
            return new IndexInfo(jdb, this.types[0], this.name, Arrays.copyOfRange(this.types, 1, this.types.length));
        }
        if (this.types.length == 3) {
            return new IndexInfo(jdb, this.types[0], this.name, this.types[1], this.types[2]);
        }
        return new IndexInfo(jdb, this.types[0], this.name, this.types[1]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IndexInfoKey that = (IndexInfoKey)obj;
        return this.name.equals(that.name) && this.composite == that.composite && Arrays.equals(this.types, that.types);
    }

    public int hashCode() {
        return this.name.hashCode() ^ (this.composite ? 1 : 0) ^ Arrays.hashCode(this.types);
    }
}

