/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.List;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JField;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.schema.ComplexSchemaField;

public abstract class JComplexField
extends JField {
    JComplexField(JSimpleDB jdb, String name, int storageId, String description, Method getter) {
        super(jdb, name, storageId, description, getter);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
    }

    abstract ComplexSchemaField toSchemaItem(JSimpleDB var1);

    public abstract List<JSimpleField> getSubFields();

    public abstract JSimpleField getSubField(String var1);

    JSimpleField getSubField(int storageId) {
        for (JSimpleField subField : this.getSubFields()) {
            if (subField.storageId != storageId) continue;
            return subField;
        }
        throw new IllegalArgumentException("storage ID " + storageId + " not found");
    }

    abstract String getSubFieldName(JSimpleField var1);

    @Override
    final void outputFields(ClassGenerator<?> generator, ClassWriter cw) {
        this.outputCachedValueField(generator, cw);
    }

    @Override
    final void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        this.outputCachedValueGetterMethod(generator, cw, this.getFieldReaderMethod());
    }

    abstract Method getFieldReaderMethod();
}

