/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jsimpledb.JCompositeIndexInfo;
import org.jsimpledb.JSchemaObject;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.schema.AbstractSchemaItem;
import org.jsimpledb.schema.SchemaCompositeIndex;

public class JCompositeIndex
extends JSchemaObject {
    final List<JSimpleField> jfields;

    JCompositeIndex(JSimpleDB jdb, String name, int storageId, JSimpleField ... jfields) {
        super(jdb, name, storageId, "composite index `" + name + "' on fields " + Arrays.asList(jfields));
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"null name");
        Preconditions.checkArgument((jfields.length >= 2 && jfields.length <= 4 ? 1 : 0) != 0, (Object)"invalid field count");
        this.jfields = Collections.unmodifiableList(Arrays.asList(jfields));
    }

    public List<JSimpleField> getJFields() {
        return this.jfields;
    }

    JCompositeIndexInfo toJCompositeIndexInfo() {
        return new JCompositeIndexInfo(this);
    }

    SchemaCompositeIndex toSchemaItem(JSimpleDB jdb) {
        SchemaCompositeIndex schemaIndex = new SchemaCompositeIndex();
        this.initialize(jdb, schemaIndex);
        return schemaIndex;
    }

    void initialize(JSimpleDB jdb, SchemaCompositeIndex schemaIndex) {
        super.initialize(jdb, (AbstractSchemaItem)schemaIndex);
        for (JSimpleField jfield : this.jfields) {
            schemaIndex.getIndexedFields().add(jfield.getStorageId());
        }
    }
}

