/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import org.dellroad.stuff.java.EnumUtil;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.EnumConverter;
import org.jsimpledb.JEnumFieldInfo;
import org.jsimpledb.JFieldSwitch;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JTransaction;
import org.jsimpledb.annotation.JField;
import org.jsimpledb.asm.ClassWriter;
import org.jsimpledb.asm.FieldVisitor;
import org.jsimpledb.asm.MethodVisitor;
import org.jsimpledb.asm.Type;
import org.jsimpledb.core.EnumFieldType;
import org.jsimpledb.core.EnumValue;
import org.jsimpledb.core.FieldType;
import org.jsimpledb.schema.EnumSchemaField;
import org.jsimpledb.schema.SimpleSchemaField;

public class JEnumField
extends JSimpleField {
    final EnumConverter<?> converter;

    JEnumField(JSimpleDB jdb, String name, int storageId, Class<? extends Enum<?>> enumType, JField annotation, String description, Method getter, Method setter) {
        super(jdb, name, storageId, (TypeToken<?>)TypeToken.of(enumType.asSubclass(Enum.class)), (FieldType<?>)new EnumFieldType(enumType), annotation.indexed(), annotation, description, getter, setter);
        this.converter = EnumConverter.createEnumConverter(enumType);
    }

    @Override
    public <R> R visit(JFieldSwitch<R> target) {
        return target.caseJEnumField(this);
    }

    public TypeToken<? extends Enum<?>> getTypeToken() {
        return this.typeToken;
    }

    public Converter<EnumValue, ? extends Enum<?>> getConverter(JTransaction jtx) {
        return this.converter.reverse();
    }

    EnumSchemaField toSchemaItem(JSimpleDB jdb) {
        EnumSchemaField schemaField = new EnumSchemaField();
        this.initialize(jdb, (SimpleSchemaField)schemaField);
        return schemaField;
    }

    @Override
    void initialize(JSimpleDB jdb, SimpleSchemaField schemaField0) {
        super.initialize(jdb, schemaField0);
        EnumSchemaField schemaField = (EnumSchemaField)schemaField0;
        schemaField.getIdentifiers().clear();
        for (Enum value : EnumUtil.getValues((Class)this.getTypeToken().getRawType())) {
            schemaField.getIdentifiers().add(value.name());
        }
    }

    @Override
    JEnumFieldInfo toJFieldInfo(int parentStorageId) {
        return new JEnumFieldInfo(this, parentStorageId);
    }

    @Override
    void outputFields(ClassGenerator<?> generator, ClassWriter cw) {
        FieldVisitor valueField = cw.visitField(26, "$ec" + this.storageId, Type.getDescriptor(EnumConverter.class), null, null);
        valueField.visitEnd();
    }

    @Override
    boolean hasClassInitializerBytecode() {
        return true;
    }

    @Override
    void outputClassInitializerBytecode(ClassGenerator<?> generator, MethodVisitor mv) {
        mv.visitLdcInsn(Type.getType(this.typeToken.getRawType()));
        generator.emitInvoke(mv, ClassGenerator.ENUM_CONVERTER_CREATE_METHOD);
        mv.visitFieldInsn(179, generator.getClassName(), "$ec" + this.storageId, Type.getDescriptor(EnumConverter.class));
    }

    @Override
    void outputMethods(ClassGenerator<?> generator, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(this.getter.getModifiers() & 5, this.getter.getName(), Type.getMethodDescriptor(this.getter), null, generator.getExceptionNames(this.getter));
        mv.visitFieldInsn(178, generator.getClassName(), "$ec" + this.storageId, Type.getDescriptor(EnumConverter.class));
        generator.emitInvoke(mv, ClassGenerator.CONVERTER_REVERSE_METHOD);
        this.outputReadCoreValueBytecode(generator, mv);
        generator.emitInvoke(mv, ClassGenerator.CONVERTER_CONVERT_METHOD);
        mv.visitTypeInsn(192, Type.getInternalName(this.getter.getReturnType()));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(this.setter.getModifiers() & 5, this.setter.getName(), Type.getMethodDescriptor(this.setter), null, generator.getExceptionNames(this.setter));
        mv.visitFieldInsn(178, generator.getClassName(), "$ec" + this.storageId, Type.getDescriptor(EnumConverter.class));
        mv.visitVarInsn(25, 1);
        generator.emitInvoke(mv, ClassGenerator.CONVERTER_CONVERT_METHOD);
        this.outputWriteCoreValueBytecode(generator, mv);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

