/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.HashSet;
import java.util.List;
import org.jsimpledb.AllChangesListener;
import org.jsimpledb.JField;
import org.jsimpledb.JSimpleDB;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.Transaction;

abstract class JFieldInfo {
    final JSimpleDB jdb;
    final int storageId;
    private final HashSet<String> names = new HashSet();
    private boolean requiresDefaultValidation;

    JFieldInfo(JField jfield) {
        Preconditions.checkArgument((jfield != null ? 1 : 0) != 0, (Object)"null jfield");
        this.jdb = jfield.jdb;
        this.storageId = jfield.storageId;
    }

    public int getStorageId() {
        return this.storageId;
    }

    public abstract TypeToken<?> getTypeToken(Class<?> var1);

    public boolean isRequiresDefaultValidation() {
        return this.requiresDefaultValidation;
    }

    public Converter<?, ?> getConverter(JTransaction jtx) {
        return null;
    }

    abstract <T> void addChangeParameterTypes(List<TypeToken<?>> var1, Class<T> var2);

    abstract void registerChangeListener(Transaction var1, int[] var2, Iterable<Integer> var3, AllChangesListener var4);

    void witness(JField jfield) {
        assert (jfield.storageId == this.storageId);
        this.names.add(jfield.name);
        this.requiresDefaultValidation |= jfield.requiresDefaultValidation;
    }

    public String toString() {
        return this.getClass().getSimpleName().replaceAll("^J(.+)FieldInfo", "$1").toLowerCase() + " field " + (this.names.size() == 1 ? "`" + this.names.iterator().next() + "'" : "with storage ID " + this.storageId);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        JFieldInfo that = (JFieldInfo)obj;
        return this.storageId == that.storageId;
    }

    public int hashCode() {
        return this.storageId;
    }
}

