/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.JClass;
import org.jsimpledb.JObject;
import org.jsimpledb.JSimpleDBException;
import org.jsimpledb.JTransaction;
import org.jsimpledb.core.ObjId;

class JObjectCache {
    private final JTransaction jtx;
    private final ThreadLocal<HashMap<ObjId, JObject>> instantiating = new ThreadLocal();
    private final ConcurrentMap<ObjId, JObject> cache = new MapMaker().weakValues().makeMap();

    JObjectCache(JTransaction jtx) {
        this.jtx = jtx;
        assert (this.jtx != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JObject get(ObjId id) {
        JObject jobj;
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        HashMap<ObjId, JObject> currentInvocations = this.instantiating.get();
        if (currentInvocations != null && (jobj = currentInvocations.get(id)) != null) {
            return jobj;
        }
        jobj = (JObject)this.cache.get(id);
        if (jobj == null) {
            ConcurrentMap<ObjId, JObject> concurrentMap = this.cache;
            synchronized (concurrentMap) {
                jobj = (JObject)this.cache.get(id);
                if (jobj == null) {
                    jobj = this.createJObject(id);
                    this.cache.put(id, jobj);
                }
            }
        }
        return jobj;
    }

    void register(JObject jobj) {
        if (jobj == null) {
            return;
        }
        HashMap<ObjId, JObject> currentInvocations = this.instantiating.get();
        if (currentInvocations == null) {
            return;
        }
        ObjId id = jobj.getObjId();
        if (!currentInvocations.containsKey(id)) {
            return;
        }
        JObject previous = currentInvocations.put(jobj.getObjId(), jobj);
        if (previous != null && previous != jobj) {
            throw new IllegalArgumentException("conflicting jobj registration: " + jobj + " != " + previous);
        }
    }

    private JObject createJObject(ObjId id) {
        JClass<?> jclass = this.jtx.jdb.jclasses.get(id.getStorageId());
        ClassGenerator<?> classGenerator = jclass != null ? jclass.getClassGenerator() : this.jtx.jdb.getUntypedClassGenerator();
        HashMap<Object, JObject> currentInvocations = this.instantiating.get();
        boolean cleanup = false;
        if (currentInvocations == null) {
            currentInvocations = new HashMap();
            this.instantiating.set(currentInvocations);
            cleanup = true;
        }
        currentInvocations.put(id, null);
        try {
            JObject jObject = (JObject)classGenerator.getConstructor().newInstance(this.jtx, id);
            return jObject;
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new JSimpleDBException("can't instantiate object for ID " + id, cause);
        }
        finally {
            if (cleanup) {
                this.instantiating.remove();
            } else {
                currentInvocations.remove(id);
            }
        }
    }
}

