/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.jsimpledb.ClassGenerator;
import org.jsimpledb.DefaultStorageIdGenerator;
import org.jsimpledb.IndexInfo;
import org.jsimpledb.IndexInfoKey;
import org.jsimpledb.JClass;
import org.jsimpledb.JCollectionField;
import org.jsimpledb.JComplexField;
import org.jsimpledb.JComplexFieldInfo;
import org.jsimpledb.JCompositeIndexInfo;
import org.jsimpledb.JField;
import org.jsimpledb.JFieldInfo;
import org.jsimpledb.JFieldSwitchAdapter;
import org.jsimpledb.JMapField;
import org.jsimpledb.JObject;
import org.jsimpledb.JReferenceField;
import org.jsimpledb.JSchemaObject;
import org.jsimpledb.JSimpleDBException;
import org.jsimpledb.JSimpleField;
import org.jsimpledb.JSimpleFieldInfo;
import org.jsimpledb.JTransaction;
import org.jsimpledb.ReferencePath;
import org.jsimpledb.ReferencePathCache;
import org.jsimpledb.SnapshotJTransaction;
import org.jsimpledb.StorageIdGenerator;
import org.jsimpledb.UntypedJObject;
import org.jsimpledb.ValidationMode;
import org.jsimpledb.annotation.JCompositeIndex;
import org.jsimpledb.annotation.JSimpleClass;
import org.jsimpledb.core.Database;
import org.jsimpledb.core.ObjId;
import org.jsimpledb.core.SnapshotTransaction;
import org.jsimpledb.core.Transaction;
import org.jsimpledb.core.TypeNotInSchemaVersionException;
import org.jsimpledb.core.UnknownFieldException;
import org.jsimpledb.core.UnknownTypeException;
import org.jsimpledb.kv.KVDatabase;
import org.jsimpledb.kv.KVStore;
import org.jsimpledb.kv.KVTransaction;
import org.jsimpledb.kv.KeyRange;
import org.jsimpledb.kv.KeyRanges;
import org.jsimpledb.kv.simple.SimpleKVDatabase;
import org.jsimpledb.kv.util.NavigableMapKVStore;
import org.jsimpledb.schema.NameIndex;
import org.jsimpledb.schema.SchemaModel;
import org.jsimpledb.schema.SchemaObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSimpleDB {
    public static final String GENERATED_CLASS_NAME_SUFFIX = "$$JSimpleDB";
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final TreeMap<Integer, JClass<?>> jclasses = new TreeMap();
    final HashMap<Class<?>, JClass<?>> jclassesByType = new HashMap();
    final TreeMap<Integer, JFieldInfo> jfieldInfos = new TreeMap();
    final TreeMap<Integer, JCompositeIndexInfo> jcompositeIndexInfos = new TreeMap();
    final ReferencePathCache referencePathCache = new ReferencePathCache(this);
    final ClassGenerator<UntypedJObject> untypedClassGenerator;
    final ArrayList<ClassGenerator<?>> classGenerators;
    final ClassLoader loader = new Loader();
    final Database db;
    final int configuredVersion;
    final StorageIdGenerator storageIdGenerator;
    final boolean hasOnCreateMethods;
    final boolean hasOnDeleteMethods;
    final boolean hasOnVersionChangeMethods;
    final boolean anyJClassRequiresDefaultValidation;
    final AnnotatedElement elementRequiringJSR303Validation;
    ValidatorFactory validatorFactory;
    volatile int actualVersion;
    private final LoadingCache<IndexInfoKey, IndexInfo> indexInfoCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<IndexInfoKey, IndexInfo>(){

        public IndexInfo load(IndexInfoKey key) {
            return key.getIndexInfo(JSimpleDB.this);
        }
    });
    private SchemaModel schemaModel;
    private NameIndex nameIndex;

    public JSimpleDB(Iterable<? extends Class<?>> classes) {
        this(new Database((KVDatabase)new SimpleKVDatabase()), 1, new DefaultStorageIdGenerator(), classes);
    }

    public JSimpleDB(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    /*
     * WARNING - void declaration
     */
    public JSimpleDB(Database database, int version, StorageIdGenerator storageIdGenerator, Iterable<? extends Class<?>> classes) {
        int n;
        JSimpleFieldInfo subFieldInfo;
        JComplexFieldInfo complexFieldInfo;
        JSimpleClass annotation;
        Preconditions.checkArgument((database != null ? 1 : 0) != 0, (Object)"null database");
        Preconditions.checkArgument((version >= 0 ? 1 : 0) != 0, (Object)"invalid negative schema version");
        Preconditions.checkArgument((classes != null ? 1 : 0) != 0, (Object)"null classes");
        this.db = database;
        this.configuredVersion = version;
        this.storageIdGenerator = storageIdGenerator;
        HashSet<void> jsimpleClasses = new HashSet<void>();
        for (Class<?> clazz : classes) {
            void var7_9;
            Class clazz2;
            Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"null class found in classes");
            do {
                if ((annotation = var7_9.getAnnotation(JSimpleClass.class)) == null) continue;
                if (var7_9.isPrimitive() || var7_9.isInterface() || var7_9.isArray()) {
                    throw new IllegalArgumentException("illegal type " + var7_9 + " for @" + JSimpleClass.class.getSimpleName() + " annotation: not a normal class");
                }
                jsimpleClasses.add(var7_9);
            } while ((clazz2 = var7_9.getSuperclass()) != null);
        }
        for (Class<Object> clazz : jsimpleClasses) {
            JClass<Object> jClass;
            int storageId;
            String name;
            annotation = clazz.getAnnotation(JSimpleClass.class);
            String string = name = annotation.name().length() != 0 ? annotation.name() : clazz.getSimpleName();
            if (this.log.isTraceEnabled()) {
                this.log.trace("found @" + JSimpleClass.class.getSimpleName() + " annotation on " + clazz + " defining object type `" + name + "'");
            }
            if ((storageId = annotation.storageId()) == 0) {
                storageId = this.getStorageIdGenerator(annotation, clazz).generateClassStorageId(clazz, name);
            }
            try {
                jClass = this.createJClass(name, storageId, clazz);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("invalid @" + JSimpleClass.class.getSimpleName() + " annotation on " + clazz + ": " + e, e);
            }
            this.addJClass(jClass);
            this.log.debug("added Java model class `" + jClass.name + "' with storage ID " + jClass.storageId);
        }
        this.classGenerators = new ArrayList(this.jclasses.size() + 1);
        for (JClass jClass : this.jclasses.values()) {
            this.classGenerators.add(jClass.classGenerator);
        }
        this.untypedClassGenerator = new ClassGenerator<UntypedJObject>(this, UntypedJObject.class);
        this.classGenerators.add(this.untypedClassGenerator);
        for (JClass jClass : this.jclasses.values()) {
            jClass.createFields(this);
        }
        HashMap<Integer, String> fieldDescriptionMap = new HashMap<Integer, String>();
        for (JClass<?> jclass : this.jclasses.values()) {
            for (JField jfield : jclass.jfields.values()) {
                if (jfield instanceof JComplexField) {
                    JComplexField jComplexField = (JComplexField)jfield;
                    complexFieldInfo = (JComplexFieldInfo)jfield.toJFieldInfo();
                    for (JSimpleField subField : jComplexField.getSubFields()) {
                        this.addJFieldInfo(subField, subField.toJFieldInfo(jfield.storageId), fieldDescriptionMap);
                        subFieldInfo = (JSimpleFieldInfo)this.jfieldInfos.get(subField.storageId);
                        complexFieldInfo.getSubFieldInfos().add(subFieldInfo);
                    }
                    this.addJFieldInfo(jComplexField, complexFieldInfo, fieldDescriptionMap);
                    continue;
                }
                this.addJFieldInfo(jfield, jfield.toJFieldInfo(), fieldDescriptionMap);
            }
        }
        for (JClass<?> jclass : this.jclasses.values()) {
            for (JField jfield : jclass.jfields.values()) {
                if (jfield instanceof JSimpleField) {
                    JSimpleField jSimpleField = (JSimpleField)jfield;
                    JSimpleFieldInfo jsimpleFieldInfo = (JSimpleFieldInfo)this.jfieldInfos.get(jfield.storageId);
                    jsimpleFieldInfo.witness(jSimpleField);
                }
                if (!(jfield instanceof JComplexField)) continue;
                JComplexField jComplexField = (JComplexField)jfield;
                complexFieldInfo = (JComplexFieldInfo)this.jfieldInfos.get(jfield.storageId);
                for (int i = 0; i < jComplexField.getSubFields().size(); ++i) {
                    JSimpleField subField;
                    subField = jComplexField.getSubFields().get(i);
                    subFieldInfo = (JSimpleFieldInfo)this.jfieldInfos.get(subField.storageId);
                    subFieldInfo.witness(subField);
                }
            }
        }
        for (JClass<?> jclass : this.jclasses.values()) {
            for (Class type = jclass.type; type != null; type = type.getSuperclass()) {
                JSimpleClass annotation2 = type.getAnnotation(JSimpleClass.class);
                if (annotation2 == null) continue;
                for (JCompositeIndex indexAnnotation : annotation2.compositeIndexes()) {
                    jclass.addCompositeIndex(this, indexAnnotation);
                }
            }
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (JClass<?> jclass : this.jclasses.values()) {
            for (org.jsimpledb.JCompositeIndex jCompositeIndex : jclass.jcompositeIndexes.values()) {
                JCompositeIndexInfo indexInfo = jCompositeIndex.toJCompositeIndexInfo();
                for (JSimpleField jfield : jCompositeIndex.jfields) {
                    JSimpleFieldInfo jfieldInfo = (JSimpleFieldInfo)this.jfieldInfos.get(jfield.storageId);
                    indexInfo.getJFieldInfos().add(jfieldInfo);
                }
                this.addJCompositeIndexInfo(jCompositeIndex, indexInfo, hashMap);
            }
        }
        for (JClass<?> jclass : this.jclasses.values()) {
            jclass.scanAnnotations();
        }
        for (JClass<?> jclass : this.jclasses.values()) {
            jclass.calculateValidationRequirement();
        }
        boolean anyDefaultValidation = false;
        AnnotatedElement someElementRequiringJSR303Validation = null;
        for (JClass<?> jClass : this.jclasses.values()) {
            anyDefaultValidation |= jClass.requiresDefaultValidation;
            if (someElementRequiringJSR303Validation != null) continue;
            someElementRequiringJSR303Validation = jClass.elementRequiringJSR303Validation;
        }
        this.anyJClassRequiresDefaultValidation = anyDefaultValidation;
        this.elementRequiringJSR303Validation = someElementRequiringJSR303Validation;
        boolean anyOnCreateMethods = false;
        boolean bl = false;
        boolean anyOnVersionChangeMethods = false;
        for (JClass<?> jclass : this.jclasses.values()) {
            anyOnCreateMethods |= !jclass.onCreateMethods.isEmpty();
            n |= !jclass.onDeleteMethods.isEmpty() ? 1 : 0;
            anyOnVersionChangeMethods |= !jclass.onVersionChangeMethods.isEmpty();
        }
        this.hasOnCreateMethods = anyOnCreateMethods;
        this.hasOnDeleteMethods = n;
        this.hasOnVersionChangeMethods = anyOnVersionChangeMethods;
        this.db.validateSchema(this.getSchemaModel());
        this.untypedClassGenerator.generateClass();
        for (JClass<?> jclass : this.jclasses.values()) {
            jclass.getClassGenerator().generateClass();
        }
    }

    private <T> JClass<T> createJClass(String name, int storageId, Class<T> type) {
        return new JClass<T>(this, name, storageId, type);
    }

    StorageIdGenerator getStorageIdGenerator(Annotation annotation, AnnotatedElement target) {
        if (this.storageIdGenerator == null) {
            throw new IllegalArgumentException("invalid @" + annotation.annotationType().getSimpleName() + " annotation on " + target + ": no storage ID is given, but storage ID auto-generation is disabled" + " because no " + StorageIdGenerator.class.getSimpleName() + " is configured");
        }
        return this.storageIdGenerator;
    }

    public Database getDatabase() {
        return this.db;
    }

    public int getConfiguredVersion() {
        return this.configuredVersion;
    }

    public int getActualVersion() {
        return this.actualVersion;
    }

    public static Class<?> getModelClass(JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        for (Class<?> type = jobj.getClass(); type != null; type = type.getSuperclass()) {
            if (type.getName().indexOf(GENERATED_CLASS_NAME_SUFFIX) != -1) continue;
            return type;
        }
        return null;
    }

    public JTransaction createTransaction(boolean allowNewSchema, ValidationMode validationMode) {
        return this.createTransaction(allowNewSchema, validationMode, null);
    }

    public JTransaction createTransaction(boolean allowNewSchema, ValidationMode validationMode, Map<String, ?> kvoptions) {
        return this.createTransaction(this.db.createTransaction(this.getSchemaModel(), this.configuredVersion, allowNewSchema, kvoptions), validationMode);
    }

    public JTransaction createTransaction(KVTransaction kvt, boolean allowNewSchema, ValidationMode validationMode) {
        return this.createTransaction(this.db.createTransaction(kvt, this.getSchemaModel(), this.configuredVersion, allowNewSchema), validationMode);
    }

    private JTransaction createTransaction(Transaction tx, ValidationMode validationMode) {
        assert (tx != null);
        Preconditions.checkArgument((validationMode != null ? 1 : 0) != 0, (Object)"null validationMode");
        this.actualVersion = tx.getSchema().getVersionNumber();
        JTransaction jtx = new JTransaction(this, tx, validationMode);
        tx.addCallback((Transaction.Callback)new CleanupCurrentCallback(jtx));
        return jtx;
    }

    public SnapshotJTransaction createSnapshotTransaction(ValidationMode validationMode) {
        return this.createSnapshotTransaction((KVStore)new NavigableMapKVStore(), true, validationMode);
    }

    public SnapshotJTransaction createSnapshotTransaction(KVStore kvstore, boolean allowNewSchema, ValidationMode validationMode) {
        SnapshotTransaction stx = this.db.createSnapshotTransaction(kvstore, this.getSchemaModel(), this.configuredVersion, allowNewSchema);
        return new SnapshotJTransaction(this, stx, validationMode);
    }

    public SchemaModel getSchemaModel() {
        if (this.schemaModel == null) {
            SchemaModel model = new SchemaModel();
            for (JClass<?> jclass : this.jclasses.values()) {
                SchemaObjectType schemaObjectType = jclass.toSchemaItem(this);
                model.getSchemaObjectTypes().put(schemaObjectType.getStorageId(), schemaObjectType);
            }
            this.schemaModel = model;
            this.log.debug("JSimpleDB schema generated from annotated classes:\n{}", (Object)this.schemaModel);
        }
        return this.schemaModel.clone();
    }

    public NameIndex getNameIndex() {
        if (this.nameIndex == null) {
            this.nameIndex = new NameIndex(this.getSchemaModel());
        }
        return this.nameIndex;
    }

    public SortedMap<Integer, JClass<?>> getJClasses() {
        return Collections.unmodifiableSortedMap(this.jclasses);
    }

    public Map<Class<?>, JClass<?>> getJClassesByType() {
        return Collections.unmodifiableMap(this.jclassesByType);
    }

    public <T> JClass<T> getJClass(Class<T> type) {
        JClass<?> jclass = this.jclassesByType.get(type);
        if (jclass == null) {
            throw new IllegalArgumentException("java model type is not recognized: " + type);
        }
        return jclass;
    }

    public <T> JClass<? super T> findJClass(Class<T> type) {
        for (Class<T> superType = type; superType != null; superType = superType.getSuperclass()) {
            JClass<?> jclass = this.jclassesByType.get(superType);
            if (jclass == null) continue;
            return jclass;
        }
        return null;
    }

    public JClass<?> getJClass(ObjId id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"null id");
        JClass<?> jclass = this.jclasses.get(id.getStorageId());
        if (jclass == null) {
            throw new TypeNotInSchemaVersionException(id, this.actualVersion);
        }
        return jclass;
    }

    public JClass<?> getJClass(int storageId) {
        JClass<?> jclass = this.jclasses.get(storageId);
        if (jclass == null) {
            throw new UnknownTypeException(storageId, this.actualVersion);
        }
        return jclass;
    }

    public <T> List<JClass<? extends T>> getJClasses(Class<T> type) {
        ArrayList<JClass<T>> list = new ArrayList<JClass<T>>();
        for (JClass<?> jclass : this.jclasses.values()) {
            if (type != null && !type.isAssignableFrom(jclass.type)) continue;
            list.add(jclass);
        }
        return list;
    }

    KeyRanges keyRangesFor(Class<?> type) {
        if (type == null) {
            return KeyRanges.FULL;
        }
        ArrayList<KeyRange> list = new ArrayList<KeyRange>(this.jclasses.size());
        for (JClass<?> jclass : this.getJClasses(type)) {
            list.add(ObjId.getKeyRange((int)jclass.storageId));
        }
        return new KeyRanges(list);
    }

    public ReferencePath parseReferencePath(Class<?> startType, String path) {
        return this.parseReferencePath(startType, path, null);
    }

    ReferencePath parseReferencePath(Class<?> startType, String path, Boolean lastIsSubField) {
        return this.referencePathCache.get(startType, path, lastIsSubField);
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        Preconditions.checkArgument((validatorFactory != null ? 1 : 0) != 0, (Object)"null validatorFactory");
        this.validatorFactory = validatorFactory;
    }

    ValidatorFactory getValidatorFactory() {
        if (this.validatorFactory != null) {
            return this.validatorFactory;
        }
        if (this.elementRequiringJSR303Validation == null) {
            return null;
        }
        try {
            this.validatorFactory = Validation.buildDefaultValidatorFactory();
        }
        catch (Exception e) {
            throw new JSimpleDBException("JSR 303 validation constraint found on " + this.elementRequiringJSR303Validation + " but creation of default ValidatorFactory failed; is there a JSR 303 validation implementation on the classpath?", e);
        }
        return this.validatorFactory;
    }

    public Iterable<JObject> getReferencedObjects(final JObject jobj) {
        Preconditions.checkArgument((jobj != null ? 1 : 0) != 0, (Object)"null jobj");
        ObjId id = jobj.getObjId();
        final ArrayList iterables = new ArrayList();
        for (JField jfield : this.getJClass(id).getJFieldsByStorageId().values()) {
            jfield.visit(new JFieldSwitchAdapter<Void>(){

                @Override
                public Void caseJReferenceField(JReferenceField field) {
                    JObject ref = field.getValue(jobj);
                    if (ref != null) {
                        iterables.add(Collections.singleton(ref));
                    }
                    return null;
                }

                @Override
                public Void caseJMapField(JMapField field) {
                    if (field.getKeyField() instanceof JReferenceField) {
                        iterables.add(Iterables.filter(field.getValue(jobj).keySet(), JObject.class));
                    }
                    if (field.getValueField() instanceof JReferenceField) {
                        iterables.add(Iterables.filter(field.getValue(jobj).values(), JObject.class));
                    }
                    return null;
                }

                @Override
                protected Void caseJCollectionField(JCollectionField field) {
                    if (field.getElementField() instanceof JReferenceField) {
                        iterables.add(Iterables.filter((Iterable)field.getValue(jobj), JObject.class));
                    }
                    return null;
                }

                @Override
                protected Void caseJField(JField field) {
                    return null;
                }
            });
        }
        return Iterables.concat(iterables);
    }

    IndexInfo getIndexInfo(IndexInfoKey key) {
        try {
            return (IndexInfo)this.indexInfoCache.getUnchecked((Object)key);
        }
        catch (UncheckedExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw e;
        }
    }

    ClassGenerator<UntypedJObject> getUntypedClassGenerator() {
        return this.untypedClassGenerator;
    }

    <T extends JFieldInfo> T getJFieldInfo(int storageId, Class<T> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"null type");
        JFieldInfo jfieldInfo = this.jfieldInfos.get(storageId);
        if (jfieldInfo == null) {
            throw new UnknownFieldException(storageId, "no JSimpleDB field exists with storage ID " + storageId + " in schema version " + this.actualVersion);
        }
        try {
            return (T)((JFieldInfo)type.cast(jfieldInfo));
        }
        catch (ClassCastException e) {
            throw new UnknownFieldException(storageId, "no JSimpleDB fields exist with storage ID " + storageId + " in schema version " + this.actualVersion + " (found field " + jfieldInfo + " instead)");
        }
    }

    private void addJClass(JClass<?> jclass) {
        JClass<?> other = this.jclasses.get(jclass.storageId);
        if (other != null) {
            throw new IllegalArgumentException("illegal duplicate use of storage ID " + jclass.storageId + " for both " + other + " and " + jclass);
        }
        this.jclasses.put(jclass.storageId, jclass);
        assert (!this.jclassesByType.containsKey(jclass.type));
        this.jclassesByType.put(jclass.type, jclass);
    }

    private <T extends JFieldInfo> void addJFieldInfo(JField jfield, T fieldInfo, Map<Integer, String> descriptionMap) {
        this.addInfo(jfield, fieldInfo, this.jfieldInfos, descriptionMap);
    }

    private void addJCompositeIndexInfo(org.jsimpledb.JCompositeIndex index, JCompositeIndexInfo indexInfo, Map<Integer, String> descriptionMap) {
        this.addInfo(index, indexInfo, this.jcompositeIndexInfos, descriptionMap);
    }

    private <T> void addInfo(JSchemaObject item, T info, Map<Integer, T> infoMap, Map<Integer, String> descriptionMap) {
        T existing = infoMap.get(item.storageId);
        if (existing == null) {
            infoMap.put(item.storageId, info);
            descriptionMap.put(item.storageId, item.description);
        } else if (!info.equals(existing)) {
            throw new IllegalArgumentException("incompatible duplicate use of storage ID " + item.storageId + " for " + descriptionMap.get(item.storageId) + " and " + item.description);
        }
    }

    private static final class CleanupCurrentCallback
    extends Transaction.CallbackAdapter {
        private final JTransaction jtx;

        CleanupCurrentCallback(JTransaction jtx) {
            assert (jtx != null);
            this.jtx = jtx;
        }

        public void afterCompletion(boolean committed) {
            JTransaction current;
            try {
                current = JTransaction.getCurrent();
            }
            catch (IllegalStateException e) {
                return;
            }
            if (current == this.jtx) {
                JTransaction.setCurrent(null);
            }
        }

        public int hashCode() {
            return this.jtx.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            CleanupCurrentCallback that = (CleanupCurrentCallback)((Object)obj);
            return this.jtx.equals(that.jtx);
        }
    }

    private class Loader
    extends ClassLoader {
        Loader() {
            super(Thread.currentThread().getContextClassLoader());
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] bytes = null;
            for (ClassGenerator<?> generator : JSimpleDB.this.classGenerators) {
                if (!name.equals(generator.getClassName().replace('/', '.'))) continue;
                bytes = generator.generateBytecode();
                break;
            }
            return bytes != null ? this.defineClass(name, bytes, 0, bytes.length) : super.findClass(name);
        }
    }
}

