/*
 * Decompiled with CFR 0.152.
 */
package org.jsimpledb;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.List;
import org.jsimpledb.util.ConvertedList;

class ListConverter<E, W>
extends Converter<List<E>, List<W>> {
    private final Converter<E, W> elementConverter;

    ListConverter(Converter<E, W> elementConverter) {
        Preconditions.checkArgument((elementConverter != null ? 1 : 0) != 0, (Object)"null elementConverter");
        this.elementConverter = elementConverter;
    }

    protected List<W> doForward(List<E> set) {
        if (set == null) {
            return null;
        }
        return new ConvertedList(set, this.elementConverter.reverse());
    }

    protected List<E> doBackward(List<W> set) {
        if (set == null) {
            return null;
        }
        return new ConvertedList(set, this.elementConverter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ListConverter that = (ListConverter)((Object)obj);
        return this.elementConverter.equals(that.elementConverter);
    }

    public int hashCode() {
        return this.elementConverter.hashCode();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[elementConverter=" + this.elementConverter + "]";
    }
}

